/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IconTheme {
    public static Font FONT;
    public static Font FONT_16;
    public static final Color DEFAULT_COLOR;
    public static final Color DEFAULT_DISABLED_COLOR;
    public static final int DEFAULT_SIZE = 24;
    public static final int SMALL_SIZE = 16;
    private static final Map<String, String> KEY_TO_ICON;
    private static final String DEFAULT_ICON_PATH = "/images/external/red.png";
    private static final Log LOGGER;

    public static ImageIcon getImage(String name) {
        return new ImageIcon(IconTheme.getIconUrl(name));
    }

    public static URL getIconUrl(String name) {
        String key = Objects.requireNonNull(name, "icon name");
        if (!KEY_TO_ICON.containsKey(key)) {
            LOGGER.warn("Could not find icon url by name " + name + ", so falling back on default icon " + DEFAULT_ICON_PATH);
        }
        String path = KEY_TO_ICON.getOrDefault(key, DEFAULT_ICON_PATH);
        return Objects.requireNonNull(IconTheme.class.getResource(path), "Path must not be null for key " + key);
    }

    private static Map<String, String> readIconThemeFile(URL url, String prefix) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(prefix, "prefix");
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains("=")) continue;
                int index = line.indexOf(61);
                String key = line.substring(0, index).trim();
                String value = prefix + line.substring(index + 1).trim();
                result.put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read default icon theme.", e);
        }
        return result;
    }

    static {
        DEFAULT_COLOR = new Color(79, 95, 143);
        DEFAULT_DISABLED_COLOR = new Color(200, 200, 200);
        KEY_TO_ICON = IconTheme.readIconThemeFile(IconTheme.class.getResource("/images/Icons.properties"), "/images/external/");
        LOGGER = LogFactory.getLog(IconTheme.class);
        try (InputStream stream = FontBasedIcon.class.getResourceAsStream("/fonts/materialdesignicons-webfont.ttf");){
            FONT = Font.createFont(0, stream);
            FONT_16 = FONT.deriveFont(0, 16.0f);
        }
        catch (FontFormatException | IOException e) {
            LOGGER.warn("Error loading font", e);
        }
    }

    public static class FontBasedIcon
    implements Icon {
        private final String iconCode;
        private final Color iconColor;
        private final int size;

        public FontBasedIcon(String code, Color iconColor) {
            this.iconCode = code;
            this.iconColor = iconColor;
            this.size = 24;
        }

        public FontBasedIcon(String code, Color iconColor, int size) {
            this.iconCode = code;
            this.iconColor = iconColor;
            this.size = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHints(rh);
            g2.setFont(FONT.deriveFont(0, this.size));
            g2.setColor(this.iconColor);
            FontMetrics fm = g2.getFontMetrics();
            g2.translate(x, y + fm.getAscent());
            g2.drawString(this.iconCode, 0, 0);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        public FontBasedIcon createDisabledIcon() {
            return new FontBasedIcon(this.iconCode, DEFAULT_DISABLED_COLOR, this.size);
        }

        public FontBasedIcon createSmallIcon() {
            return new FontBasedIcon(this.iconCode, this.iconColor, 16);
        }

        public FontBasedIcon createWithNewColor(Color newColor) {
            return new FontBasedIcon(this.iconCode, newColor, this.size);
        }
    }

    public static enum JabRefIcon {
        ADD("\uf416"),
        ADD_NOBOX("\uf415"),
        ADD_ENTRY("\uf527"),
        EDIT_ENTRY("\uf524"),
        EDIT_STRINGS("\uf528"),
        FOLDER("\uf24b"),
        REMOVE("\uf375"),
        REMOVE_NOBOX("\uf374"),
        FILE("\uf214"),
        PDF_FILE("\uf225"),
        DOI("\uf072"),
        DUPLICATE("\uf191"),
        EDIT("\uf3eb"),
        NEW("\uf224"),
        SAVE("\uf193"),
        SAVE_ALL("\uf194"),
        CLOSE("\uf156"),
        PASTE("\uf192"),
        CUT("\uf190"),
        COPY("\uf18f"),
        REDO("\uf44e"),
        UNDO("\uf54c"),
        MARK_ENTRIES("\uf0c0"),
        UNMARK_ENTRIES("\uf0c3"),
        REFRESH("\uf450"),
        DELETE_ENTRY("\uf1c0"),
        SEARCH("\uf349"),
        PREFERENCES("\uf493"),
        HELP("\uf2d7"),
        UP("\uf143"),
        DOWN("\uf140"),
        LEFT("\uf04e"),
        RIGHT("\uf055"),
        SOURCE("\uf169"),
        MAKE_KEY("\uf30b"),
        CLEANUP_ENTRIES("\uf0e2"),
        PRIORITY("\uf23b"),
        PRIORITY_HIGH("\uf23b", Color.RED),
        PRIORITY_MEDIUM("\uf23b", Color.ORANGE),
        PRIORITY_LOW("\uf23b", new Color(111, 204, 117)),
        PRINTED("\uf42a"),
        RANKING("\uf4ce"),
        RANK1("\uf4ce\uf4d2\uf4d2\uf4d2\uf4d2"),
        RANK2("\uf4ce\uf4ce\uf4d2\uf4d2\uf4d2"),
        RANK3("\uf4ce\uf4ce\uf4ce\uf4d2\uf4d2"),
        RANK4("\uf4ce\uf4ce\uf4ce\uf4ce\uf4d2"),
        RANK5("\uf4ce\uf4ce\uf4ce\uf4ce\uf4ce"),
        WWW("\uf59f"),
        GROUP_INCLUDING("\uf233"),
        GROUP_REFINING("\uf232"),
        AUTO_GROUP("\uf068"),
        EMAIL("\uf1ee"),
        EXPORT_TO_CLIPBOARD("\uf14b"),
        ATTACH_FILE("\uf3e2"),
        AUTO_FILE_LINK("\uf21e"),
        QUALITY_ASSURED("\uf124"),
        QUALITY("\uf124"),
        OPEN("\uf24b"),
        ADD_ROW("\uf490"),
        REMOVE_ROW("\uf48c"),
        PICTURE("\uf21f"),
        READ_STATUS_READ("\uf208", new Color(111, 204, 117)),
        READ_STATUS_SKIMMED("\uf208", Color.ORANGE),
        READ_STATUS("\uf208"),
        RELEVANCE("\uf4cf"),
        MERGE_ENTRIES("\uf18a"),
        CONNECT_OPEN_OFFICE("\uf3cb"),
        PLAIN_TEXT_IMPORT_TODO("\uf130"),
        PLAIN_TEXT_IMPORT_DONE("\uf134"),
        DONATE("\uf2a1"),
        MOVE_TAB_ARROW("\uf05e"),
        OPTIONAL("\uf316"),
        REQUIRED("\uf315"),
        INTEGRITY_FAIL("\uf159", Color.RED),
        INTEGRITY_INFO("\uf2fc"),
        INTEGRITY_WARN("\uf028"),
        INTEGRITY_SUCCESS("\uf134"),
        GITHUB("\uf2a4"),
        TOGGLE_ENTRY_PREVIEW("\uf332"),
        TOGGLE_GROUPS("\uf572"),
        WRITE_XMP("\uf2fa"),
        FILE_WORD("\uf22c"),
        FILE_EXCEL("\uf21b"),
        FILE_POWERPOINT("\uf227"),
        FILE_TEXT("\uf219"),
        FILE_MULTIPLE("\uf222"),
        KEY_BINDINGS("\uf30c"),
        FIND_DUPLICATES("\uf16b"),
        PULL("\uf4c2"),
        OPEN_IN_NEW_WINDOW("\uf3cc"),
        CASE_SENSITIVE("\uf02c"),
        REG_EX("\uf451"),
        CONSOLE("\uf18d"),
        FORUM("\uf28c"),
        FACEBOOK("\uf20c"),
        BLOG("\uf46b"),
        GLOBAL_SEARCH("\uf1e7"),
        GROUP_REGULAR("\uf4e6", Color.RED);

        private final String code;
        private final Color color;

        private JabRefIcon(String code) {
            this(code, DEFAULT_COLOR);
        }

        private JabRefIcon(String code, Color color) {
            this.code = code;
            this.color = color;
        }

        public FontBasedIcon getIcon() {
            return new FontBasedIcon(this.code, this.color);
        }

        public FontBasedIcon getSmallIcon() {
            return new FontBasedIcon(this.code, this.color, 16);
        }

        public String getCode() {
            return this.code;
        }
    }
}

