/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.keyboard.EmacsKeyBindings;
import net.sf.jabref.gui.specialfields.SpecialFieldViewModel;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GUIGlobals {
    private static final Log LOGGER = LogFactory.getLog(GUIGlobals.class);
    public static final String UNTITLED_TITLE = Localization.lang("untitled", new String[0]);
    public static Font currentFont;
    private static final Map<String, JLabel> TABLE_ICONS;
    public static final Color ENTRY_EDITOR_LABEL_COLOR;
    static final Color ACTIVE_TABBED_COLOR;
    static final Color INACTIVE_TABBED_COLOR;
    public static Color editorTextColor;
    public static Color validFieldBackgroundColor;
    public static Color activeBackgroundColor;
    public static Color invalidFieldBackgroundColor;
    public static final Color NULL_FIELD_COLOR;
    public static final Color ACTIVE_EDITOR_COLOR;
    public static final int WIDTH_ICON_COL = 26;
    public static final int WIDTH_ICON_COL_RANKING = 80;
    public static final int MAX_BACK_HISTORY_SIZE = 10;

    public static JLabel getTableIcon(String fieldType) {
        JLabel label = TABLE_ICONS.get(fieldType);
        if (label == null) {
            LOGGER.info("Error: no table icon defined for type '" + fieldType + "'.");
            return null;
        }
        return label;
    }

    public static void updateEntryEditorColors() {
        activeBackgroundColor = JabRefPreferences.getInstance().getColor("activeFieldEditorBackgroundColor");
        validFieldBackgroundColor = JabRefPreferences.getInstance().getColor("validFieldBackgroundColor");
        invalidFieldBackgroundColor = JabRefPreferences.getInstance().getColor("invalidFieldBackgroundColor");
        editorTextColor = JabRefPreferences.getInstance().getColor("fieldEditorTextColor");
    }

    public static void init() {
        JLabel label = new JLabel(IconTheme.JabRefIcon.PDF_FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " PDF");
        TABLE_ICONS.put("pdf", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " URL");
        TABLE_ICONS.put("url", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " CiteSeer URL");
        TABLE_ICONS.put("citeseerurl", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " ArXiv URL");
        TABLE_ICONS.put("eprint", label);
        label = new JLabel(IconTheme.JabRefIcon.DOI.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " DOI " + Localization.lang("web link", new String[0]));
        TABLE_ICONS.put("doi", label);
        label = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " PS");
        TABLE_ICONS.put("ps", label);
        label = new JLabel(IconTheme.JabRefIcon.FOLDER.getSmallIcon());
        label.setToolTipText(Localization.lang("Open folder", new String[0]));
        TABLE_ICONS.put("folder", label);
        label = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open file", new String[0]));
        TABLE_ICONS.put("file", label);
        for (ExternalFileType fileType : ExternalFileTypes.getInstance().getExternalFileTypeSelection()) {
            label = new JLabel(fileType.getIcon());
            label.setToolTipText(Localization.lang("Open %0 file", fileType.getName()));
            TABLE_ICONS.put(fileType.getName(), label);
        }
        SpecialFieldViewModel relevanceViewModel = new SpecialFieldViewModel(SpecialField.RELEVANCE);
        label = new JLabel(relevanceViewModel.getRepresentingIcon());
        label.setToolTipText(relevanceViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.RELEVANCE.getFieldName(), label);
        SpecialFieldViewModel qualityViewModel = new SpecialFieldViewModel(SpecialField.QUALITY);
        label = new JLabel(qualityViewModel.getRepresentingIcon());
        label.setToolTipText(qualityViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.QUALITY.getFieldName(), label);
        SpecialFieldViewModel rankViewModel = new SpecialFieldViewModel(SpecialField.RANKING);
        label = new JLabel(rankViewModel.getRepresentingIcon());
        label.setToolTipText(rankViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.RANKING.getFieldName(), label);
        SpecialFieldViewModel priorityViewModel = new SpecialFieldViewModel(SpecialField.PRIORITY);
        label = new JLabel(priorityViewModel.getRepresentingIcon());
        label.setToolTipText(priorityViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.PRIORITY.getFieldName(), label);
        SpecialFieldViewModel readViewModel = new SpecialFieldViewModel(SpecialField.READ_STATUS);
        label = new JLabel(readViewModel.getRepresentingIcon());
        label.setToolTipText(readViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.READ_STATUS.getFieldName(), label);
        SpecialFieldViewModel printedViewModel = new SpecialFieldViewModel(SpecialField.PRINTED);
        label = new JLabel(printedViewModel.getRepresentingIcon());
        label.setToolTipText(printedViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.PRINTED.getFieldName(), label);
        if (Globals.prefs.getBoolean("editorEMACSkeyBindings")) {
            EmacsKeyBindings.load();
        }
        GUIGlobals.updateEntryEditorColors();
        currentFont = new Font(Globals.prefs.get("fontFamily"), Globals.prefs.getInt("fontStyle"), Globals.prefs.getInt("fontSize"));
    }

    static {
        TABLE_ICONS = new HashMap<String, JLabel>();
        ENTRY_EDITOR_LABEL_COLOR = new Color(100, 100, 150);
        ACTIVE_TABBED_COLOR = ENTRY_EDITOR_LABEL_COLOR.darker();
        INACTIVE_TABBED_COLOR = Color.black;
        NULL_FIELD_COLOR = new Color(75, 130, 95);
        ACTIVE_EDITOR_COLOR = new Color(230, 230, 255);
    }
}

