/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;

public class FileDialog {
    private final JFileChooser fileChooser = new JFileChooser(){

        @Override
        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file.exists() && this.getDialogType() == 1) {
                int result = JOptionPane.showConfirmDialog(this, Localization.lang("'%0' exists. Overwrite file?", file.getName()), Localization.lang("Existing file", new String[0]), 1);
                switch (result) {
                    case 0: {
                        super.approveSelection();
                        return;
                    }
                    case 1: {
                        return;
                    }
                    case -1: {
                        return;
                    }
                    case 2: {
                        this.cancelSelection();
                        return;
                    }
                }
                return;
            }
            super.approveSelection();
        }
    };
    private final Component parent;
    private final String directory;
    private Collection<FileExtensions> extensions = EnumSet.noneOf(FileExtensions.class);

    public FileDialog(Component parent) {
        this(parent, FileDialog.getWorkingDir());
    }

    public FileDialog(Component parent, String dir) {
        Objects.requireNonNull(dir, "Directory must not be null");
        this.parent = parent;
        this.directory = dir;
        this.fileChooser.setCurrentDirectory(Paths.get(dir, new String[0]).toFile());
    }

    public FileDialog withExtension(FileExtensions singleExt) {
        this.withExtensions(EnumSet.of(singleExt));
        return this;
    }

    public FileDialog withExtensions(Collection<FileExtensions> fileExtensions) {
        this.extensions = fileExtensions;
        for (FileExtensions ext : fileExtensions) {
            FileNameExtensionFilter extFilter = new FileNameExtensionFilter(ext.getDescription(), ext.getExtensions());
            this.fileChooser.addChoosableFileFilter(extFilter);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
        }
        return this;
    }

    public void setDefaultExtension(FileExtensions extension) {
        Arrays.stream(this.fileChooser.getChoosableFileFilters()).filter(f -> Objects.equals(f.getDescription(), extension.getDescription())).findFirst().ifPresent(this.fileChooser::setFileFilter);
    }

    public FileFilter getFileFilter() {
        return this.fileChooser.getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        this.fileChooser.setFileFilter(filter);
    }

    public FileDialog updateWorkingDirPref() {
        Globals.prefs.put("workingDirectory", this.directory);
        return this;
    }

    public Optional<Path> showDialogAndGetSelectedDirectory() {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(Localization.lang("Select directory", new String[0]));
        this.fileChooser.setApproveButtonText(Localization.lang("Select", new String[0]));
        this.fileChooser.setApproveButtonToolTipText(Localization.lang("Select directory", new String[0]));
        return this.showDialogAndGetSelectedFile();
    }

    public List<String> showDialogAndGetMultipleFiles() {
        this.fileChooser.setDialogType(0);
        this.fileChooser.setMultiSelectionEnabled(true);
        if (this.showDialogAndIsAccepted()) {
            List<String> files = Arrays.stream(this.fileChooser.getSelectedFiles()).map(File::toString).collect(Collectors.toList());
            return files;
        }
        return Collections.emptyList();
    }

    public Optional<Path> showDialogAndGetSelectedFile() {
        this.fileChooser.setDialogType(0);
        if (this.showDialogAndIsAccepted()) {
            return Optional.of(this.fileChooser.getSelectedFile().toPath());
        }
        return Optional.empty();
    }

    public Optional<Path> saveNewFile() {
        this.fileChooser.setDialogType(1);
        if (this.showDialogAndIsAccepted()) {
            File file = this.fileChooser.getSelectedFile();
            if (!this.extensions.isEmpty() && !this.fileChooser.accept(file)) {
                return Optional.of(Paths.get(file.getPath() + this.extensions.iterator().next().getFirstExtensionWithDot(), new String[0]));
            }
            return Optional.of(file.toPath());
        }
        return Optional.empty();
    }

    private boolean showDialogAndIsAccepted() {
        return this.fileChooser.showDialog(this.parent, null) == 0;
    }

    private static String getWorkingDir() {
        return Globals.prefs.get("workingDirectory");
    }
}

