/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FieldSetComponent;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.entry.EntryType;

public class EntryTypeList
extends FieldSetComponent
implements ListSelectionListener {
    private final JButton def = new JButton(Localization.lang("Default", new String[0]));
    private final BibDatabaseMode mode;

    public EntryTypeList(List<String> fields, BibDatabaseMode mode) {
        super(Localization.lang("Entry types", new String[0]), fields, false, true);
        this.mode = mode;
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.fill = 3;
        this.con.anchor = 13;
        this.gbl.setConstraints(this.def, this.con);
        this.add(this.def);
        this.list.addListSelectionListener(this);
        this.def.addActionListener(this);
        this.def.setEnabled(false);
        this.remove.setEnabled(false);
    }

    @Override
    protected void addField(String str) {
        String s = str.trim();
        if (this.forceLowerCase) {
            s = s.toLowerCase();
        }
        if ("".equals(s) || this.listModel.contains(s)) {
            return;
        }
        String testString = BibtexKeyPatternUtil.checkLegalKey(s, Globals.prefs.getBoolean("enforceLegalBibtexKey"));
        if (!testString.equals(s) || s.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Localization.lang("Entry type names are not allowed to contain white space or the following characters", new String[0]) + ": # { } ~ , ^ &", Localization.lang("Error", new String[0]), 0);
            return;
        }
        if ("comment".equalsIgnoreCase(s)) {
            JOptionPane.showMessageDialog(this, Localization.lang("The name 'comment' cannot be used as an entry type name.", new String[0]), Localization.lang("Error", new String[0]), 0);
            return;
        }
        this.addFieldUncritically(s);
    }

    @Override
    protected void removeSelected() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            String typeName = (String)this.listModel.get(selected[selected.length - 1 - i]);
            Optional<EntryType> type = EntryTypes.getType(typeName, this.mode);
            if (type.isPresent() && type.get() instanceof CustomEntryType) {
                this.listModel.removeElementAt(selected[selected.length - 1 - i]);
                continue;
            }
            JOptionPane.showMessageDialog(null, Localization.lang("This entry type cannot be removed.", new String[0]), Localization.lang("Remove entry type", new String[0]), 0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void enable(String typeName, boolean isChanged) {
        if (EntryTypes.getStandardType(typeName, this.mode).isPresent()) {
            Optional<EntryType> entryType = EntryTypes.getType(typeName, this.mode);
            if (isChanged || entryType.isPresent() && entryType.get() instanceof CustomEntryType) {
                this.def.setEnabled(true);
            } else {
                this.def.setEnabled(false);
            }
            this.remove.setEnabled(false);
        } else {
            this.def.setEnabled(false);
            this.remove.setEnabled(true);
        }
    }

    public void addDefaultActionListener(ActionListener l) {
        this.def.addActionListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.def) {
            this.def.setEnabled(false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        this.def.setEnabled(en);
    }
}

