/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.importer.fetcher.EntryFetchers;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.CustomEntryTypesManager;
import net.sf.jabref.logic.importer.FetcherException;
import net.sf.jabref.logic.importer.IdBasedFetcher;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.IEEETranEntryTypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.VerticalLayout;

public class EntryTypeDialog
extends JDialog
implements ActionListener {
    private static final Log LOGGER = LogFactory.getLog(EntryTypeDialog.class);
    private EntryType type;
    private SwingWorker<Optional<BibEntry>, Void> fetcherWorker = new FetcherWorker();
    private JButton generateButton;
    private JTextField idTextField;
    private JComboBox<String> comboBox;
    private final JabRefFrame frame;
    private static final int COLUMN = 3;
    private final boolean biblatexMode;
    private final CancelAction cancelAction = new CancelAction();
    private final BibDatabaseContext bibDatabaseContext;

    public EntryTypeDialog(JabRefFrame frame) {
        super((Frame)frame, true);
        this.frame = frame;
        this.bibDatabaseContext = frame.getCurrentBasePanel().getBibDatabaseContext();
        this.biblatexMode = this.bibDatabaseContext.isBiblatexMode();
        this.setTitle(Localization.lang("Select entry type", new String[0]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EntryTypeDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createCancelButtonBarPanel(), "South");
        this.getContentPane().add((Component)this.createEntryGroupsPanel(), "Center");
        this.pack();
        this.setResizable(false);
    }

    private JPanel createEntryGroupsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout());
        if (this.biblatexMode) {
            panel.add(this.createEntryGroupPanel("BibLateX", EntryTypes.getAllValues(this.bibDatabaseContext.getMode())));
        } else {
            panel.add(this.createEntryGroupPanel("BibTeX", BibtexEntryTypes.ALL));
            panel.add(this.createEntryGroupPanel("IEEETran", IEEETranEntryTypes.ALL));
            if (!CustomEntryTypesManager.ALL.isEmpty()) {
                panel.add(this.createEntryGroupPanel(Localization.lang("Custom", new String[0]), CustomEntryTypesManager.ALL));
            }
        }
        panel.add(this.createIdFetcherPanel());
        return panel;
    }

    private JPanel createCancelButtonBarPanel() {
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(this);
        cancel.getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        cancel.getActionMap().put("close", this.cancelAction);
        JPanel buttons = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        bb.addGlue();
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        return buttons;
    }

    private JPanel createEntryGroupPanel(String groupTitle, Collection<EntryType> entries) {
        JPanel panel = new JPanel();
        GridBagLayout bagLayout = new GridBagLayout();
        panel.setLayout(bagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(4, 4, 4, 4);
        int col = 0;
        for (EntryType entryType : entries) {
            TypeButton entryButton = new TypeButton(entryType.getName(), entryType);
            entryButton.addActionListener(this);
            if (++col == 3) {
                col = 0;
                constraints.gridwidth = 0;
            } else {
                constraints.gridwidth = 1;
            }
            bagLayout.setConstraints(entryButton, constraints);
            panel.add(entryButton);
        }
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), groupTitle));
        return panel;
    }

    private JPanel createIdFetcherPanel() {
        JLabel fetcherLabel = new JLabel(Localization.lang("ID type", new String[0]));
        JLabel idLabel = new JLabel(Localization.lang("ID", new String[0]));
        this.generateButton = new JButton(Localization.lang("Generate", new String[0]));
        this.idTextField = new JTextField("");
        this.comboBox = new JComboBox();
        EntryFetchers.getIdFetchers().forEach(fetcher -> this.comboBox.addItem(fetcher.getName()));
        this.generateButton.addActionListener(action -> this.fetcherWorker.execute());
        this.comboBox.addActionListener(e -> {
            this.idTextField.requestFocus();
            this.idTextField.selectAll();
        });
        this.idTextField.addActionListener(event -> this.fetcherWorker.execute());
        JPanel jPanel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(4, 4, 4, 4);
        GridBagLayout layout = new GridBagLayout();
        jPanel.setLayout(layout);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        jPanel.add((Component)fetcherLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 2.0;
        jPanel.add(this.comboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        jPanel.add((Component)idLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 2.0;
        jPanel.add((Component)this.idTextField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        jPanel.add((Component)this.generateButton, constraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("ID-based_entry_generator", new String[0])));
        SwingUtilities.invokeLater(() -> this.idTextField.requestFocus());
        return jPanel;
    }

    private void stopFetching() {
        if (this.fetcherWorker.getState() == SwingWorker.StateValue.STARTED) {
            this.fetcherWorker.cancel(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TypeButton) {
            this.type = ((TypeButton)e.getSource()).getType();
        }
        this.stopFetching();
        this.dispose();
    }

    public EntryType getChoice() {
        return this.type;
    }

    private class FetcherWorker
    extends SwingWorker<Optional<BibEntry>, Void> {
        private boolean fetcherException = false;
        private String fetcherExceptionMessage = "";
        private IdBasedFetcher fetcher = null;
        private String searchID = "";

        private FetcherWorker() {
        }

        @Override
        protected Optional<BibEntry> doInBackground() throws Exception {
            Optional<BibEntry> bibEntry = Optional.empty();
            SwingUtilities.invokeLater(() -> {
                EntryTypeDialog.this.generateButton.setEnabled(false);
                EntryTypeDialog.this.generateButton.setText(Localization.lang("Searching...", new String[0]));
            });
            this.searchID = EntryTypeDialog.this.idTextField.getText().trim();
            this.fetcher = EntryFetchers.getIdFetchers().get(EntryTypeDialog.this.comboBox.getSelectedIndex());
            if (!this.searchID.isEmpty()) {
                try {
                    bibEntry = this.fetcher.performSearchById(this.searchID);
                }
                catch (FetcherException e) {
                    LOGGER.error(e.getMessage(), e);
                    this.fetcherException = true;
                    this.fetcherExceptionMessage = e.getMessage();
                }
            }
            return bibEntry;
        }

        @Override
        protected void done() {
            try {
                Optional result = (Optional)this.get();
                if (result.isPresent()) {
                    EntryTypeDialog.this.frame.getCurrentBasePanel().insertEntry((BibEntry)result.get());
                    EntryTypeDialog.this.dispose();
                } else if (this.searchID.trim().isEmpty()) {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("The given search ID was empty.", new String[0]), Localization.lang("Empty search ID", new String[0]), 2);
                } else if (!this.fetcherException) {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("Fetcher_'%0'_did_not_find_an_entry_for_id_'%1'.", this.fetcher.getName(), this.searchID) + "\n" + this.fetcherExceptionMessage, Localization.lang("No files found.", new String[0]), 2);
                } else {
                    JOptionPane.showMessageDialog(EntryTypeDialog.this.frame, Localization.lang("Error while fetching from %0", this.fetcher.getName()) + "." + "\n" + this.fetcherExceptionMessage, Localization.lang("Error", new String[0]), 0);
                }
                EntryTypeDialog.this.fetcherWorker = new FetcherWorker();
                SwingUtilities.invokeLater(() -> {
                    EntryTypeDialog.this.idTextField.requestFocus();
                    EntryTypeDialog.this.idTextField.selectAll();
                    EntryTypeDialog.this.generateButton.setText(Localization.lang("Generate", new String[0]));
                    EntryTypeDialog.this.generateButton.setEnabled(true);
                });
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(String.format("Exception during fetching when using fetcher '%s' with entry id '%s'.", this.searchID, this.fetcher.getName()), e);
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryTypeDialog.this.stopFetching();
            EntryTypeDialog.this.dispose();
        }
    }

    static class TypeButton
    extends JButton
    implements Comparable<TypeButton> {
        private final EntryType type;

        TypeButton(String label, EntryType type) {
            super(label);
            this.type = type;
        }

        @Override
        public int compareTo(TypeButton o) {
            return this.type.getName().compareTo(o.type.getName());
        }

        public EntryType getType() {
            return this.type;
        }
    }
}

