/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.preferences.JabRefPreferences;

public class EntryMarker {
    public static final int MARK_COLOR_LEVELS = 6;
    public static final int MAX_MARKING_LEVEL = 5;
    public static final int IMPORT_MARK_LEVEL = 6;
    private static final Pattern MARK_NUMBER_PATTERN = Pattern.compile(JabRefPreferences.getInstance().MARKING_WITH_NUMBER_PATTERN);

    public static void markEntry(BibEntry be, int markIncrement, boolean increment, NamedCompound ce) {
        String newValue = null;
        if (be.hasField("__markedentry")) {
            String markerString = be.getField("__markedentry").get();
            int index = markerString.indexOf(Globals.prefs.getWrappedUsername());
            if (index >= 0) {
                int prevMarkLevel = 1;
                newValue = markerString.substring(0, index) + markerString.substring(index + Globals.prefs.getWrappedUsername().length()) + Globals.prefs.getWrappedUsername().substring(0, Globals.prefs.getWrappedUsername().length() - 1) + ":" + (increment ? Math.min(5, prevMarkLevel + markIncrement) : markIncrement) + "]";
            } else {
                Matcher m = MARK_NUMBER_PATTERN.matcher(markerString);
                if (m.find()) {
                    try {
                        int prevMarkLevel = Integer.parseInt(m.group(1));
                        newValue = markerString.substring(0, m.start(1)) + (increment ? Math.min(5, prevMarkLevel + markIncrement) : markIncrement) + markerString.substring(m.end(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (newValue == null) {
            newValue = Globals.prefs.getWrappedUsername().substring(0, Globals.prefs.getWrappedUsername().length() - 1) + ":" + markIncrement + "]";
        }
        ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry").orElse(null), newValue));
        be.setField("__markedentry", newValue);
    }

    public static void unmarkEntry(BibEntry be, boolean onlyMaxLevel, BibDatabase database, NamedCompound ce) {
        if (be.hasField("__markedentry")) {
            String newValue;
            block15: {
                String markerString = be.getField("__markedentry").get();
                if ("0".equals(markerString)) {
                    if (!onlyMaxLevel) {
                        EntryMarker.unmarkOldStyle(be, database, ce);
                    }
                    return;
                }
                newValue = null;
                int index = markerString.indexOf(Globals.prefs.getWrappedUsername());
                if (index >= 0) {
                    if (onlyMaxLevel) {
                        return;
                    }
                    newValue = markerString.substring(0, index) + markerString.substring(index + Globals.prefs.getWrappedUsername().length());
                } else {
                    Matcher m = MARK_NUMBER_PATTERN.matcher(markerString);
                    if (m.find()) {
                        try {
                            int prevMarkLevel = Integer.parseInt(m.group(1));
                            if (!onlyMaxLevel || prevMarkLevel == 6) {
                                if (prevMarkLevel > 1) {
                                    newValue = markerString.substring(0, m.start(1)) + markerString.substring(m.end(1));
                                } else {
                                    String toRemove = Globals.prefs.getWrappedUsername().substring(0, Globals.prefs.getWrappedUsername().length() - 1) + ":1]";
                                    index = markerString.indexOf(toRemove);
                                    if (index >= 0) {
                                        newValue = markerString.substring(0, index) + markerString.substring(index + toRemove.length());
                                    }
                                }
                                break block15;
                            }
                            return;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry").get(), newValue));
            if (newValue == null) {
                be.clearField("__markedentry");
            } else {
                be.setField("__markedentry", newValue);
            }
        }
    }

    private static void unmarkOldStyle(BibEntry be, BibDatabase database, NamedCompound ce) {
        TreeSet owners = new TreeSet();
        for (BibEntry bibEntry : database.getEntries()) {
            bibEntry.getField("owner").ifPresent(owners::add);
        }
        owners.remove(Globals.prefs.get("defaultOwner"));
        StringBuilder sb = new StringBuilder();
        for (Object owner : owners) {
            sb.append('[');
            sb.append(owner);
            sb.append(']');
        }
        String string = sb.toString();
        if (string.isEmpty()) {
            ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry").orElse(null), null));
            be.clearField("__markedentry");
        } else {
            ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry").orElse(null), string));
            be.setField("__markedentry", string);
        }
    }

    public static int isMarked(BibEntry be) {
        if (!be.hasField("__markedentry")) {
            return 0;
        }
        String s = be.getField("__markedentry").get();
        if ("0".equals(s)) {
            return 1;
        }
        int index = s.indexOf(Globals.prefs.getWrappedUsername());
        if (index >= 0) {
            return 1;
        }
        Matcher m = MARK_NUMBER_PATTERN.matcher(s);
        if (m.find()) {
            try {
                return Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException ex) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean shouldMarkEntries() {
        return Globals.prefs.getBoolean("markImportedEntries");
    }
}

