/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.EntryTypeList;
import net.sf.jabref.gui.FieldSetComponent;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.model.strings.StringUtil;

public class EntryCustomizationDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private final JabRefFrame frame;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    private FieldSetComponent reqComp;
    private FieldSetComponent optComp;
    private FieldSetComponent optComp2;
    private EntryTypeList typeComp;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    protected JButton helpButton;
    protected JButton delete;
    protected JButton importTypes;
    protected JButton exportTypes;
    private final List<String> preset = InternalBibtexFields.getAllPublicFieldNames();
    private String lastSelected;
    private final Map<String, List<String>> reqLists = new HashMap<String, List<String>>();
    private final Map<String, List<String>> optLists = new HashMap<String, List<String>>();
    private final Map<String, List<String>> opt2Lists = new HashMap<String, List<String>>();
    private final Set<String> defaulted = new HashSet<String>();
    private final Set<String> changed = new HashSet<String>();
    private boolean biblatexMode;
    private BibDatabaseMode bibDatabaseMode;

    public EntryCustomizationDialog(JabRefFrame frame) {
        super(frame, Localization.lang("Customize entry types", new String[0]), false);
        this.frame = frame;
        this.initGui();
    }

    private void initGui() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.bibDatabaseMode = this.frame.getCurrentBasePanel() == null ? Globals.prefs.getDefaultBibDatabaseMode() : this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode();
        this.biblatexMode = BibDatabaseMode.BIBLATEX.equals((Object)this.bibDatabaseMode);
        JPanel main = new JPanel();
        JPanel buttons = new JPanel();
        JPanel right = new JPanel();
        main.setLayout(new BorderLayout());
        right.setLayout(new GridLayout(this.biblatexMode ? 2 : 1, 2));
        ArrayList<String> entryTypes = new ArrayList<String>();
        for (String s : EntryTypes.getAllTypes(this.bibDatabaseMode)) {
            entryTypes.add(s);
        }
        this.typeComp = new EntryTypeList(entryTypes, this.bibDatabaseMode);
        this.typeComp.addListSelectionListener(this);
        this.typeComp.addAdditionActionListener(this);
        this.typeComp.addDefaultActionListener(new DefaultListener());
        this.typeComp.setListSelectionMode(0);
        this.reqComp = new FieldSetComponent(Localization.lang("Required fields", new String[0]), new ArrayList<String>(), this.preset, true, true);
        this.reqComp.setEnabled(false);
        this.reqComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DataListener dataListener = new DataListener();
        this.reqComp.addListDataListener(dataListener);
        this.optComp = new FieldSetComponent(Localization.lang("Optional fields", new String[0]), new ArrayList<String>(), this.preset, true, true);
        this.optComp.setEnabled(false);
        this.optComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.optComp.addListDataListener(dataListener);
        right.add(this.reqComp);
        right.add(this.optComp);
        if (this.biblatexMode) {
            this.optComp2 = new FieldSetComponent(Localization.lang("Optional fields", new String[0]) + " 2", new ArrayList<String>(), this.preset, true, true);
            this.optComp2.setEnabled(false);
            this.optComp2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.optComp2.addListDataListener(dataListener);
            right.add(new JPanel());
            right.add(this.optComp2);
        }
        right.setBorder(BorderFactory.createEtchedBorder());
        this.ok = new JButton(Localization.lang("OK", new String[0]));
        this.cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.apply = new JButton(Localization.lang("Apply", new String[0]));
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.apply);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog.this.dispose();
            }
        };
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        main.add((Component)this.typeComp, "West");
        main.add((Component)right, "Center");
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)main, "Center");
        pane.add((Component)buttons, "South");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String s;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.lastSelected != null) {
            this.reqLists.put(this.lastSelected, this.reqComp.getFields());
            this.optLists.put(this.lastSelected, this.optComp.getFields());
            if (this.biblatexMode) {
                this.opt2Lists.put(this.lastSelected, this.optComp2.getFields());
            }
        }
        if ((s = this.typeComp.getFirstSelected()) == null) {
            return;
        }
        List<String> rl = this.reqLists.get(s);
        if (rl == null) {
            Optional<EntryType> type = EntryTypes.getType(s, this.bibDatabaseMode);
            if (type.isPresent()) {
                List<String> opt;
                List<String> req = type.get().getRequiredFields();
                if (this.biblatexMode) {
                    opt = type.get().getPrimaryOptionalFields();
                    List<String> opt2 = type.get().getSecondaryOptionalFields();
                    this.optComp2.setFields(opt2);
                    this.optComp2.setEnabled(true);
                } else {
                    opt = type.get().getOptionalFields();
                }
                this.reqComp.setFields(req);
                this.reqComp.setEnabled(true);
                this.optComp.setFields(opt);
                this.optComp.setEnabled(true);
            } else {
                this.reqComp.setFields(new ArrayList<String>());
                this.reqComp.setEnabled(true);
                this.optComp.setFields(new ArrayList<String>());
                this.optComp.setEnabled(true);
                if (this.biblatexMode) {
                    this.optComp2.setFields(new ArrayList<String>());
                    this.optComp2.setEnabled(true);
                }
                this.reqComp.requestFocus();
            }
        } else {
            this.reqComp.setFields(rl);
            this.optComp.setFields(this.optLists.get(s));
            if (this.biblatexMode) {
                this.optComp2.setFields(this.opt2Lists.get(s));
            }
        }
        this.lastSelected = s;
        this.typeComp.enable(s, this.changed.contains(this.lastSelected) && !this.defaulted.contains(this.lastSelected));
    }

    private void applyChanges() {
        this.valueChanged(new ListSelectionEvent(new JList(), 0, 0, false));
        List types = this.typeComp.getFields();
        for (Map.Entry<String, List<String>> stringListEntry : this.reqLists.entrySet()) {
            if (!types.contains(stringListEntry.getKey())) continue;
            List<String> reqStr = stringListEntry.getValue();
            List<String> optStr = this.optLists.get(stringListEntry.getKey());
            List<String> opt2Str = this.opt2Lists.get(stringListEntry.getKey());
            if (opt2Str == null) {
                opt2Str = new ArrayList<String>(0);
            }
            boolean changesMade = true;
            if (this.defaulted.contains(stringListEntry.getKey())) {
                String nm = StringUtil.capitalizeFirst(stringListEntry.getKey());
                EntryTypes.removeType(nm, this.bibDatabaseMode);
                this.updateTypesForEntries();
                continue;
            }
            Optional<EntryType> oldType = EntryTypes.getType(stringListEntry.getKey(), this.bibDatabaseMode);
            if (oldType.isPresent()) {
                List<String> oldReq = oldType.get().getRequiredFieldsFlat();
                List<String> oldOpt = oldType.get().getOptionalFields();
                if (this.biblatexMode) {
                    List<String> oldPriOpt = oldType.get().getPrimaryOptionalFields();
                    List<String> oldSecOpt = oldType.get().getSecondaryOptionalFields();
                    if (EntryCustomizationDialog.equalLists(oldReq, reqStr) && EntryCustomizationDialog.equalLists(oldPriOpt, optStr) && EntryCustomizationDialog.equalLists(oldSecOpt, opt2Str)) {
                        changesMade = false;
                    }
                } else if (EntryCustomizationDialog.equalLists(oldReq, reqStr) && EntryCustomizationDialog.equalLists(oldOpt, optStr)) {
                    changesMade = false;
                }
            }
            if (!changesMade) continue;
            CustomEntryType typ = this.biblatexMode ? new CustomEntryType(StringUtil.capitalizeFirst(stringListEntry.getKey()), reqStr, optStr, opt2Str) : new CustomEntryType(StringUtil.capitalizeFirst(stringListEntry.getKey()), reqStr, optStr);
            EntryTypes.addOrModifyCustomEntryType(typ);
            this.updateTypesForEntries();
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String o : EntryTypes.getAllTypes(this.bibDatabaseMode)) {
            if (types.contains(o)) continue;
            toRemove.add(o);
        }
        if (!toRemove.isEmpty()) {
            for (String aToRemove : toRemove) {
                this.typeDeletion(aToRemove);
            }
        }
        this.updateTables();
    }

    private void typeDeletion(String name) {
        Optional<EntryType> type = EntryTypes.getType(name, this.bibDatabaseMode);
        if (type.isPresent() && type.get() instanceof CustomEntryType) {
            int reply;
            if (!EntryTypes.getStandardType(name, this.bibDatabaseMode).isPresent() && (reply = JOptionPane.showConfirmDialog(this.frame, Localization.lang("All entries of this type will be declared typeless. Continue?", new String[0]), Localization.lang("Delete custom format", new String[0]) + " '" + StringUtil.capitalizeFirst(name) + '\'', 0, 2)) != 0) {
                return;
            }
            EntryTypes.removeType(name, this.bibDatabaseMode);
            this.updateTypesForEntries();
            this.changed.remove(name);
            this.reqLists.remove(name);
            this.optLists.remove(name);
            if (this.biblatexMode) {
                this.opt2Lists.remove(name);
            }
        }
    }

    private static boolean equalLists(List<String> one, List<String> two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.size() != two.size()) {
            return false;
        }
        for (int i = 0; i < one.size(); ++i) {
            if (one.get(i).equals(two.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.applyChanges();
            this.dispose();
        } else if (e.getSource() == this.cancel) {
            this.dispose();
        } else if (e.getSource() == this.apply) {
            this.applyChanges();
        } else if (e.getSource() == this.typeComp) {
            this.typeComp.selectField(e.getActionCommand());
        }
    }

    private void updateTypesForEntries() {
        for (BasePanel bp : this.frame.getBasePanelList()) {
            for (BibEntry entry : bp.getDatabase().getEntries()) {
                EntryTypes.getType(entry.getType(), this.bibDatabaseMode).ifPresent(entry::setType);
            }
        }
    }

    private void updateTables() {
        for (BasePanel basePanel : this.frame.getBasePanelList()) {
            ((AbstractTableModel)basePanel.getMainTable().getModel()).fireTableDataChanged();
        }
    }

    class DataListener
    implements ListDataListener {
        DataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.record();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.record();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.record();
        }

        private void record() {
            if (EntryCustomizationDialog.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog.this.defaulted.remove(EntryCustomizationDialog.this.lastSelected);
            EntryCustomizationDialog.this.changed.add(EntryCustomizationDialog.this.lastSelected);
            EntryCustomizationDialog.this.typeComp.enable(EntryCustomizationDialog.this.lastSelected, true);
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntryCustomizationDialog.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog.this.defaulted.add(EntryCustomizationDialog.this.lastSelected);
            Optional<EntryType> type = EntryTypes.getStandardType(EntryCustomizationDialog.this.lastSelected, EntryCustomizationDialog.this.bibDatabaseMode);
            if (type.isPresent()) {
                List<String> of = type.get().getOptionalFields();
                List<String> req = type.get().getRequiredFields();
                ArrayList<String> opt1 = new ArrayList();
                ArrayList<String> opt2 = new ArrayList();
                if (!of.isEmpty()) {
                    if (EntryCustomizationDialog.this.biblatexMode) {
                        opt1 = type.get().getPrimaryOptionalFields();
                        opt2 = type.get().getSecondaryOptionalFields();
                    } else {
                        opt1 = of;
                    }
                }
                EntryCustomizationDialog.this.reqComp.setFields(req);
                EntryCustomizationDialog.this.reqComp.setEnabled(true);
                EntryCustomizationDialog.this.optComp.setFields(opt1);
                if (EntryCustomizationDialog.this.biblatexMode) {
                    EntryCustomizationDialog.this.optComp2.setFields(opt2);
                }
            }
        }
    }
}

