/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.event.ListEventListener;
import com.google.common.eventbus.Subscribe;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.collab.FileUpdateListener;
import net.sf.jabref.collab.FileUpdatePanel;
import net.sf.jabref.gui.BasePanelMode;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.DuplicateSearch;
import net.sf.jabref.gui.EntryMarker;
import net.sf.jabref.gui.EntryTypeDialog;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.FindUnlinkedFilesDialog;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.PreambleEditor;
import net.sf.jabref.gui.PreviewPanel;
import net.sf.jabref.gui.ReplaceStringDialog;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.gui.StringDialog;
import net.sf.jabref.gui.TransferableBibtexEntry;
import net.sf.jabref.gui.actions.BaseAction;
import net.sf.jabref.gui.actions.CleanupAction;
import net.sf.jabref.gui.actions.CopyBibTeXKeyAndLinkAction;
import net.sf.jabref.gui.bibtexkeypattern.SearchFixDuplicateLabels;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.exporter.ExportToClipboardAction;
import net.sf.jabref.gui.exporter.SaveDatabaseAction;
import net.sf.jabref.gui.externalfiles.FindFullTextAction;
import net.sf.jabref.gui.externalfiles.SynchronizeFileField;
import net.sf.jabref.gui.externalfiles.WriteXMPAction;
import net.sf.jabref.gui.externalfiletype.ExternalFileMenuItem;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.filelist.AttachFileAction;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.groups.GroupAddRemoveDialog;
import net.sf.jabref.gui.groups.GroupSelector;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.importer.actions.AppendDatabaseAction;
import net.sf.jabref.gui.journals.AbbreviateAction;
import net.sf.jabref.gui.journals.UnabbreviateAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.maintable.MainTableDataModel;
import net.sf.jabref.gui.maintable.MainTableFormat;
import net.sf.jabref.gui.maintable.MainTableSelectionListener;
import net.sf.jabref.gui.mergeentries.FetchAndMergeEntry;
import net.sf.jabref.gui.mergeentries.MergeEntriesDialog;
import net.sf.jabref.gui.plaintextimport.TextInputDialog;
import net.sf.jabref.gui.specialfields.SpecialFieldDatabaseChangeListener;
import net.sf.jabref.gui.specialfields.SpecialFieldValueViewModel;
import net.sf.jabref.gui.specialfields.SpecialFieldViewModel;
import net.sf.jabref.gui.undo.CountingUndoManager;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableChangeType;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import net.sf.jabref.gui.undo.UndoableKeyChange;
import net.sf.jabref.gui.undo.UndoableRemoveEntry;
import net.sf.jabref.gui.util.component.CheckBoxMessage;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.gui.worker.CallBack;
import net.sf.jabref.gui.worker.MarkEntriesAction;
import net.sf.jabref.gui.worker.SendAsEMailAction;
import net.sf.jabref.gui.worker.Worker;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.autocompleter.AutoCompleterFactory;
import net.sf.jabref.logic.autocompleter.ContentAutoCompleters;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.citationstyle.CitationStyleCache;
import net.sf.jabref.logic.exporter.BibtexDatabaseWriter;
import net.sf.jabref.logic.exporter.FileSaveSession;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.l10n.Encodings;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutHelper;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.logic.util.io.FileBasedLock;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.logic.util.io.RegExpFileSearch;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.DatabaseLocation;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.database.event.EntryAddedEvent;
import net.sf.jabref.model.database.event.EntryRemovedEvent;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.FieldName;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.model.entry.event.EntryChangedEvent;
import net.sf.jabref.model.entry.event.EntryEventSource;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import net.sf.jabref.model.entry.specialfields.SpecialFieldValue;
import net.sf.jabref.preferences.HighlightMatchingGroupPreferences;
import net.sf.jabref.preferences.PreviewPreferences;
import net.sf.jabref.shared.DBMSSynchronizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasePanel
extends JPanel
implements ClipboardOwner,
FileUpdateListener {
    private static final Log LOGGER = LogFactory.getLog(BasePanel.class);
    private static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    private final BibDatabaseContext bibDatabaseContext;
    private final MainTableDataModel tableModel;
    private final CitationStyleCache citationStyleCache;
    private BasePanelMode mode = BasePanelMode.SHOWING_NOTHING;
    private EntryEditor currentEditor;
    private MainTableSelectionListener selectionListener;
    private ListEventListener<BibEntry> groupsHighlightListener;
    private JSplitPane splitPane;
    private final JabRefFrame frame;
    private String fileMonitorHandle;
    private boolean saving;
    private boolean updatedExternally;
    private AutoCompleter<String> searchAutoCompleter;
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final CountingUndoManager undoManager = new CountingUndoManager();
    private final List<BibEntry> previousEntries = new ArrayList<BibEntry>();
    private final List<BibEntry> nextEntries = new ArrayList<BibEntry>();
    private boolean baseChanged;
    private boolean nonUndoableChange;
    private MainTable mainTable;
    private MainTableFormat tableFormat;
    private BibEntry showing;
    private boolean backOrForwardInProgress;
    private PreambleEditor preambleEditor;
    private StringDialog stringDialog;
    private final Map<String, Object> actions = new HashMap<String, Object>();
    private final SidePaneManager sidePaneManager;
    private ContentAutoCompleters autoCompleters;
    private SearchQuery currentSearchQuery;

    public BasePanel(JabRefFrame frame, BibDatabaseContext bibDatabaseContext) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(bibDatabaseContext);
        this.bibDatabaseContext = bibDatabaseContext;
        this.sidePaneManager = frame.getSidePaneManager();
        this.frame = frame;
        this.tableModel = new MainTableDataModel(this.getBibDatabaseContext());
        this.citationStyleCache = new CitationStyleCache(bibDatabaseContext);
        this.setupMainPanel();
        this.setupActions();
        this.getDatabase().registerListener(new SearchListener());
        this.bibDatabaseContext.getDatabase().registerListener(new GroupTreeListener());
        Optional<File> file = bibDatabaseContext.getDatabaseFile();
        if (file.isPresent()) {
            try {
                this.fileMonitorHandle = Globals.getFileUpdateMonitor().addUpdateListener(this, file.get());
            }
            catch (IOException ex) {
                LOGGER.warn("Could not register FileUpdateMonitor", ex);
            }
        } else if (bibDatabaseContext.getDatabase().hasEntries()) {
            this.baseChanged = true;
        }
    }

    public ContentAutoCompleters getAutoCompleters() {
        return this.autoCompleters;
    }

    public String getTabTitle() {
        StringBuilder title = new StringBuilder();
        DatabaseLocation databaseLocation = this.bibDatabaseContext.getLocation();
        boolean isAutosaveEnabled = Globals.prefs.getBoolean("localAutoSave");
        if (databaseLocation == DatabaseLocation.LOCAL) {
            if (this.bibDatabaseContext.getDatabaseFile().isPresent()) {
                String changeFlag = this.isModified() && !isAutosaveEnabled ? "*" : "";
                title.append(this.bibDatabaseContext.getDatabaseFile().get().getName()).append(changeFlag);
            } else {
                title.append(GUIGlobals.UNTITLED_TITLE);
                if (this.getDatabase().hasEntries()) {
                    title.append('*');
                }
            }
        } else if (databaseLocation == DatabaseLocation.SHARED) {
            title.append(this.bibDatabaseContext.getDBMSSynchronizer().getDBName() + " [" + Localization.lang("shared", new String[0]) + "]");
        }
        return title.toString();
    }

    public boolean isModified() {
        return this.baseChanged;
    }

    public BasePanelMode getMode() {
        return this.mode;
    }

    public void setMode(BasePanelMode mode) {
        this.mode = mode;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public void output(String s) {
        this.frame.output(s);
    }

    private void setupActions() {
        SaveDatabaseAction saveAction = new SaveDatabaseAction(this);
        CleanupAction cleanUpAction = new CleanupAction(this, Globals.prefs);
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("focusTable", () -> this.mainTable.requestFocus());
        this.actions.put("edit", this.selectionListener::editSignalled);
        this.actions.put("save", saveAction);
        this.actions.put("saveAs", saveAction::saveAs);
        this.actions.put("saveSelectedAs", new SaveSelectedAction(SavePreferences.DatabaseSaveType.ALL));
        this.actions.put("saveSelectedAsPlain", new SaveSelectedAction(SavePreferences.DatabaseSaveType.PLAIN_BIBTEX));
        this.actions.put("copy", () -> this.copy());
        this.actions.put("printPreview", new PrintPreviewAction());
        this.actions.put("cut", this::cut);
        this.actions.put("delete", () -> this.delete(false));
        this.actions.put("paste", () -> this.paste());
        this.actions.put("selectAll", this.mainTable::selectAll);
        this.actions.put("editPreamble", () -> {
            if (this.preambleEditor == null) {
                PreambleEditor form = new PreambleEditor(this.frame, this, this.bibDatabaseContext.getDatabase());
                form.setLocationRelativeTo(this.frame);
                form.setVisible(true);
                this.preambleEditor = form;
            } else {
                this.preambleEditor.setVisible(true);
            }
        });
        this.actions.put("editStrings", () -> {
            if (this.stringDialog == null) {
                StringDialog form = new StringDialog(this.frame, this, this.bibDatabaseContext.getDatabase());
                form.setVisible(true);
                this.stringDialog = form;
            } else {
                this.stringDialog.setVisible(true);
            }
        });
        this.actions.put("findUnlinkedFiles", () -> {
            FindUnlinkedFilesDialog dialog = new FindUnlinkedFilesDialog((Frame)this.frame, this.frame, this);
            dialog.setLocationRelativeTo(this.frame);
            dialog.setVisible(true);
        });
        this.actions.put("makeKey", new AbstractWorker(){
            List<BibEntry> entries;
            int numSelected;
            boolean canceled;

            @Override
            public void init() {
                this.entries = BasePanel.this.getSelectedEntries();
                this.numSelected = this.entries.size();
                if (this.entries.isEmpty()) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Localization.lang("First select the entries you want keys to be generated for.", new String[0]), Localization.lang("Autogenerate BibTeX keys", new String[0]), 1);
                    return;
                }
                BasePanel.this.frame.block();
                BasePanel.this.output(BasePanel.this.formatOutputMessage(Localization.lang("Generating BibTeX key for", new String[0]), this.numSelected));
            }

            @Override
            public void run() {
                if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    this.entries.removeIf(BibEntry::hasCiteKey);
                } else if (Globals.prefs.getBoolean("warnBeforeOverwritingKey") && this.entries.parallelStream().anyMatch(BibEntry::hasCiteKey)) {
                    CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("One or more keys will be overwritten. Continue?", new String[0]), Localization.lang("Disable this confirmation dialog", new String[0]), false);
                    int answer = JOptionPane.showConfirmDialog(BasePanel.this.frame, cbm, Localization.lang("Overwrite keys", new String[0]), 0);
                    Globals.prefs.putBoolean("warnBeforeOverwritingKey", !cbm.isSelected());
                    if (answer == 1) {
                        this.canceled = true;
                        return;
                    }
                }
                NamedCompound ce = new NamedCompound(Localization.lang("Autogenerate BibTeX keys", new String[0]));
                AbstractBibtexKeyPattern citeKeyPattern = BasePanel.this.bibDatabaseContext.getMetaData().getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern());
                for (BibEntry entry : this.entries) {
                    String oldCiteKey = entry.getCiteKeyOptional().orElse("");
                    BibtexKeyPatternUtil.makeLabel(citeKeyPattern, BasePanel.this.bibDatabaseContext.getDatabase(), entry, Globals.prefs.getBibtexKeyPatternPreferences());
                    String newCiteKey = entry.getCiteKeyOptional().orElse("");
                    if (oldCiteKey.equals(newCiteKey)) continue;
                    ce.addEdit(new UndoableKeyChange(entry, oldCiteKey, newCiteKey));
                }
                ce.end();
                if (ce.hasEdits()) {
                    BasePanel.this.getUndoManager().addEdit(ce);
                }
            }

            @Override
            public void update() {
                if (this.canceled) {
                    BasePanel.this.frame.unblock();
                    return;
                }
                BasePanel.this.markBaseChanged();
                this.numSelected = this.entries.size();
                for (BibEntry bibEntry : this.entries) {
                    SwingUtilities.invokeLater(() -> {
                        int row = BasePanel.this.mainTable.findEntry(bibEntry);
                        if (row >= 0 && BasePanel.this.mainTable.getSelectedRowCount() < this.entries.size()) {
                            BasePanel.this.mainTable.addRowSelectionInterval(row, row);
                        }
                    });
                }
                BasePanel.this.output(BasePanel.this.formatOutputMessage(Localization.lang("Generated BibTeX key for", new String[0]), this.numSelected));
                BasePanel.this.frame.unblock();
            }
        });
        this.actions.put("Cleanup", cleanUpAction);
        this.actions.put("mergeEntries", () -> new MergeEntriesDialog(this));
        this.actions.put("search", this.frame.getGlobalSearchBar()::focus);
        this.actions.put("globalSearch", this.frame.getGlobalSearchBar()::performGlobalSearch);
        this.actions.put("copyKey", () -> this.copyKey());
        this.actions.put("copyCiteKey", () -> this.copyCiteKey());
        this.actions.put("copyKeyAndTitle", () -> this.copyKeyAndTitle());
        this.actions.put("copyKeyAndLink", new CopyBibTeXKeyAndLinkAction(this.mainTable));
        this.actions.put("mergeDatabase", new AppendDatabaseAction(this.frame, this));
        this.actions.put("addFileLink", new AttachFileAction(this));
        this.actions.put("openExternalFile", () -> this.openExternalFile());
        this.actions.put("openFolder", () -> JabRefExecutorService.INSTANCE.execute(() -> {
            List<File> files = FileUtil.getListOfLinkedFiles(this.mainTable.getSelectedEntries(), this.bibDatabaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences()));
            for (File f : files) {
                try {
                    JabRefDesktop.openFolderAndSelectFile(f.getAbsolutePath());
                }
                catch (IOException e) {
                    LOGGER.info("Could not open folder", e);
                }
            }
        }));
        this.actions.put("openConsole", () -> JabRefDesktop.openConsole(this.frame.getCurrentBasePanel().getBibDatabaseContext().getDatabaseFile().orElse(null)));
        this.actions.put("pullChangesFromSharedDatabase", () -> {
            DBMSSynchronizer dbmsSynchronizer = this.frame.getCurrentBasePanel().getBibDatabaseContext().getDBMSSynchronizer();
            dbmsSynchronizer.pullChanges();
        });
        this.actions.put("openUrl", new OpenURLAction());
        this.actions.put("mergeWithFetchedEntry", () -> {
            if (this.mainTable.getSelectedEntries().size() == 1) {
                BibEntry originalEntry = this.mainTable.getSelectedEntries().get(0);
                new FetchAndMergeEntry(originalEntry, this, FetchAndMergeEntry.SUPPORTED_FIELDS);
            } else {
                JOptionPane.showMessageDialog(this.frame(), Localization.lang("This operation requires exactly one item to be selected.", new String[0]), Localization.lang("Merge entry with %0 information", FieldName.orFields(FieldName.getDisplayName("doi"), FieldName.getDisplayName("isbn"), FieldName.getDisplayName("eprint"))), 1);
            }
        });
        this.actions.put("replaceAll", () -> {
            ReplaceStringDialog rsd = new ReplaceStringDialog(this.frame);
            rsd.setVisible(true);
            if (!rsd.okPressed()) {
                return;
            }
            int counter = 0;
            NamedCompound ce = new NamedCompound(Localization.lang("Replace string", new String[0]));
            if (rsd.selOnly()) {
                for (BibEntry be : this.mainTable.getSelectedEntries()) {
                    counter += rsd.replace(be, ce);
                }
            } else {
                for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
                    counter += rsd.replace(entry, ce);
                }
            }
            this.output(Localization.lang("Replaced", new String[0]) + ' ' + counter + ' ' + (counter == 1 ? Localization.lang("occurrence", new String[0]) : Localization.lang("occurrences", new String[0])) + '.');
            if (counter > 0) {
                ce.end();
                this.getUndoManager().addEdit(ce);
                this.markBaseChanged();
            }
        });
        this.actions.put("dupliCheck", () -> JabRefExecutorService.INSTANCE.execute(new DuplicateSearch(this)));
        this.actions.put("plainTextImport", () -> {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            etd.setLocationRelativeTo(this);
            etd.setVisible(true);
            EntryType tp = etd.getChoice();
            if (tp == null) {
                return;
            }
            String id = IdGenerator.next();
            BibEntry bibEntry = new BibEntry(id, tp.getName());
            TextInputDialog tidialog = new TextInputDialog(this.frame, bibEntry);
            tidialog.setLocationRelativeTo(this);
            tidialog.setVisible(true);
            if (tidialog.okPressed()) {
                UpdateField.setAutomaticFields(Collections.singletonList(bibEntry), false, false, Globals.prefs.getUpdateFieldPreferences());
                this.insertEntry(bibEntry);
            }
        });
        this.actions.put("markEntries", new MarkEntriesAction(this.frame, 0));
        this.actions.put("unmarkEntries", () -> {
            try {
                List<BibEntry> bes = this.mainTable.getSelectedEntries();
                if (bes.isEmpty()) {
                    this.output(Localization.lang("This operation requires one or more entries to be selected.", new String[0]));
                    return;
                }
                NamedCompound ce = new NamedCompound(Localization.lang("Unmark entries", new String[0]));
                for (BibEntry be : bes) {
                    EntryMarker.unmarkEntry(be, false, this.bibDatabaseContext.getDatabase(), ce);
                }
                ce.end();
                this.getUndoManager().addEdit(ce);
                this.markBaseChanged();
                String outputStr = bes.size() == 1 ? Localization.lang("Unmarked selected entry", new String[0]) : Localization.lang("Unmarked all %0 selected entries", Integer.toString(bes.size()));
                this.output(outputStr);
            }
            catch (Throwable ex) {
                LOGGER.warn("Could not unmark", ex);
            }
        });
        this.actions.put("unmarkAll", () -> {
            NamedCompound ce = new NamedCompound(Localization.lang("Unmark all", new String[0]));
            for (BibEntry be : this.bibDatabaseContext.getDatabase().getEntries()) {
                EntryMarker.unmarkEntry(be, false, this.bibDatabaseContext.getDatabase(), ce);
            }
            ce.end();
            this.getUndoManager().addEdit(ce);
            this.markBaseChanged();
            this.output(Localization.lang("Unmarked all entries", new String[0]));
        });
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.RELEVANCE).getSpecialFieldAction(SpecialField.RELEVANCE.getValues().get(0), this.frame));
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.QUALITY).getSpecialFieldAction(SpecialField.QUALITY.getValues().get(0), this.frame));
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.PRINTED).getSpecialFieldAction(SpecialField.PRINTED.getValues().get(0), this.frame));
        for (SpecialFieldValue prio : SpecialField.PRIORITY.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(prio).getActionName(), new SpecialFieldViewModel(SpecialField.PRIORITY).getSpecialFieldAction(prio, this.frame));
        }
        for (SpecialFieldValue rank : SpecialField.RANKING.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(rank).getActionName(), new SpecialFieldViewModel(SpecialField.RANKING).getSpecialFieldAction(rank, this.frame));
        }
        for (SpecialFieldValue status : SpecialField.READ_STATUS.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(status).getActionName(), new SpecialFieldViewModel(SpecialField.READ_STATUS).getSpecialFieldAction(status, this.frame));
        }
        this.actions.put("togglePreview", () -> {
            PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
            boolean enabled = !previewPreferences.isPreviewPanelEnabled();
            PreviewPreferences newPreviewPreferences = previewPreferences.getBuilder().withPreviewPanelEnabled(enabled).build();
            Globals.prefs.storePreviewPreferences(newPreviewPreferences);
            this.setPreviewActiveBasePanels(enabled);
            this.frame.setPreviewToggle(enabled);
        });
        this.actions.put("toggleHighlightGroupsMatchingAny", () -> {
            new HighlightMatchingGroupPreferences(Globals.prefs).setToAny();
            this.groupsHighlightListener.listChanged(null);
        });
        this.actions.put("toggleHighlightGroupsMatchingAll", () -> {
            new HighlightMatchingGroupPreferences(Globals.prefs).setToAll();
            this.groupsHighlightListener.listChanged(null);
        });
        this.actions.put("toggleHighlightGroupsMatchingDisable", () -> {
            new HighlightMatchingGroupPreferences(Globals.prefs).setToDisabled();
            this.groupsHighlightListener.listChanged(null);
        });
        this.actions.put("nextPreviewStyle", this.selectionListener::nextPreviewStyle);
        this.actions.put("previousPreviewStyle", this.selectionListener::previousPreviewStyle);
        this.actions.put("exportToClipboard", new ExportToClipboardAction(this.frame));
        this.actions.put("sendAsEmail", new SendAsEMailAction(this.frame));
        this.actions.put("writeXMP", new WriteXMPAction(this));
        this.actions.put("abbreviateIso", new AbbreviateAction(this, true));
        this.actions.put("abbreviateMedline", new AbbreviateAction(this, false));
        this.actions.put("unabbreviate", new UnabbreviateAction(this));
        this.actions.put("autoSetFile", new SynchronizeFileField(this));
        this.actions.put("back", this::back);
        this.actions.put("forward", this::forward);
        this.actions.put("resolveDuplicateKeys", new SearchFixDuplicateLabels(this));
        this.actions.put("addToGroup", new GroupAddRemoveDialog(this, true, false));
        this.actions.put("removeFromGroup", new GroupAddRemoveDialog(this, false, false));
        this.actions.put("moveToGroup", new GroupAddRemoveDialog(this, true, true));
        this.actions.put("downloadFullText", new FindFullTextAction(this));
    }

    private void copy() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (bes.isEmpty()) {
            Object o;
            int[] rows = this.mainTable.getSelectedRows();
            int[] cols = this.mainTable.getSelectedColumns();
            if (cols.length == 1 && rows.length == 1 && (o = this.mainTable.getValueAt(rows[0], cols[0])) != null) {
                StringSelection ss = new StringSelection(o.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
                this.output(Localization.lang("Copied cell contents", new String[0]) + '.');
            }
        } else {
            TransferableBibtexEntry trbe = new TransferableBibtexEntry(bes);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trbe, this);
            this.output(this.formatOutputMessage(Localization.lang("Copied", new String[0]), bes.size()));
        }
    }

    private void cut() {
        this.runCommand("copy");
        this.delete(true);
    }

    private void delete(boolean cut) {
        List<BibEntry> entries = this.mainTable.getSelectedEntries();
        if (entries.isEmpty()) {
            return;
        }
        if (!cut && !this.showDeleteConfirmationDialog(entries.size())) {
            return;
        }
        if (this.mainTable.getSelectedRow() != this.mainTable.getRowCount() - 1) {
            this.selectNextEntry();
        } else {
            this.selectPreviousEntry();
        }
        NamedCompound compound = cut ? new NamedCompound(entries.size() > 1 ? Localization.lang("cut entries", new String[0]) : Localization.lang("cut entry", new String[0])) : new NamedCompound(entries.size() > 1 ? Localization.lang("delete entries", new String[0]) : Localization.lang("delete entry", new String[0]));
        for (BibEntry entry : entries) {
            compound.addEdit(new UndoableRemoveEntry(this.bibDatabaseContext.getDatabase(), entry, this));
            this.bibDatabaseContext.getDatabase().removeEntry(entry);
            this.ensureNotShowingBottomPanel(entry);
        }
        compound.end();
        this.getUndoManager().addEdit(compound);
        this.markBaseChanged();
        this.frame.output(this.formatOutputMessage(cut ? Localization.lang("Cut", new String[0]) : Localization.lang("Deleted", new String[0]), entries.size()));
        this.mainTable.requestFocus();
    }

    private void paste() {
        List<BibEntry> bes = new ClipBoardManager().extractBibEntriesFromClipboard();
        if (!bes.isEmpty()) {
            NamedCompound ce = new NamedCompound(bes.size() > 1 ? Localization.lang("paste entries", new String[0]) : Localization.lang("paste entry", new String[0]));
            BibEntry firstBE = null;
            for (BibEntry be1 : bes) {
                BibEntry be = (BibEntry)be1.clone();
                if (firstBE == null) {
                    firstBE = be;
                }
                UpdateField.setAutomaticFields(be, Globals.prefs.getUpdateFieldPreferences());
                be.setId(IdGenerator.next());
                this.bibDatabaseContext.getDatabase().insertEntry(be);
                ce.addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), be, this));
            }
            ce.end();
            this.getUndoManager().addEdit(ce);
            this.output(this.formatOutputMessage(Localization.lang("Pasted", new String[0]), bes.size()));
            this.markBaseChanged();
            this.highlightEntry(firstBE);
            this.mainTable.requestFocus();
            if (Globals.prefs.getBoolean("autoOpenForm")) {
                this.selectionListener.editSignalled(firstBE);
            }
        }
    }

    private void copyCiteKey() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            this.storeCurrentEdit();
            ArrayList keys = new ArrayList(bes.size());
            for (BibEntry be : bes) {
                be.getCiteKeyOptional().ifPresent(keys::add);
            }
            if (keys.isEmpty()) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            String sb = String.join((CharSequence)",", keys);
            StringSelection ss = new StringSelection("\\cite{" + sb + '}');
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (keys.size() == bes.size()) {
                this.output(bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0]) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - keys.size()), Integer.toString(bes.size())));
            }
        }
    }

    private void copyKey() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            this.storeCurrentEdit();
            ArrayList keys = new ArrayList(bes.size());
            for (BibEntry be : bes) {
                be.getCiteKeyOptional().ifPresent(keys::add);
            }
            if (keys.isEmpty()) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            StringSelection ss = new StringSelection(String.join((CharSequence)",", keys));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (keys.size() == bes.size()) {
                this.output((bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - keys.size()), Integer.toString(bes.size())));
            }
        }
    }

    private void copyKeyAndTitle() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            Layout layout;
            this.storeCurrentEdit();
            StringReader sr = new StringReader("\\bibtexkey - \\begin{title}\\format[RemoveBrackets]{\\title}\\end{title}\n");
            try {
                layout = new LayoutHelper(sr, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader)).getLayoutFromText();
            }
            catch (IOException e) {
                LOGGER.info("Could not get layout", e);
                return;
            }
            StringBuilder sb = new StringBuilder();
            int copied = 0;
            for (BibEntry be : bes) {
                if (!be.hasCiteKey()) continue;
                ++copied;
                sb.append(layout.doLayout(be, this.bibDatabaseContext.getDatabase()));
            }
            if (copied == 0) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            StringSelection ss = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (copied == bes.size()) {
                this.output((bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - copied), Integer.toString(bes.size())));
            }
        }
    }

    private void openExternalFile() {
        JabRefExecutorService.INSTANCE.execute(() -> {
            List<BibEntry> bes = this.mainTable.getSelectedEntries();
            if (bes.size() != 1) {
                this.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
                return;
            }
            BibEntry entry = bes.get(0);
            if (!entry.hasField("file")) {
                new SearchAndOpenFile(entry, this).searchAndOpen();
                return;
            }
            FileListTableModel fileListTableModel = new FileListTableModel();
            entry.getField("file").ifPresent(fileListTableModel::setContent);
            if (fileListTableModel.getRowCount() == 0) {
                new SearchAndOpenFile(entry, this).searchAndOpen();
                return;
            }
            FileListEntry flEntry = fileListTableModel.getEntry(0);
            ExternalFileMenuItem item = new ExternalFileMenuItem(this.frame(), entry, "", flEntry.link, flEntry.type.get().getIcon(), this.bibDatabaseContext, flEntry.type);
            item.openLink();
        });
    }

    public void runCommand(String _command) {
        if (!this.actions.containsKey(_command)) {
            LOGGER.info("No action defined for '" + _command + '\'');
            return;
        }
        Object o = this.actions.get(_command);
        try {
            if (o instanceof BaseAction) {
                ((BaseAction)o).action();
            } else {
                Worker wrk = ((AbstractWorker)o).getWorker();
                CallBack clb = ((AbstractWorker)o).getCallBack();
                ((AbstractWorker)o).init();
                wrk.run();
                clb.update();
            }
        }
        catch (Throwable ex) {
            this.frame.unblock();
            LOGGER.error("runCommand error: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveDatabase(File file, boolean selectedOnly, Charset enc, SavePreferences.DatabaseSaveType saveType) throws SaveException {
        Object session;
        this.frame.block();
        String SAVE_DATABASE = Localization.lang("Save database", new String[0]);
        try {
            SavePreferences prefs = SavePreferences.loadForSaveFromPreferences(Globals.prefs).withEncoding(enc).withSaveType(saveType);
            BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
            session = selectedOnly ? databaseWriter.savePartOfDatabase(this.bibDatabaseContext, this.mainTable.getSelectedEntries(), prefs) : databaseWriter.saveDatabase(this.bibDatabaseContext, prefs);
            this.registerUndoableChanges((SaveSession)session);
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + ' ' + Localization.lang("Character encoding '%0' is not supported.", enc.displayName()), SAVE_DATABASE, 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex.specificEntry()) {
                this.highlightEntry(ex.getEntry());
                this.showEntry(ex.getEntry());
            } else {
                LOGGER.warn("Could not save", ex);
            }
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + "\n" + ex.getMessage(), SAVE_DATABASE, 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean commit = true;
        if (!((SaveSession)session).getWriter().couldEncodeAll()) {
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "pref, 4dlu, pref"));
            JTextArea ta = new JTextArea(((SaveSession)session).getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.add(Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()), new Object[0]).xy(1, 1);
            builder.add(ta).xy(3, 1);
            builder.add(Localization.lang("What do you want to do?", new String[0]), new Object[0]).xy(1, 3);
            String tryDiff = Localization.lang("Try different encoding", new String[0]);
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), SAVE_DATABASE, 1, 2, null, new String[]{Localization.lang("Save", new String[0]), tryDiff, Localization.lang("Cancel", new String[0])}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Localization.lang("Select encoding", new String[0]), SAVE_DATABASE, 3, null, Encodings.ENCODINGS_DISPLAYNAMES, enc);
                if (choice != null) {
                    Charset newEncoding = Charset.forName((String)choice);
                    return this.saveDatabase(file, selectedOnly, newEncoding, saveType);
                }
                commit = false;
            } else if (answer == 2) {
                commit = false;
            }
        }
        if (commit) {
            ((SaveSession)session).commit(file.toPath());
            this.bibDatabaseContext.getMetaData().setEncoding(enc);
            return commit;
        }
        ((SaveSession)session).cancel();
        return commit;
    }

    public void registerUndoableChanges(SaveSession session) {
        NamedCompound ce = new NamedCompound(Localization.lang("Save actions", new String[0]));
        for (FieldChange change : session.getFieldChanges()) {
            ce.addEdit(new UndoableFieldChange(change));
        }
        ce.end();
        if (ce.hasEdits()) {
            this.getUndoManager().addEdit(ce);
        }
    }

    public BibEntry newEntry(EntryType type) {
        EntryType actualType = type;
        if (actualType == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            etd.setLocationRelativeTo(this.frame);
            etd.setVisible(true);
            actualType = etd.getChoice();
        }
        if (actualType != null) {
            String id = IdGenerator.next();
            BibEntry be = new BibEntry(id, actualType.getName());
            try {
                this.bibDatabaseContext.getDatabase().insertEntry(be);
                ArrayList<BibEntry> list = new ArrayList<BibEntry>();
                list.add(be);
                UpdateField.setAutomaticFields(list, true, true, Globals.prefs.getUpdateFieldPreferences());
                this.getUndoManager().addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), be, this));
                this.output(Localization.lang("Added new '%0' entry.", actualType.getName().toLowerCase()));
                if (this.mode != BasePanelMode.SHOWING_EDITOR) {
                    this.mode = BasePanelMode.WILL_SHOW_EDITOR;
                }
                this.highlightEntry(be);
                this.markBaseChanged();
                EntryEditor entryEditor = this.getEntryEditor(be);
                this.showEntryEditor(entryEditor);
                entryEditor.requestFocus();
                return be;
            }
            catch (KeyCollisionException ex) {
                LOGGER.info(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public void insertEntry(BibEntry bibEntry) {
        if (bibEntry != null) {
            try {
                this.bibDatabaseContext.getDatabase().insertEntry(bibEntry);
                if (Globals.prefs.getBoolean("useOwner")) {
                    UpdateField.setAutomaticFields(bibEntry, true, true, Globals.prefs.getUpdateFieldPreferences());
                }
                this.getUndoManager().addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), bibEntry, this));
                this.output(Localization.lang("Added new '%0' entry.", bibEntry.getType()));
                this.markBaseChanged();
                if (Globals.prefs.getBoolean("autoOpenForm")) {
                    this.selectionListener.editSignalled(bibEntry);
                }
                this.highlightEntry(bibEntry);
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Collision for bibtex key" + bibEntry.getId(), ex);
            }
        }
    }

    public void editEntryByKeyAndFocusField(String bibtexKey, String fieldName) {
        List<BibEntry> entries = this.bibDatabaseContext.getDatabase().getEntriesByKey(bibtexKey);
        if (entries.size() == 1) {
            this.mainTable.setSelected(this.mainTable.findEntry(entries.get(0)));
            this.selectionListener.editSignalled();
            EntryEditor editor = this.getEntryEditor(entries.get(0));
            editor.setFocusToField(fieldName);
            this.showEntryEditor(editor);
            editor.requestFocus();
        }
    }

    public void updateTableFont() {
        this.mainTable.updateFont();
    }

    private void createMainTable() {
        this.bibDatabaseContext.getDatabase().registerListener(this.tableModel.getListSynchronizer());
        this.bibDatabaseContext.getDatabase().registerListener(SpecialFieldDatabaseChangeListener.getInstance());
        this.tableFormat = new MainTableFormat(this.bibDatabaseContext.getDatabase());
        this.tableFormat.updateTableFormat();
        this.mainTable = new MainTable(this.tableFormat, this.tableModel, this.frame, this);
        this.selectionListener = new MainTableSelectionListener(this, this.mainTable);
        this.mainTable.updateFont();
        this.mainTable.addSelectionListener(this.selectionListener);
        this.mainTable.addMouseListener(this.selectionListener);
        this.mainTable.addKeyListener(this.selectionListener);
        this.mainTable.addFocusListener(this.selectionListener);
        this.groupsHighlightListener = listEvent -> {
            HighlightMatchingGroupPreferences highlightMatchingGroupPreferences = new HighlightMatchingGroupPreferences(Globals.prefs);
            if (highlightMatchingGroupPreferences.isAny()) {
                this.getGroupSelector().showMatchingGroups(this.mainTable.getSelectedEntries(), false);
            } else if (highlightMatchingGroupPreferences.isAll()) {
                this.getGroupSelector().showMatchingGroups(this.mainTable.getSelectedEntries(), true);
            } else {
                this.getGroupSelector().showMatchingGroups(null, true);
            }
        };
        this.mainTable.addSelectionListener(this.groupsHighlightListener);
        String clearSearch = "clearSearch";
        this.mainTable.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.CLEAR_SEARCH), clearSearch);
        this.mainTable.getActionMap().put(clearSearch, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (BasePanel.this.mode) {
                    case SHOWING_NOTHING: {
                        BasePanel.this.frame.getGlobalSearchBar().endSearch();
                        break;
                    }
                    case SHOWING_PREVIEW: {
                        BasePanel.this.getPreviewPanel().close();
                        break;
                    }
                    case SHOWING_EDITOR: 
                    case WILL_SHOW_EDITOR: {
                        BasePanel.this.getCurrentEditor().close();
                        break;
                    }
                    default: {
                        LOGGER.warn("unknown BasePanelMode: '" + (Object)((Object)BasePanel.this.mode) + "', doing nothing");
                    }
                }
            }
        });
        this.mainTable.getActionMap().put("cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not cut", ex);
                }
            }
        });
        this.mainTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not copy", ex);
                }
            }
        });
        this.mainTable.getActionMap().put("paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not paste", ex);
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                block16: {
                    int keyCode;
                    block15: {
                        GroupTreeNodeViewModel node;
                        keyCode = e.getKeyCode();
                        TreePath path = BasePanel.this.frame.getGroupSelector().getSelectionPath();
                        GroupTreeNodeViewModel groupTreeNodeViewModel = node = path == null ? null : (GroupTreeNodeViewModel)path.getLastPathComponent();
                        if (!e.isControlDown()) break block15;
                        switch (keyCode) {
                            case 38: {
                                e.consume();
                                if (node != null) {
                                    BasePanel.this.frame.getGroupSelector().moveNodeUp(node, true);
                                    break;
                                }
                                break block16;
                            }
                            case 40: {
                                e.consume();
                                if (node != null) {
                                    BasePanel.this.frame.getGroupSelector().moveNodeDown(node, true);
                                    break;
                                }
                                break block16;
                            }
                            case 37: {
                                e.consume();
                                if (node != null) {
                                    BasePanel.this.frame.getGroupSelector().moveNodeLeft(node, true);
                                    break;
                                }
                                break block16;
                            }
                            case 39: {
                                e.consume();
                                if (node != null) {
                                    BasePanel.this.frame.getGroupSelector().moveNodeRight(node, true);
                                    break;
                                }
                                break block16;
                            }
                            case 34: {
                                ((BasePanel)BasePanel.this).frame.nextTab.actionPerformed(null);
                                e.consume();
                                break;
                            }
                            case 33: {
                                ((BasePanel)BasePanel.this).frame.prevTab.actionPerformed(null);
                                e.consume();
                                break;
                            }
                        }
                        break block16;
                    }
                    if (keyCode == 10) {
                        e.consume();
                        try {
                            BasePanel.this.runCommand("edit");
                        }
                        catch (Throwable ex) {
                            LOGGER.warn("Could not run action based on key press", ex);
                        }
                    }
                }
            }
        });
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(4);
        this.adjustSplitter();
        boolean floatSearchActive = this.mainTable != null && this.tableModel.getSearchState() == MainTableDataModel.DisplayOption.FLOAT;
        this.createMainTable();
        this.splitPane.setTopComponent(this.mainTable.getPane());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            this.mode = BasePanelMode.SHOWING_NOTHING;
            this.highlightEntry(this.selectionListener.getPreview().getEntry());
        } else if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            this.mode = BasePanelMode.SHOWING_NOTHING;
        } else {
            this.splitPane.setBottomComponent(null);
        }
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.splitPane, "Center");
        this.instantiateSearchAutoCompleter();
        this.getDatabase().registerListener(new SearchAutoCompleteListener());
        AutoCompletePreferences autoCompletePreferences = new AutoCompletePreferences(Globals.prefs);
        if (Globals.prefs.getBoolean("autoComplete")) {
            this.autoCompleters = new ContentAutoCompleters(this.getDatabase(), autoCompletePreferences, Globals.journalAbbreviationLoader);
            this.getDatabase().registerListener(new AutoCompleteListener());
        } else {
            this.autoCompleters = new ContentAutoCompleters();
        }
        if (floatSearchActive) {
            this.mainTable.showFloatSearch();
        }
        this.splitPane.revalidate();
        this.revalidate();
        this.repaint();
        this.splitPane.addPropertyChangeListener("dividerLocation", event -> this.saveDividerLocation());
    }

    public void updateSearchManager() {
        this.frame.getGlobalSearchBar().setAutoCompleter(this.searchAutoCompleter);
    }

    private void instantiateSearchAutoCompleter() {
        AutoCompletePreferences autoCompletePreferences = new AutoCompletePreferences(Globals.prefs);
        AutoCompleterFactory autoCompleterFactory = new AutoCompleterFactory(autoCompletePreferences, Globals.journalAbbreviationLoader);
        this.searchAutoCompleter = autoCompleterFactory.getPersonAutoCompleter();
        for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
            this.searchAutoCompleter.addBibtexEntry(entry);
        }
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void adjustSplitter() {
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getPreviewPreferences().getPreviewPanelHeight());
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getInt("entryEditorHeight"));
        }
    }

    private boolean isShowingEditor() {
        return this.splitPane.getBottomComponent() != null && this.splitPane.getBottomComponent() instanceof EntryEditor;
    }

    public void showEntry(BibEntry be) {
        if (this.getShowing() == be) {
            if (this.splitPane.getBottomComponent() == null) {
                this.newEntryShowing(null);
                this.showEntry(be);
            } else {
                ((EntryEditor)this.splitPane.getBottomComponent()).updateAllFields();
            }
            return;
        }
        String visName = null;
        if (this.getShowing() != null && this.isShowingEditor()) {
            visName = ((EntryEditor)this.splitPane.getBottomComponent()).getVisiblePanelName();
        }
        EntryEditor entryEditor = new EntryEditor(this.frame, this, be);
        if (visName != null) {
            entryEditor.setVisiblePanel(visName);
        }
        this.showEntryEditor(entryEditor);
        this.newEntryShowing(be);
        this.setEntryEditorEnabled(true);
    }

    public EntryEditor getEntryEditor(BibEntry entry) {
        this.storeCurrentEdit();
        return new EntryEditor(this.frame, this, entry);
    }

    public EntryEditor getCurrentEditor() {
        return this.currentEditor;
    }

    public void showEntryEditor(EntryEditor editor) {
        if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
        this.mode = BasePanelMode.SHOWING_EDITOR;
        if (this.currentEditor != null) {
            this.currentEditor.setMovingToDifferentEntry();
        }
        this.currentEditor = editor;
        this.splitPane.setBottomComponent(editor);
        if (editor.getEntry() != this.getShowing()) {
            this.newEntryShowing(editor.getEntry());
        }
        this.adjustSplitter();
    }

    public void showPreview(PreviewPanel preview) {
        this.mode = BasePanelMode.SHOWING_PREVIEW;
        this.splitPane.setBottomComponent(preview);
        this.adjustSplitter();
    }

    public void hideBottomComponent() {
        this.mode = BasePanelMode.SHOWING_NOTHING;
        this.splitPane.setBottomComponent(null);
    }

    public void highlightEntry(BibEntry bibEntry) {
        this.highlightEntry(this.mainTable.findEntry(bibEntry));
    }

    public void highlightEntry(int pos) {
        if (pos >= 0 && pos < this.mainTable.getRowCount()) {
            this.mainTable.setRowSelectionInterval(pos, pos);
            this.mainTable.ensureVisible(pos);
        }
    }

    public void selectPreviousEntry() {
        this.highlightEntry((this.mainTable.getSelectedRow() - 1 + this.mainTable.getRowCount()) % this.mainTable.getRowCount());
    }

    public void selectNextEntry() {
        this.highlightEntry((this.mainTable.getSelectedRow() + 1) % this.mainTable.getRowCount());
    }

    public void selectFirstEntry() {
        this.highlightEntry(0);
    }

    public void selectLastEntry() {
        this.highlightEntry(this.mainTable.getRowCount() - 1);
    }

    public void entryEditorClosing(EntryEditor editor) {
        Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        this.selectionListener.entryEditorClosing(editor);
    }

    public void ensureNotShowingBottomPanel(BibEntry entry) {
        if (this.mode == BasePanelMode.SHOWING_EDITOR && this.currentEditor.getEntry() == entry || this.mode == BasePanelMode.SHOWING_PREVIEW && this.selectionListener.getPreview().getEntry() == entry) {
            this.hideBottomComponent();
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            if (this.currentEditor.getDisplayedBibEntryType().equals(this.currentEditor.getEntry().getType())) {
                this.currentEditor.updateAllFields();
                this.currentEditor.updateSource();
            } else {
                this.newEntryShowing(null);
                EntryEditor newEditor = this.getEntryEditor(this.currentEditor.getEntry());
                this.showEntryEditor(newEditor);
            }
        }
    }

    public void storeCurrentEdit() {
        if (this.isShowingEditor()) {
            EntryEditor editor = (EntryEditor)this.splitPane.getBottomComponent();
            editor.storeCurrentEdit();
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.markBasedChangedInternal();
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.markBasedChangedInternal());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.info("Problem marking database as changed", e);
            }
        }
    }

    private void markBasedChangedInternal() {
        this.frame.setWindowTitle();
        this.frame.updateAllTabTitles();
        if (this.frame.getStatusLineText().startsWith(Localization.lang("Saved database", new String[0]))) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    private synchronized void markChangedOrUnChanged() {
        if (this.getUndoManager().hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.getBibDatabaseContext().getDatabaseFile().isPresent()) {
                this.frame.setTabTitle(this, this.getTabTitle(), this.getBibDatabaseContext().getDatabaseFile().get().getAbsolutePath());
            } else {
                this.frame.setTabTitle(this, GUIGlobals.UNTITLED_TITLE, null);
            }
        }
        this.frame.setWindowTitle();
    }

    public BibDatabase getDatabase() {
        return this.bibDatabaseContext.getDatabase();
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void changeTypeOfSelectedEntries(String newType) {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        this.changeType(bes, newType);
    }

    private void changeType(List<BibEntry> entries, String newType) {
        int choice;
        if (entries == null || entries.isEmpty()) {
            LOGGER.error("At least one entry must be selected to be able to change the type.");
            return;
        }
        if (entries.size() > 1 && (choice = JOptionPane.showConfirmDialog(this, Localization.lang("Multiple entries selected. Do you want to change the type of all these to '%0'?", newType), Localization.lang("Change entry type", new String[0]), 0, 2)) == 1) {
            return;
        }
        NamedCompound compound = new NamedCompound(Localization.lang("Change entry type", new String[0]));
        for (BibEntry entry : entries) {
            compound.addEdit(new UndoableChangeType(entry, entry.getType(), newType));
            entry.setType(newType);
        }
        this.output(this.formatOutputMessage(Localization.lang("Changed type to '%0' for", newType), entries.size()));
        compound.end();
        this.getUndoManager().addEdit(compound);
        this.markBaseChanged();
        this.updateEntryEditorIfShowing();
    }

    public boolean showDeleteConfirmationDialog(int numberOfEntries) {
        if (Globals.prefs.getBoolean("confirmDelete")) {
            String msg = Localization.lang("Really delete the selected entry?", new String[0]);
            String title = Localization.lang("Delete entry", new String[0]);
            if (numberOfEntries > 1) {
                msg = Localization.lang("Really delete the %0 selected entries?", Integer.toString(numberOfEntries));
                title = Localization.lang("Delete multiple entries", new String[0]);
            }
            CheckBoxMessage cb = new CheckBoxMessage(msg, Localization.lang("Disable this confirmation dialog", new String[0]), false);
            int answer = JOptionPane.showConfirmDialog(this.frame, cb, title, 0, 3);
            if (cb.isSelected()) {
                Globals.prefs.putBoolean("confirmDelete", false);
            }
            return answer == 0;
        }
        return true;
    }

    public void autoGenerateKeysBeforeSaving() {
        if (Globals.prefs.getBoolean("generateKeysBeforeSaving")) {
            NamedCompound ce = new NamedCompound(Localization.lang("Autogenerate BibTeX keys", new String[0]));
            for (BibEntry bes : this.bibDatabaseContext.getDatabase().getEntries()) {
                Optional<String> oldKey = bes.getCiteKeyOptional();
                if (oldKey.isPresent() && !oldKey.get().isEmpty()) continue;
                BibtexKeyPatternUtil.makeLabel(this.bibDatabaseContext.getMetaData().getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), this.bibDatabaseContext.getDatabase(), bes, Globals.prefs.getBibtexKeyPatternPreferences());
                ce.addEdit(new UndoableKeyChange(bes, oldKey.orElse(""), bes.getCiteKeyOptional().get()));
            }
            if (ce.hasEdits()) {
                ce.end();
                this.getUndoManager().addEdit(ce);
            }
        }
    }

    private void setPreviewActive(boolean enabled) {
        this.selectionListener.setPreviewActive(enabled);
    }

    public void saveDividerLocation() {
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            int previewPanelHeight = this.splitPane.getHeight() - this.splitPane.getDividerLocation();
            PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences().getBuilder().withPreviewPanelHeight(previewPanelHeight).build();
            Globals.prefs.storePreviewPreferences(previewPreferences);
        } else if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void setEntryEditorEnabled(boolean enabled) {
        EntryEditor ed;
        if (this.getShowing() != null && this.splitPane.getBottomComponent() instanceof EntryEditor && (ed = (EntryEditor)this.splitPane.getBottomComponent()).isEnabled() != enabled) {
            ed.setEnabled(enabled);
        }
    }

    public String fileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    @Override
    public void fileUpdated() {
        if (this.saving) {
            return;
        }
        this.updatedExternally = true;
        ChangeScanner scanner = new ChangeScanner(this.frame, this, this.getBibDatabaseContext().getDatabaseFile().orElse(null));
        if (this.getBibDatabaseContext().getDatabaseFile().isPresent() && !FileBasedLock.waitForFileLock(this.getBibDatabaseContext().getDatabaseFile().get().toPath())) {
            LOGGER.error("File updated externally, but change scan failed because the file is locked.");
            Globals.getFileUpdateMonitor().perturbTimestamp(this.getFileMonitorHandle());
            return;
        }
        JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThreadAndWait(scanner);
        Runnable t = () -> {
            boolean hasAlready = this.sidePaneManager.hasComponent(FileUpdatePanel.class);
            if (hasAlready) {
                this.sidePaneManager.hideComponent(FileUpdatePanel.class);
                this.sidePaneManager.unregisterComponent(FileUpdatePanel.class);
            }
            FileUpdatePanel pan = new FileUpdatePanel(this, this.sidePaneManager, this.getBibDatabaseContext().getDatabaseFile().orElse(null), scanner);
            this.sidePaneManager.register(pan);
            this.sidePaneManager.show(FileUpdatePanel.class);
        };
        if (scanner.changesFound()) {
            SwingUtilities.invokeLater(t);
        } else {
            this.setUpdatedExternally(false);
        }
    }

    @Override
    public void fileRemoved() {
        LOGGER.info("File '" + this.getBibDatabaseContext().getDatabaseFile().get().getPath() + "' has been deleted.");
    }

    public void cleanUp() {
        FileUpdatePanel fup;
        if (this.fileMonitorHandle != null) {
            Globals.getFileUpdateMonitor().removeUpdateListener(this.fileMonitorHandle);
        }
        if (this.sidePaneManager.hasComponent(FileUpdatePanel.class) && (fup = (FileUpdatePanel)this.sidePaneManager.getComponent(FileUpdatePanel.class)).getPanel() == this) {
            this.sidePaneManager.hideComponent(FileUpdatePanel.class);
        }
    }

    public void setUpdatedExternally(boolean b) {
        this.updatedExternally = b;
    }

    public List<BibEntry> getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public BibDatabaseContext getBibDatabaseContext() {
        return this.bibDatabaseContext;
    }

    public GroupSelector getGroupSelector() {
        return this.frame.getGroupSelector();
    }

    public boolean isUpdatedExternally() {
        return this.updatedExternally;
    }

    public String getFileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    public void setFileMonitorHandle(String fileMonitorHandle) {
        this.fileMonitorHandle = fileMonitorHandle;
    }

    public SidePaneManager getSidePaneManager() {
        return this.sidePaneManager;
    }

    public void setNonUndoableChange(boolean nonUndoableChange) {
        this.nonUndoableChange = nonUndoableChange;
    }

    public void setBaseChanged(boolean baseChanged) {
        this.baseChanged = baseChanged;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isSaving() {
        return this.saving;
    }

    private BibEntry getShowing() {
        return this.showing;
    }

    public void newEntryShowing(BibEntry entry) {
        if (this.backOrForwardInProgress) {
            this.showing = entry;
            this.backOrForwardInProgress = false;
            this.setBackAndForwardEnabledState();
            return;
        }
        this.nextEntries.clear();
        if (!Objects.equals(entry, this.showing)) {
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
                if (this.previousEntries.size() > 10) {
                    this.previousEntries.remove(0);
                }
            }
            this.showing = entry;
            this.setBackAndForwardEnabledState();
        }
    }

    private void back() {
        if (!this.previousEntries.isEmpty()) {
            BibEntry toShow = this.previousEntries.get(this.previousEntries.size() - 1);
            this.previousEntries.remove(this.previousEntries.size() - 1);
            if (this.showing != null) {
                this.nextEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    private void forward() {
        if (!this.nextEntries.isEmpty()) {
            BibEntry toShow = this.nextEntries.get(this.nextEntries.size() - 1);
            this.nextEntries.remove(this.nextEntries.size() - 1);
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    public void setBackAndForwardEnabledState() {
        this.frame.getBackAction().setEnabled(!this.previousEntries.isEmpty());
        this.frame.getForwardAction().setEnabled(!this.nextEntries.isEmpty());
    }

    private String formatOutputMessage(String start, int count) {
        return String.format("%s %d %s.", start, count, count > 1 ? Localization.lang("entries", new String[0]) : Localization.lang("entry", new String[0]));
    }

    private void setPreviewActiveBasePanels(boolean enabled) {
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            this.frame.getBasePanelAt(i).setPreviewActive(enabled);
        }
    }

    public CountingUndoManager getUndoManager() {
        return this.undoManager;
    }

    public MainTable getMainTable() {
        return this.mainTable;
    }

    public BibDatabaseContext getDatabaseContext() {
        return this.bibDatabaseContext;
    }

    public SearchQuery getCurrentSearchQuery() {
        return this.currentSearchQuery;
    }

    public void setCurrentSearchQuery(SearchQuery currentSearchQuery) {
        this.currentSearchQuery = currentSearchQuery;
    }

    public CitationStyleCache getCitationStyleCache() {
        return this.citationStyleCache;
    }

    public PreviewPanel getPreviewPanel() {
        if (this.selectionListener == null) {
            return null;
        }
        return this.selectionListener.getPreview();
    }

    private static class SearchAndOpenFile {
        private final BibEntry entry;
        private final BasePanel basePanel;

        public SearchAndOpenFile(BibEntry entry, BasePanel basePanel) {
            this.entry = entry;
            this.basePanel = basePanel;
        }

        /*
         * WARNING - void declaration
         */
        public Optional<String> searchAndOpen() {
            Optional<ExternalFileType> type;
            String filepath;
            Optional<String> extension;
            List res;
            void var6_10;
            if (!Globals.prefs.getBoolean("runAutomaticFileSearch")) {
                return Optional.empty();
            }
            List<BibEntry> entries = Collections.singletonList(this.entry);
            Set<ExternalFileType> types = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
            ArrayList<File> dirs = new ArrayList<File>();
            List<String> mdDirs = this.basePanel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            for (String string : mdDirs) {
                dirs.add(new File(string));
            }
            ArrayList<String> extensions = new ArrayList<String>();
            for (ExternalFileType type2 : types) {
                extensions.add(type2.getExtension());
            }
            if (Globals.prefs.getBoolean("useRegExpSearch")) {
                String regExp = Globals.prefs.get("regExpSearchExpression");
                Map<BibEntry, List<File>> map = RegExpFileSearch.findFilesForSet(entries, extensions, dirs, regExp, Globals.prefs.getKeywordDelimiter());
            } else {
                boolean autoLinkExactKeyOnly = Globals.prefs.getBoolean("autolinkExactKeyOnly");
                Map<BibEntry, List<File>> map = FileUtil.findAssociatedFiles(entries, extensions, dirs, autoLinkExactKeyOnly);
            }
            if (var6_10.containsKey(this.entry) && !(res = (List)var6_10.get(this.entry)).isEmpty() && (extension = FileUtil.getFileExtension(filepath = ((File)res.get(0)).getPath())).isPresent() && (type = ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension.get())).isPresent()) {
                try {
                    JabRefDesktop.openExternalFileAnyFormat(this.basePanel.getBibDatabaseContext(), filepath, type);
                    this.basePanel.output(Localization.lang("External viewer called", new String[0]) + '.');
                    return Optional.of(filepath);
                }
                catch (IOException ex) {
                    this.basePanel.output(Localization.lang("Error", new String[0]) + ": " + ex.getMessage());
                }
            }
            return Optional.empty();
        }
    }

    private class SaveSelectedAction
    implements BaseAction {
        private final SavePreferences.DatabaseSaveType saveType;

        public SaveSelectedAction(SavePreferences.DatabaseSaveType saveType) {
            this.saveType = saveType;
        }

        @Override
        public void action() throws SaveException {
            FileDialog dialog = new FileDialog(BasePanel.this.frame).withExtension(FileExtensions.BIBTEX_DB);
            dialog.setDefaultExtension(FileExtensions.BIBTEX_DB);
            Optional<Path> chosenFile = dialog.saveNewFile();
            if (chosenFile.isPresent()) {
                Path path = chosenFile.get();
                BasePanel.this.saveDatabase(path.toFile(), true, Globals.prefs.getDefaultEncoding(), this.saveType);
                BasePanel.this.frame.getFileHistory().newFile(path.toString());
                BasePanel.this.frame.output(Localization.lang("Saved selected to '%0'.", path.toString()));
            }
        }
    }

    private class PrintPreviewAction
    implements BaseAction {
        private PrintPreviewAction() {
        }

        @Override
        public void action() throws Exception {
            BasePanel.this.selectionListener.setPreviewActive(true);
            BasePanel.this.showPreview(BasePanel.this.selectionListener.getPreview());
            BasePanel.this.selectionListener.getPreview().getPrintAction().actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    private class RedoAction
    implements BaseAction {
        private RedoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent focused = Globals.getFocusListener().getFocused();
                if (focused != null && focused instanceof FieldEditor && focused.hasFocus()) {
                    BasePanel.this.storeCurrentEdit();
                }
                BasePanel.this.getUndoManager().redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(Localization.lang("Redo", new String[0]));
            }
            catch (CannotRedoException ex) {
                BasePanel.this.frame.output(Localization.lang("Nothing to redo", new String[0]) + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    private class OpenURLAction
    implements BaseAction {
        private OpenURLAction() {
        }

        @Override
        public void action() {
            List<BibEntry> bes = BasePanel.this.mainTable.getSelectedEntries();
            if (bes.size() == 1) {
                String field = "doi";
                Optional<String> link = bes.get(0).getField("doi");
                if (bes.get(0).hasField("url")) {
                    link = bes.get(0).getField("url");
                    field = "url";
                }
                if (link.isPresent()) {
                    try {
                        JabRefDesktop.openExternalViewer(BasePanel.this.bibDatabaseContext, link.get(), field);
                        BasePanel.this.output(Localization.lang("External viewer called", new String[0]) + '.');
                    }
                    catch (IOException ex) {
                        BasePanel.this.output(Localization.lang("Error", new String[0]) + ": " + ex.getMessage());
                    }
                } else {
                    FileListEntry entry = null;
                    FileListTableModel tm = new FileListTableModel();
                    bes.get(0).getField("file").ifPresent(tm::setContent);
                    for (int i = 0; i < tm.getRowCount(); ++i) {
                        FileListEntry flEntry = tm.getEntry(i);
                        if (!"url".equalsIgnoreCase(flEntry.type.get().getName()) && !"ps".equalsIgnoreCase(flEntry.type.get().getName()) && !"pdf".equalsIgnoreCase(flEntry.type.get().getName())) continue;
                        entry = flEntry;
                        break;
                    }
                    if (entry == null) {
                        BasePanel.this.output(Localization.lang("No URL defined", new String[0]) + '.');
                    } else {
                        try {
                            JabRefDesktop.openExternalFileAnyFormat(BasePanel.this.bibDatabaseContext, entry.link, entry.type);
                            BasePanel.this.output(Localization.lang("External viewer called", new String[0]) + '.');
                        }
                        catch (IOException e) {
                            BasePanel.this.output(Localization.lang("Could not open link", new String[0]));
                            LOGGER.info("Could not open link", e);
                        }
                    }
                }
            } else {
                BasePanel.this.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
            }
        }
    }

    private class UndoAction
    implements BaseAction {
        private UndoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent focused = Globals.getFocusListener().getFocused();
                if (focused != null && focused instanceof FieldEditor && focused.hasFocus()) {
                    if (BasePanel.this.preambleEditor != null && focused == BasePanel.this.preambleEditor.getFieldEditor()) {
                        BasePanel.this.preambleEditor.storeCurrentEdit();
                    } else {
                        BasePanel.this.storeCurrentEdit();
                    }
                }
                BasePanel.this.getUndoManager().undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(Localization.lang("Undo", new String[0]));
            }
            catch (CannotUndoException ex) {
                LOGGER.warn("Nothing to undo", ex);
                BasePanel.this.frame.output(Localization.lang("Nothing to undo", new String[0]) + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    private class SearchListener {
        private SearchListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            BasePanel.this.frame.getGlobalSearchBar().setDontSelectSearchBar(true);
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }

        @Subscribe
        public void listen(EntryRemovedEvent removedEntryEvent) {
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }
    }

    private class AutoCompleteListener {
        private AutoCompleteListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            BasePanel.this.autoCompleters.addEntry(addedEntryEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            BasePanel.this.autoCompleters.addEntry(entryChangedEvent.getBibEntry());
        }
    }

    private class SearchAutoCompleteListener {
        private SearchAutoCompleteListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            BasePanel.this.searchAutoCompleter.addBibtexEntry(addedEntryEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            BasePanel.this.searchAutoCompleter.addBibtexEntry(entryChangedEvent.getBibEntry());
        }
    }

    private class GroupTreeListener {
        private final Runnable task = new Runnable(){

            @Override
            public void run() {
                BasePanel.this.frame.getGroupSelector().revalidateGroups();
            }
        };
        private TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                GroupTreeListener.this.task.run();
            }
        };

        private GroupTreeListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            if (addedEntryEvent.getEntryEventSource() == EntryEventSource.UNDO) {
                this.scheduleUpdate();
                return;
            }
            if (Globals.prefs.getBoolean("autoAssignGroup") && BasePanel.this.frame.getGroupSelector().getToggleAction().isSelected()) {
                List<BibEntry> entries = Collections.singletonList(addedEntryEvent.getBibEntry());
                TreePath[] selection = BasePanel.this.frame.getGroupSelector().getGroupsTree().getSelectionPaths();
                if (selection != null) {
                    for (TreePath tree : selection) {
                        ((GroupTreeNodeViewModel)tree.getLastPathComponent()).addEntriesToGroup(entries);
                    }
                }
                SwingUtilities.invokeLater(() -> BasePanel.this.getGroupSelector().valueChanged(null));
            }
            this.scheduleUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleUpdate() {
            Runnable runnable = this.task;
            synchronized (runnable) {
                this.timerTask.cancel();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        GroupTreeListener.this.task.run();
                    }
                };
                JabRefExecutorService.INSTANCE.submit(this.timerTask, 200L);
            }
        }
    }
}

