/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableRemoveString;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibtexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringRemoveChange
extends Change {
    private final BibtexString string;
    private final BibtexString inMem;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringRemoveChange.class);

    public StringRemoveChange(BibtexString string, BibtexString tmpString, BibtexString inMem) {
        super(Localization.lang("Removed string", new String[0]) + ": '" + string.getName() + '\'');
        this.tmpString = tmpString;
        this.string = string;
        this.inMem = inMem;
        this.tp.setText("<HTML><H2>" + Localization.lang("Removed string", new String[0]) + "</H2><H3>" + Localization.lang("Label", new String[0]) + ":</H3>" + string.getName() + "<H3>" + Localization.lang("Content", new String[0]) + ":</H3>" + string.getContent() + "</HTML>");
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        try {
            panel.getDatabase().removeString(this.inMem.getId());
            undoEdit.addEdit(new UndoableRemoveString(panel, panel.getDatabase(), this.string));
        }
        catch (Exception ex) {
            LOGGER.info("Error: could not add string '" + this.string.getName() + "': " + ex.getMessage(), ex);
        }
        secondary.removeString(this.tmpString.getId());
        return true;
    }

    @Override
    public JComponent description() {
        return this.sp;
    }
}

