/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.collab.Change;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableInsertString;
import net.sf.jabref.gui.undo.UndoableStringChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.entry.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringNameChange
extends Change {
    private final BibtexString string;
    private final String mem;
    private final String disk;
    private final String content;
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringNameChange.class);

    public StringNameChange(BibtexString string, BibtexString tmpString, String mem, String tmp, String disk, String content) {
        super(Localization.lang("Renamed string", new String[0]) + ": '" + tmp + '\'');
        this.tmpString = tmpString;
        this.string = string;
        this.content = content;
        this.mem = mem;
        this.disk = disk;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        BibtexString bs;
        String newId;
        if (panel.getDatabase().hasStringLabel(this.disk)) {
            LOGGER.info("Cannot rename string '" + this.mem + "' to '" + this.disk + "' because the name " + "is already in use.");
        }
        if (this.string == null) {
            newId = IdGenerator.next();
            bs = new BibtexString(newId, this.disk, this.content);
            try {
                panel.getDatabase().addString(bs);
                undoEdit.addEdit(new UndoableInsertString(panel, panel.getDatabase(), bs));
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Error: could not add string '" + bs.getName() + "': " + ex.getMessage(), ex);
            }
        } else {
            this.string.setName(this.disk);
            undoEdit.addEdit(new UndoableStringChange(panel, this.string, true, this.mem, this.disk));
        }
        if (this.tmpString == null) {
            newId = IdGenerator.next();
            bs = new BibtexString(newId, this.disk, this.content);
            secondary.addString(bs);
        } else {
            this.tmpString.setName(this.disk);
        }
        return true;
    }

    @Override
    public JComponent description() {
        return new JLabel(this.disk + " : " + this.content);
    }
}

