/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableInsertString;
import net.sf.jabref.gui.undo.UndoableStringChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.entry.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringChange
extends Change {
    private final BibtexString string;
    private final String mem;
    private final String disk;
    private final String label;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringChange.class);

    public StringChange(BibtexString string, BibtexString tmpString, String label, String mem, String disk) {
        super(Localization.lang("Modified string", new String[0]) + ": '" + label + '\'');
        this.tmpString = tmpString;
        this.string = string;
        this.label = label;
        this.mem = mem;
        this.disk = disk;
        StringBuilder sb = new StringBuilder(46);
        sb.append("<HTML><H2>").append(Localization.lang("Modified string", new String[0])).append("</H2><H3>").append(Localization.lang("Label", new String[0])).append(":</H3>").append(label).append("<H3>").append(Localization.lang("New content", new String[0])).append(":</H3>").append(disk);
        if (string == null) {
            sb.append("<P><I>");
            sb.append(Localization.lang("Cannot merge this change", new String[0])).append(": ");
            sb.append(Localization.lang("The string has been removed locally", new String[0])).append("</I>");
        } else {
            sb.append("<H3>");
            sb.append(Localization.lang("Current content", new String[0])).append(":</H3>");
            sb.append(string.getContent());
        }
        sb.append("</HTML>");
        this.tp.setText(sb.toString());
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        if (this.string == null) {
            String newId = IdGenerator.next();
            BibtexString bs = new BibtexString(newId, this.label, this.disk);
            try {
                panel.getDatabase().addString(bs);
                undoEdit.addEdit(new UndoableInsertString(panel, panel.getDatabase(), bs));
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Error: could not add string '" + bs.getName() + "': " + ex.getMessage(), ex);
            }
        } else {
            this.string.setContent(this.disk);
            undoEdit.addEdit(new UndoableStringChange(panel, this.string, false, this.mem, this.disk));
        }
        if (this.tmpString == null) {
            BibtexString bs = new BibtexString(IdGenerator.next(), this.label, this.disk);
            secondary.addString(bs);
        } else {
            this.tmpString.setContent(this.disk);
        }
        return true;
    }

    @Override
    public JComponent description() {
        return this.sp;
    }
}

