/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.metadata.MetaData;

class MetaDataChange
extends Change {
    private final InfoPane infoPane = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.infoPane);
    private final MetaData originalMetaData;
    private final MetaData newMetaData;

    public MetaDataChange(MetaData originalMetaData, MetaData newMetaData) {
        super(Localization.lang("Metadata change", new String[0]));
        this.originalMetaData = originalMetaData;
        this.newMetaData = newMetaData;
        this.infoPane.setText("<html>" + Localization.lang("Metadata change", new String[0]) + "</html>");
    }

    @Override
    public JComponent description() {
        return this.sp;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        panel.getBibDatabaseContext().setMetaData(this.newMetaData);
        return true;
    }
}

