/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.collab.Change;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.UndoableModifySubtree;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.groups.AllEntriesGroup;
import net.sf.jabref.model.groups.GroupTreeNode;

class GroupChange
extends Change {
    private final GroupTreeNode changedGroups;
    private final GroupTreeNode tmpGroupRoot;

    public GroupChange(GroupTreeNode changedGroups, GroupTreeNode tmpGroupRoot) {
        super(changedGroups == null ? Localization.lang("Removed all groups", new String[0]) : Localization.lang("Modified groups tree", new String[0]));
        this.changedGroups = changedGroups;
        this.tmpGroupRoot = tmpGroupRoot;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        GroupTreeNode root = panel.getBibDatabaseContext().getMetaData().getGroups().orElse(null);
        UndoableModifySubtree undo = new UndoableModifySubtree(new GroupTreeNodeViewModel(panel.getBibDatabaseContext().getMetaData().getGroups().orElse(null)), new GroupTreeNodeViewModel(root), Localization.lang("Modified groups", new String[0]));
        root.removeAllChildren();
        if (this.changedGroups == null) {
            root.setGroup(new AllEntriesGroup(Localization.lang("All entries", new String[0])));
        } else {
            root.setGroup(this.changedGroups.getGroup());
            for (GroupTreeNode child : this.changedGroups.getChildren()) {
                ((GroupTreeNode)child.copySubtree()).moveTo(root);
            }
            root.refreshGroupsForNewDatabase(panel.getDatabase());
        }
        undoEdit.addEdit(undo);
        this.tmpGroupRoot.removeAllChildren();
        if (this.changedGroups != null) {
            GroupTreeNode copied = (GroupTreeNode)this.changedGroups.copySubtree();
            this.tmpGroupRoot.setGroup(copied.getGroup());
            for (GroupTreeNode child : copied.getChildren()) {
                ((GroupTreeNode)child.copySubtree()).moveTo(this.tmpGroupRoot);
            }
        }
        this.tmpGroupRoot.refreshGroupsForNewDatabase(secondary);
        return true;
    }

    @Override
    public JComponent description() {
        return new JLabel("<html>" + this.toString() + '.' + (this.changedGroups == null ? "" : ' ' + Localization.lang("Accepting the change replaces the complete groups tree with the externally modified groups tree.", new String[0])) + "</html>");
    }
}

