/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.SidePaneComponent;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.logic.l10n.Localization;

public class FileUpdatePanel
extends SidePaneComponent
implements ActionListener,
ChangeScanner.DisplayResultCallback {
    private final SidePaneManager manager;
    private final ChangeScanner scanner;

    public FileUpdatePanel(BasePanel panel, SidePaneManager manager, File file, ChangeScanner scanner) {
        super(manager, IconTheme.JabRefIcon.SAVE.getIcon(), Localization.lang("File changed", new String[0]));
        this.close.setEnabled(false);
        this.panel = panel;
        this.manager = manager;
        this.scanner = scanner;
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        JLabel message = new JLabel("<html><center>" + Localization.lang("The file<BR>'%0'<BR>has been modified<BR>externally!", file.getName()) + "</center></html>", 0);
        main.add((Component)message, "Center");
        JButton test = new JButton(Localization.lang("Review changes", new String[0]));
        main.add((Component)test, "South");
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        test.addActionListener(this);
    }

    public BasePanel getPanel() {
        return this.panel;
    }

    @Override
    public void componentClosing() {
        this.manager.unregisterComponent(FileUpdatePanel.class);
    }

    @Override
    public int getRescalingWeight() {
        return 0;
    }

    @Override
    public SidePaneComponent.ToggleAction getToggleAction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.scanner.displayResult(this);
    }

    @Override
    public void scanResultsResolved(boolean resolved) {
        if (resolved) {
            this.manager.hideComponent(this);
            this.panel.setUpdatedExternally(false);
        }
    }
}

