/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.collab.ChangeDisplayDialog;
import net.sf.jabref.collab.EntryAddChange;
import net.sf.jabref.collab.EntryChange;
import net.sf.jabref.collab.EntryDeleteChange;
import net.sf.jabref.collab.GroupChange;
import net.sf.jabref.collab.MetaDataChange;
import net.sf.jabref.collab.PreambleChange;
import net.sf.jabref.collab.StringAddChange;
import net.sf.jabref.collab.StringChange;
import net.sf.jabref.collab.StringNameChange;
import net.sf.jabref.collab.StringRemoveChange;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.logic.bibtex.comparator.EntryComparator;
import net.sf.jabref.logic.exporter.BibtexDatabaseWriter;
import net.sf.jabref.logic.exporter.FileSaveSession;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.OpenDatabase;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.DuplicateCheck;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.database.EntrySorter;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.metadata.MetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeScanner
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(ChangeScanner.class);
    private static final String[] SORT_BY = new String[]{"year", "author", "title"};
    private final File file;
    private final BibDatabase databaseInMemory;
    private final MetaData metadataInMemory;
    private final BasePanel panel;
    private final JabRefFrame frame;
    private BibDatabase databaseInTemp;
    private MetaData metadataInTemp;
    private static final double MATCH_THRESHOLD = 0.4;
    private final DefaultMutableTreeNode changes = new DefaultMutableTreeNode(Localization.lang("External changes", new String[0]));

    public ChangeScanner(JabRefFrame frame, BasePanel bp, File file) {
        this.panel = bp;
        this.frame = frame;
        this.databaseInMemory = bp.getDatabase();
        this.metadataInMemory = bp.getBibDatabaseContext().getMetaData();
        this.file = file;
    }

    @Override
    public void run() {
        try {
            Path tempFile = Globals.getFileUpdateMonitor().getTempFile(this.panel.fileMonitorHandle());
            ImportFormatPreferences importFormatPreferences = Globals.prefs.getImportFormatPreferences();
            ParserResult result = OpenDatabase.loadDatabase(tempFile.toFile(), importFormatPreferences);
            this.databaseInTemp = result.getDatabase();
            this.metadataInTemp = result.getMetaData();
            result = OpenDatabase.loadDatabase(this.file, importFormatPreferences);
            BibDatabase databaseOnDisk = result.getDatabase();
            MetaData metadataOnDisk = result.getMetaData();
            EntryComparator comparator = new EntryComparator(false, true, SORT_BY[2]);
            comparator = new EntryComparator(false, true, SORT_BY[1], comparator);
            comparator = new EntryComparator(false, true, SORT_BY[0], comparator);
            EntrySorter sorterInTemp = this.databaseInTemp.getSorter(comparator);
            comparator = new EntryComparator(false, true, SORT_BY[2]);
            comparator = new EntryComparator(false, true, SORT_BY[1], comparator);
            comparator = new EntryComparator(false, true, SORT_BY[0], comparator);
            EntrySorter sorterOnDisk = databaseOnDisk.getSorter(comparator);
            comparator = new EntryComparator(false, true, SORT_BY[2]);
            comparator = new EntryComparator(false, true, SORT_BY[1], comparator);
            comparator = new EntryComparator(false, true, SORT_BY[0], comparator);
            EntrySorter sorterInMem = this.databaseInMemory.getSorter(comparator);
            this.scanMetaData(this.metadataInMemory, this.metadataInTemp, metadataOnDisk);
            this.scanPreamble(this.databaseInMemory, this.databaseInTemp, databaseOnDisk);
            this.scanStrings(this.databaseInMemory, this.databaseInTemp, databaseOnDisk);
            this.scanEntries(sorterInMem, sorterInTemp, sorterOnDisk);
            this.scanGroups(this.metadataInTemp, metadataOnDisk);
        }
        catch (IOException ex) {
            LOGGER.warn("Problem running", ex);
        }
    }

    public boolean changesFound() {
        return this.changes.getChildCount() > 0;
    }

    public void displayResult(DisplayResultCallback fup) {
        if (this.changes.getChildCount() > 0) {
            SwingUtilities.invokeLater(() -> {
                ChangeDisplayDialog changeDialog = new ChangeDisplayDialog(this.frame, this.panel, this.databaseInTemp, this.changes);
                changeDialog.setLocationRelativeTo(this.frame);
                changeDialog.setVisible(true);
                fup.scanResultsResolved(changeDialog.isOkPressed());
                if (changeDialog.isOkPressed()) {
                    this.storeTempDatabase();
                }
            });
        } else {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("No actual changes found.", new String[0]), Localization.lang("External changes", new String[0]), 1);
            fup.scanResultsResolved(true);
        }
    }

    private void storeTempDatabase() {
        JabRefExecutorService.INSTANCE.execute(() -> {
            try {
                SavePreferences prefs = SavePreferences.loadForSaveFromPreferences(Globals.prefs).withMakeBackup(false).withEncoding(this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));
                Defaults defaults = new Defaults(BibDatabaseMode.fromPreference(Globals.prefs.getBoolean("biblatexMode")));
                BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
                Object ss = databaseWriter.saveDatabase(new BibDatabaseContext(this.databaseInTemp, this.metadataInTemp, defaults), prefs);
                ((SaveSession)ss).commit(Globals.getFileUpdateMonitor().getTempFile(this.panel.fileMonitorHandle()));
            }
            catch (SaveException ex) {
                LOGGER.warn("Problem updating tmp file after accepting external changes", ex);
            }
        });
    }

    private void scanMetaData(MetaData inMemory, MetaData onTmp, MetaData onDisk) {
        if (!onTmp.isEmpty()) {
            if (!inMemory.equals(onDisk)) {
                this.changes.add(new MetaDataChange(inMemory, onDisk));
            }
        } else if (!onDisk.isEmpty() || !onTmp.equals(onDisk)) {
            this.changes.add(new MetaDataChange(inMemory, onDisk));
        }
    }

    private void scanEntries(EntrySorter memorySorter, EntrySorter tmpSorter, EntrySorter diskSorter) {
        int piv1;
        int piv2 = 0;
        HashSet<String> used = new HashSet<String>(diskSorter.getEntryCount());
        HashSet<Integer> notMatched = new HashSet<Integer>(tmpSorter.getEntryCount());
        block0: for (piv1 = 0; piv1 < tmpSorter.getEntryCount(); ++piv1) {
            double comp = -1.0;
            if (!used.contains(String.valueOf(piv2)) && piv2 < diskSorter.getEntryCount()) {
                comp = DuplicateCheck.compareEntriesStrictly(tmpSorter.getEntryAt(piv1), diskSorter.getEntryAt(piv2));
            }
            if (comp > 1.0) {
                used.add(String.valueOf(piv2));
                ++piv2;
                continue;
            }
            if (piv2 < diskSorter.getEntryCount() - 1) {
                for (int i = piv2 + 1; i < diskSorter.getEntryCount(); ++i) {
                    comp = used.contains(String.valueOf(i)) ? -1.0 : DuplicateCheck.compareEntriesStrictly(tmpSorter.getEntryAt(piv1), diskSorter.getEntryAt(i));
                    if (!(comp > 1.0)) continue;
                    used.add(String.valueOf(i));
                    continue block0;
                }
            }
            notMatched.add(piv1);
        }
        if (!notMatched.isEmpty()) {
            Iterator it = notMatched.iterator();
            while (it.hasNext()) {
                piv1 = (Integer)it.next();
                int bestMatchI = -1;
                double bestMatch = 0.0;
                if (piv2 < diskSorter.getEntryCount() - 1) {
                    for (int i = piv2; i < diskSorter.getEntryCount(); ++i) {
                        double comp = used.contains(String.valueOf(i)) ? -1.0 : DuplicateCheck.compareEntriesStrictly(tmpSorter.getEntryAt(piv1), diskSorter.getEntryAt(i));
                        if (!(comp > bestMatch)) continue;
                        bestMatch = comp;
                        bestMatchI = i;
                    }
                }
                if (bestMatch > 0.4) {
                    used.add(String.valueOf(bestMatchI));
                    it.remove();
                    this.changes.add(new EntryChange(ChangeScanner.bestFit(tmpSorter, memorySorter, piv1), tmpSorter.getEntryAt(piv1), diskSorter.getEntryAt(bestMatchI)));
                    continue;
                }
                this.changes.add(new EntryDeleteChange(ChangeScanner.bestFit(tmpSorter, memorySorter, piv1), tmpSorter.getEntryAt(piv1)));
            }
        }
        if (used.size() < diskSorter.getEntryCount()) {
            for (int i = 0; i < diskSorter.getEntryCount(); ++i) {
                if (used.contains(String.valueOf(i))) continue;
                boolean hasAlready = false;
                for (int j = 0; j < memorySorter.getEntryCount(); ++j) {
                    if (!(DuplicateCheck.compareEntriesStrictly(memorySorter.getEntryAt(j), diskSorter.getEntryAt(i)) >= 1.0)) continue;
                    hasAlready = true;
                    break;
                }
                if (hasAlready) continue;
                this.changes.add(new EntryAddChange(diskSorter.getEntryAt(i)));
            }
        }
    }

    private static BibEntry bestFit(EntrySorter oldSorter, EntrySorter newSorter, int index) {
        double comp = -1.0;
        int found = 0;
        for (int i = 0; i < newSorter.getEntryCount(); ++i) {
            double res = DuplicateCheck.compareEntriesStrictly(oldSorter.getEntryAt(index), newSorter.getEntryAt(i));
            if (res > comp) {
                comp = res;
                found = i;
            }
            if (comp > 1.0) break;
        }
        return newSorter.getEntryAt(found);
    }

    private void scanPreamble(BibDatabase inMemory, BibDatabase onTmp, BibDatabase onDisk) {
        String mem = inMemory.getPreamble().orElse(null);
        Optional<String> tmp = onTmp.getPreamble();
        Optional<String> disk = onDisk.getPreamble();
        if (!tmp.isPresent()) {
            disk.ifPresent(diskContent -> this.changes.add(new PreambleChange(mem, (String)diskContent)));
        } else if (!disk.isPresent() || !tmp.equals(disk)) {
            this.changes.add(new PreambleChange(mem, disk.orElse(null)));
        }
    }

    private void scanStrings(BibDatabase inMem1, BibDatabase inTmp, BibDatabase onDisk) {
        Object tmp;
        if (inTmp.hasNoStrings() && onDisk.hasNoStrings()) {
            return;
        }
        HashSet<String> used = new HashSet<String>();
        HashSet<Object> usedInMem = new HashSet<Object>();
        HashSet<String> notMatched = new HashSet<String>(inTmp.getStringCount());
        block0: for (String key : inTmp.getStringKeySet()) {
            tmp = inTmp.getString(key);
            for (String diskId : onDisk.getStringKeySet()) {
                BibtexString disk;
                if (used.contains(diskId) || !(disk = onDisk.getString(diskId)).getName().equals(((BibtexString)tmp).getName())) continue;
                if (!Objects.equals(((BibtexString)tmp).getContent(), disk.getContent())) {
                    Optional<BibtexString> mem = ChangeScanner.findString(inMem1, ((BibtexString)tmp).getName(), usedInMem);
                    if (mem.isPresent()) {
                        this.changes.add(new StringChange(mem.get(), (BibtexString)tmp, ((BibtexString)tmp).getName(), mem.get().getContent(), disk.getContent()));
                    } else {
                        this.changes.add(new StringChange(null, (BibtexString)tmp, ((BibtexString)tmp).getName(), null, disk.getContent()));
                    }
                }
                used.add(diskId);
                continue block0;
            }
            notMatched.add(((BibtexString)tmp).getId());
        }
        if (!notMatched.isEmpty()) {
            Iterator i = notMatched.iterator();
            while (i.hasNext()) {
                BibtexString tmp2 = inTmp.getString((String)i.next());
                for (String diskId : onDisk.getStringKeySet()) {
                    BibtexString disk;
                    if (used.contains(diskId) || !(disk = onDisk.getString(diskId)).getContent().equals(tmp2.getContent())) continue;
                    BibtexString bsMem = null;
                    for (String memId : inMem1.getStringKeySet()) {
                        BibtexString bsMemCandidate = inMem1.getString(memId);
                        if (!bsMemCandidate.getContent().equals(disk.getContent()) || usedInMem.contains(memId)) continue;
                        usedInMem.add(memId);
                        bsMem = bsMemCandidate;
                        break;
                    }
                    if (bsMem == null) continue;
                    this.changes.add(new StringNameChange(bsMem, tmp2, bsMem.getName(), tmp2.getName(), disk.getName(), tmp2.getContent()));
                    i.remove();
                    used.add(diskId);
                }
            }
        }
        if (!notMatched.isEmpty()) {
            for (String notMatchedId : notMatched) {
                tmp = inTmp.getString(notMatchedId);
                ChangeScanner.findString(inMem1, ((BibtexString)tmp).getName(), usedInMem).ifPresent(arg_0 -> this.lambda$scanStrings$3((BibtexString)tmp, arg_0));
            }
        }
        for (String diskId : onDisk.getStringKeySet()) {
            if (used.contains(diskId)) continue;
            BibtexString disk = onDisk.getString(diskId);
            used.add(diskId);
            this.changes.add(new StringAddChange(disk));
        }
    }

    private static Optional<BibtexString> findString(BibDatabase base, String name, Set<Object> used) {
        if (!base.hasStringLabel(name)) {
            return Optional.empty();
        }
        for (String key : base.getStringKeySet()) {
            BibtexString bs = base.getString(key);
            if (!bs.getName().equals(name) || used.contains(key)) continue;
            used.add(key);
            return Optional.of(bs);
        }
        return Optional.empty();
    }

    private void scanGroups(MetaData inTemp, MetaData onDisk) {
        Optional<GroupTreeNode> groupsTmp = inTemp.getGroups();
        Optional<GroupTreeNode> groupsDisk = onDisk.getGroups();
        if (!groupsTmp.isPresent() && !groupsDisk.isPresent()) {
            return;
        }
        if (groupsTmp.isPresent() && !groupsDisk.isPresent() || !groupsTmp.isPresent()) {
            this.changes.add(new GroupChange(groupsDisk.orElse(null), groupsTmp.orElse(null)));
            return;
        }
        if (!groupsTmp.equals(groupsDisk)) {
            this.changes.add(new GroupChange(groupsDisk.get(), groupsTmp.get()));
        }
    }

    private /* synthetic */ void lambda$scanStrings$3(BibtexString tmp, BibtexString x) {
        this.changes.add(new StringRemoveChange(tmp, tmp, x));
    }

    @FunctionalInterface
    public static interface DisplayResultCallback {
        public void scanResultsResolved(boolean var1);
    }
}

