/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerException;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.bibtex.BibEntryWriter;
import net.sf.jabref.logic.bibtex.LatexFieldFormatter;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.xmp.XMPUtil;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.jempbox.impl.XMLUtil;
import org.w3c.dom.Node;

public class XMPUtilMain {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, TransformerException {
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        xmpPreferences = Globals.prefs.getXMPPreferences();
        importFormatPreferences = Globals.prefs.getImportFormatPreferences();
        switch (args.length) {
            case 0: {
                XMPUtilMain.usage();
                break;
            }
            case 1: {
                if (args[0].endsWith(".pdf")) {
                    l = XMPUtil.readXMP(new File(args[0]), xmpPreferences);
                    bibtexEntryWriter = new BibEntryWriter(new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()), false);
                    for (BibEntry entry : l) {
                        sw = new StringWriter();
                        bibtexEntryWriter.write(entry, sw, BibDatabaseMode.BIBTEX);
                        System.out.println(sw.getBuffer());
                    }
                    break;
                }
                if (!args[0].endsWith(".bib")) ** GOTO lbl54
                fr = new FileReader(args[0]);
                bibtexEntryWriter = null;
                result = BibtexParser.parse(fr, importFormatPreferences);
                entries = result.getDatabase().getEntries();
                if (entries.isEmpty()) {
                    System.err.println("Could not find BibEntry in " + args[0]);
                } else {
                    System.out.println(XMPUtil.toXMP(entries, result.getDatabase(), xmpPreferences));
                }
                if (fr == null) break;
                if (bibtexEntryWriter == null) ** GOTO lbl37
                try {
                    fr.close();
                }
                catch (Throwable result) {
                    bibtexEntryWriter.addSuppressed(result);
                }
                break;
lbl37:
                // 1 sources

                fr.close();
                break;
                catch (Throwable result) {
                    try {
                        bibtexEntryWriter = result;
                        throw result;
                    }
                    catch (Throwable var8_20) {
                        if (fr != null) {
                            if (bibtexEntryWriter != null) {
                                try {
                                    fr.close();
                                }
                                catch (Throwable var9_21) {
                                    bibtexEntryWriter.addSuppressed(var9_21);
                                }
                            } else {
                                fr.close();
                            }
                        }
                        throw var8_20;
                    }
                }
lbl54:
                // 1 sources

                XMPUtilMain.usage();
                break;
            }
            case 2: {
                if ("-x".equals(args[0]) && args[1].endsWith(".pdf")) {
                    meta = XMPUtil.readRawXMP(new File(args[1]));
                    if (meta.isPresent()) {
                        XMLUtil.save((Node)meta.get().getXMPDocument(), System.out, StandardCharsets.UTF_8.name());
                        break;
                    }
                    System.err.println("The given pdf does not contain any XMP-metadata.");
                    break;
                }
                if (args[0].endsWith(".bib") && args[1].endsWith(".pdf")) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), StandardCharsets.UTF_8));
                    result = new BibtexParser(importFormatPreferences).parse(reader);
                    entries = result.getDatabase().getEntries();
                    if (entries.isEmpty()) {
                        System.err.println("Could not find BibEntry in " + args[0]);
                        break;
                    }
                    XMPUtil.writeXMP(new File(args[1]), entries, result.getDatabase(), false, xmpPreferences);
                    System.out.println("XMP written.");
                    break;
                }
                XMPUtilMain.usage();
                break;
            }
            case 3: {
                if (!args[1].endsWith(".bib") && !args[2].endsWith(".pdf")) {
                    XMPUtilMain.usage();
                    break;
                }
                result = BibtexParser.parse(new FileReader(args[1]), importFormatPreferences);
                bibEntry = result.getDatabase().getEntryByKey(args[0]);
                if (bibEntry.isPresent()) {
                    XMPUtil.writeXMP(new File(args[2]), bibEntry.get(), result.getDatabase(), xmpPreferences);
                    System.out.println("XMP written.");
                    break;
                }
                System.err.println("Could not find BibEntry " + args[0] + " in " + args[0]);
                break;
            }
            default: {
                XMPUtilMain.usage();
            }
        }
    }

    private static void usage() {
        System.out.println("Read or write XMP-metadata from or to pdf file.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("Read from PDF and print as bibtex:");
        System.out.println("  xmpUtil <pdf>");
        System.out.println("Read from PDF and print raw XMP:");
        System.out.println("  xmpUtil -x <pdf>");
        System.out.println("Write the entry in <bib> given by <key> to the PDF:");
        System.out.println("  xmpUtil <key> <bib> <pdf>");
        System.out.println("Write all entries in <bib> to the PDF:");
        System.out.println("  xmpUtil <bib> <pdf>");
        System.out.println("");
        System.out.println("To report bugs visit http://jabref.sourceforge.net");
    }
}

