/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.cli;

import java.util.Arrays;
import java.util.List;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.l10n.Localization;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefCLI {
    private static final Log LOGGER = LogFactory.getLog(JabRefCLI.class);
    private List<String> leftOver;
    private final CommandLine cl;

    public JabRefCLI(String[] args) {
        Options options = this.getOptions();
        try {
            this.cl = new DefaultParser().parse(options, args);
            this.leftOver = Arrays.asList(this.cl.getArgs());
        }
        catch (ParseException e) {
            LOGGER.warn("Problem parsing arguments", e);
            this.printUsage();
            throw new RuntimeException();
        }
    }

    public boolean isHelp() {
        return this.cl.hasOption("help");
    }

    public boolean isShowVersion() {
        return this.cl.hasOption("version");
    }

    public boolean isBlank() {
        return this.cl.hasOption("blank");
    }

    public boolean isLoadSession() {
        return this.cl.hasOption("loads");
    }

    public boolean isDisableGui() {
        return this.cl.hasOption("nogui");
    }

    public boolean isPreferencesExport() {
        return this.cl.hasOption("prexp");
    }

    public String getPreferencesExport() {
        return this.cl.getOptionValue("prexp", "jabref_prefs.xml");
    }

    public boolean isPreferencesImport() {
        return this.cl.hasOption("primp");
    }

    public String getPreferencesImport() {
        return this.cl.getOptionValue("primp", "jabref_prefs.xml");
    }

    public boolean isPreferencesReset() {
        return this.cl.hasOption("prdef");
    }

    public String getPreferencesReset() {
        return this.cl.getOptionValue("prdef");
    }

    public boolean isFileExport() {
        return this.cl.hasOption("output");
    }

    public String getFileExport() {
        return this.cl.getOptionValue("output");
    }

    public boolean isFileImport() {
        return this.cl.hasOption("import");
    }

    public String getFileImport() {
        return this.cl.getOptionValue("import");
    }

    public boolean isAuxImport() {
        return this.cl.hasOption("aux");
    }

    public String getAuxImport() {
        return this.cl.getOptionValue("aux");
    }

    public boolean isImportToOpenBase() {
        return this.cl.hasOption("importToOpen");
    }

    public String getImportToOpenBase() {
        return this.cl.getOptionValue("importToOpen");
    }

    public boolean isDebugLogging() {
        return this.cl.hasOption("debug");
    }

    public boolean isFetcherEngine() {
        return this.cl.hasOption("fetch");
    }

    public String getFetcherEngine() {
        return this.cl.getOptionValue("fetch");
    }

    public boolean isExportMatches() {
        return this.cl.hasOption("exportMatches");
    }

    public String getExportMatches() {
        return this.cl.getOptionValue("exportMatches");
    }

    public boolean isGenerateBibtexKeys() {
        return this.cl.hasOption("generateBibtexKeys");
    }

    public boolean isAutomaticallySetFileLinks() {
        return this.cl.hasOption("automaticallySetFileLinks");
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("v", "version", false, Localization.lang("Display version", new String[0]));
        options.addOption("n", "nogui", false, Localization.lang("No GUI. Only process command line options.", new String[0]));
        options.addOption("h", "help", false, Localization.lang("Display help on command line options", new String[0]));
        options.addOption("b", "blank", false, Localization.lang("Do not open any files at startup", new String[0]));
        options.addOption(null, "debug", false, Localization.lang("Show debug level messages", new String[0]));
        options.addOption(Option.builder("i").longOpt("import").desc(String.format("%s: %s[,import format]", Localization.lang("Import file", new String[0]), Localization.lang("filename", new String[0]))).hasArg().argName("FILE").build());
        options.addOption(Option.builder("o").longOpt("output").desc(String.format("%s: %s[,export format]", Localization.lang("Output or export file", new String[0]), Localization.lang("filename", new String[0]))).hasArg().argName("FILE").build());
        options.addOption(Option.builder("x").longOpt("prexp").desc(Localization.lang("Export preferences to file", new String[0])).hasArg().argName("FILE").build());
        options.addOption(Option.builder("p").longOpt("primp").desc(Localization.lang("Import preferences from file", new String[0])).hasArg().argName("FILE").build());
        options.addOption(Option.builder("d").longOpt("prdef").desc(Localization.lang("Reset preferences (key1,key2,... or 'all')", new String[0])).hasArg().argName("FILE").build());
        options.addOption(Option.builder("a").longOpt("aux").desc(String.format("%s: %s[.aux],%s[.bib]", Localization.lang("Subdatabase from AUX", new String[0]), Localization.lang("file", new String[0]), Localization.lang("new", new String[0]))).hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("importToOpen").desc(Localization.lang("Import to open tab", new String[0])).hasArg().argName("FILE").build());
        options.addOption(Option.builder("f").longOpt("fetch").desc(Localization.lang("Run fetcher, e.g. \"--fetch=Medline:cancer\"", new String[0])).hasArg().argName("FILE").build());
        options.addOption(Option.builder("m").longOpt("exportMatches").desc(JabRefCLI.getExportMatchesSyntax()).hasArg().argName("FILE").build());
        options.addOption(Option.builder("g").longOpt("generateBibtexKeys").desc(Localization.lang("Regenerate all keys for the entries in a BibTeX file", new String[0])).build());
        options.addOption(Option.builder("asfl").longOpt("automaticallySetFileLinks").desc(Localization.lang("Automatically set file links", new String[0])).build());
        return options;
    }

    public void displayVersion() {
        System.out.println(this.getVersionInfo());
    }

    public void printUsage() {
        String header = "";
        String importFormats = Globals.IMPORT_FORMAT_READER.getImportFormatList();
        String importFormatsList = String.format("%s:%n%s%n", Localization.lang("Available import formats", new String[0]), importFormats);
        String outFormats = ExportFormats.getConsoleExportList(70, 20, "");
        String outFormatsList = String.format("%s: %s%n", Localization.lang("Available export formats", new String[0]), outFormats);
        String footer = '\n' + importFormatsList + outFormatsList + "\nPlease report issues at https://github.com/JabRef/jabref/issues";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("jabref [OPTIONS] [BIBTEX_FILE]\n\nOptions:", header, this.getOptions(), footer, true);
    }

    private String getVersionInfo() {
        return String.format("JabRef %s", Globals.BUILD_INFO.getVersion());
    }

    public List<String> getLeftOver() {
        return this.leftOver;
    }

    public static String getExportMatchesSyntax() {
        return String.format("[%s]searchTerm,outputFile: %s[,%s]", Localization.lang("field", new String[0]), Localization.lang("file", new String[0]), Localization.lang("exportFormat", new String[0]));
    }
}

