/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.cli;

import net.sf.jabref.logic.auxparser.AuxParser;
import net.sf.jabref.logic.auxparser.AuxParserResult;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.strings.StringUtil;

public class AuxCommandLine {
    private final String auxFile;
    private final BibDatabase database;

    public AuxCommandLine(String auxFile, BibDatabase database) {
        this.auxFile = StringUtil.getCorrectFileName(auxFile, "aux");
        this.database = database;
    }

    public BibDatabase perform() {
        BibDatabase subDatabase = null;
        if (!this.auxFile.isEmpty() && this.database != null) {
            AuxParser auxParser = new AuxParser(this.auxFile, this.database);
            AuxParserResult result = auxParser.parse();
            subDatabase = result.getGeneratedBibDatabase();
            System.out.println(result.getInformation(true));
        }
        return subDatabase;
    }
}

