/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefException;
import net.sf.jabref.cli.AuxCommandLine;
import net.sf.jabref.cli.ImportInspectionCommandLine;
import net.sf.jabref.cli.JabRefCLI;
import net.sf.jabref.cli.SystemOutputPrinter;
import net.sf.jabref.gui.externalfiles.AutoSetLinks;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.gui.importer.fetcher.EntryFetchers;
import net.sf.jabref.logic.CustomEntryTypesManager;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.exporter.BibtexDatabaseWriter;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.FileSaveSession;
import net.sf.jabref.logic.exporter.IExportFormat;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.importer.ImportFormatReader;
import net.sf.jabref.logic.importer.OpenDatabase;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.logging.JabRefLogger;
import net.sf.jabref.logic.search.DatabaseSearcher;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.model.strings.StringUtil;
import net.sf.jabref.preferences.SearchPreferences;
import net.sf.jabref.shared.prefs.SharedDatabasePreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArgumentProcessor {
    private static final Log LOGGER = LogFactory.getLog(ArgumentProcessor.class);
    private final JabRefCLI cli;
    private final List<ParserResult> parserResults;
    private final Mode startupMode;
    private boolean noGUINeeded;

    public ArgumentProcessor(String[] args, Mode startupMode) {
        this.cli = new JabRefCLI(args);
        this.startupMode = startupMode;
        this.parserResults = this.processArguments();
    }

    public List<ParserResult> getParserResults() {
        return this.parserResults;
    }

    public boolean hasParserResults() {
        return !this.parserResults.isEmpty();
    }

    private List<ParserResult> processArguments() {
        if (!this.cli.isBlank() && this.cli.isDebugLogging()) {
            JabRefLogger.setDebug();
        }
        if (this.startupMode == Mode.INITIAL_START && this.cli.isShowVersion()) {
            this.cli.displayVersion();
        }
        if (this.startupMode == Mode.INITIAL_START && this.cli.isHelp()) {
            this.cli.printUsage();
            this.noGUINeeded = true;
            return Collections.emptyList();
        }
        if (this.cli.isPreferencesReset()) {
            this.resetPreferences(this.cli.getPreferencesReset());
        }
        if (this.cli.isPreferencesImport()) {
            this.importPreferences();
        }
        List<ParserResult> loaded = this.importAndOpenFiles();
        if (!this.cli.isBlank() && this.cli.isFetcherEngine()) {
            this.fetch(this.cli.getFetcherEngine()).ifPresent(loaded::add);
        }
        if (this.cli.isExportMatches()) {
            if (!loaded.isEmpty()) {
                if (!this.exportMatches(loaded)) {
                    return Collections.emptyList();
                }
            } else {
                System.err.println(Localization.lang("The output option depends on a valid input option.", new String[0]));
            }
        }
        if (this.cli.isGenerateBibtexKeys()) {
            this.regenerateBibtexKeys(loaded);
        }
        if (this.cli.isAutomaticallySetFileLinks()) {
            this.automaticallySetFileLinks(loaded);
        }
        if (this.cli.isFileExport()) {
            if (!loaded.isEmpty()) {
                this.exportFile(loaded, this.cli.getFileExport().split(","));
            } else {
                System.err.println(Localization.lang("The output option depends on a valid import option.", new String[0]));
            }
        }
        LOGGER.debug("Finished export");
        if (this.cli.isPreferencesExport()) {
            try {
                Globals.prefs.exportPreferences(this.cli.getPreferencesExport());
            }
            catch (JabRefException ex) {
                LOGGER.error("Cannot export preferences", ex);
            }
        }
        if (!this.cli.isBlank() && this.cli.isAuxImport()) {
            this.doAuxImport(loaded);
        }
        return loaded;
    }

    private boolean exportMatches(List<ParserResult> loaded) {
        String[] data = this.cli.getExportMatches().split(",");
        String searchTerm = data[0].replace("\\$", " ");
        ParserResult pr = loaded.get(loaded.size() - 1);
        BibDatabaseContext databaseContext = pr.getDatabaseContext();
        BibDatabase dataBase = pr.getDatabase();
        SearchPreferences searchPreferences = new SearchPreferences(Globals.prefs);
        SearchQuery query = new SearchQuery(searchTerm, searchPreferences.isCaseSensitive(), searchPreferences.isRegularExpression());
        List<BibEntry> matches = new DatabaseSearcher(query, dataBase).getMatches();
        if (!matches.isEmpty()) {
            String formatName;
            switch (data.length) {
                case 3: {
                    formatName = data[2];
                    break;
                }
                case 2: {
                    formatName = "tablerefsabsbib";
                    break;
                }
                default: {
                    System.err.println(Localization.lang("Output file missing", new String[0]).concat(". \n \t ").concat(Localization.lang("Usage", new String[0])).concat(": ") + JabRefCLI.getExportMatchesSyntax());
                    this.noGUINeeded = true;
                    return false;
                }
            }
            IExportFormat format = ExportFormats.getExportFormat(formatName);
            if (format == null) {
                System.err.println(Localization.lang("Unknown export format", new String[0]) + ": " + formatName);
            } else {
                try {
                    System.out.println(Localization.lang("Exporting", new String[0]) + ": " + data[1]);
                    format.performExport(databaseContext, data[1], databaseContext.getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), matches);
                }
                catch (Exception ex) {
                    System.err.println(Localization.lang("Could not export file", new String[0]) + " '" + data[1] + "': " + ex.getMessage());
                }
            }
        } else {
            System.err.println(Localization.lang("No search matches.", new String[0]));
        }
        return true;
    }

    private void doAuxImport(List<ParserResult> loaded) {
        boolean usageMsg = !loaded.isEmpty() ? this.generateAux(loaded, this.cli.getAuxImport().split(",")) : true;
        if (usageMsg) {
            System.out.println(Localization.lang("no base-BibTeX-file specified", new String[0]) + "!");
            System.out.println(Localization.lang("usage", new String[0]) + " :");
            System.out.println("jabref --aux infile[.aux],outfile[.bib] base-BibTeX-file");
        }
    }

    private List<ParserResult> importAndOpenFiles() {
        ArrayList<ParserResult> loaded = new ArrayList<ParserResult>();
        ArrayList<String> toImport = new ArrayList<String>();
        if (!this.cli.isBlank() && !this.cli.getLeftOver().isEmpty()) {
            for (String aLeftOver : this.cli.getLeftOver()) {
                boolean bibExtension = aLeftOver.toLowerCase(Locale.ENGLISH).endsWith("bib");
                ParserResult pr = ParserResult.getNullResult();
                if (bibExtension) {
                    pr = OpenDatabase.loadDatabase(aLeftOver, Globals.prefs.getImportFormatPreferences());
                }
                if (!bibExtension || pr.isNullResult()) {
                    if (this.startupMode == Mode.INITIAL_START) {
                        toImport.add(aLeftOver);
                        continue;
                    }
                    loaded.add(ArgumentProcessor.importToOpenBase(aLeftOver).orElse(ParserResult.getNullResult()));
                    continue;
                }
                loaded.add(pr);
            }
        }
        if (!this.cli.isBlank() && this.cli.isFileImport()) {
            toImport.add(this.cli.getFileImport());
        }
        for (String filenameString : toImport) {
            ArgumentProcessor.importFile(filenameString).ifPresent(loaded::add);
        }
        if (!this.cli.isBlank() && this.cli.isImportToOpenBase()) {
            ArgumentProcessor.importToOpenBase(this.cli.getImportToOpenBase()).ifPresent(loaded::add);
        }
        return loaded;
    }

    private boolean generateAux(List<ParserResult> loaded, String[] data) {
        if (data.length == 2) {
            ParserResult pr = loaded.get(0);
            AuxCommandLine acl = new AuxCommandLine(data[0], pr.getDatabase());
            BibDatabase newBase = acl.perform();
            boolean notSavedMsg = false;
            if (newBase != null && newBase.hasEntries()) {
                String subName = StringUtil.getCorrectFileName(data[1], "bib");
                try {
                    System.out.println(Localization.lang("Saving", new String[0]) + ": " + subName);
                    SavePreferences prefs = SavePreferences.loadForSaveFromPreferences(Globals.prefs);
                    BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
                    Defaults defaults = new Defaults(BibDatabaseMode.fromPreference(Globals.prefs.getBoolean("biblatexMode")));
                    Object session = databaseWriter.saveDatabase(new BibDatabaseContext(newBase, defaults), prefs);
                    if (!((SaveSession)session).getWriter().couldEncodeAll()) {
                        System.err.println(Localization.lang("Warning", new String[0]) + ": " + Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()) + " " + ((SaveSession)session).getWriter().getProblemCharacters());
                    }
                    ((SaveSession)session).commit(subName);
                }
                catch (SaveException ex) {
                    System.err.println(Localization.lang("Could not save file.", new String[0]) + "\n" + ex.getLocalizedMessage());
                }
                notSavedMsg = true;
            }
            if (!notSavedMsg) {
                System.out.println(Localization.lang("no database generated", new String[0]));
            }
            return false;
        }
        return true;
    }

    private void exportFile(List<ParserResult> loaded, String[] data) {
        if (data.length == 1) {
            if (!loaded.isEmpty()) {
                ParserResult pr = loaded.get(loaded.size() - 1);
                if (!pr.isInvalid()) {
                    try {
                        System.out.println(Localization.lang("Saving", new String[0]) + ": " + data[0]);
                        SavePreferences prefs = SavePreferences.loadForSaveFromPreferences(Globals.prefs);
                        Defaults defaults = new Defaults(BibDatabaseMode.fromPreference(Globals.prefs.getBoolean("biblatexMode")));
                        BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
                        Object session = databaseWriter.saveDatabase(new BibDatabaseContext(pr.getDatabase(), pr.getMetaData(), defaults), prefs);
                        if (!((SaveSession)session).getWriter().couldEncodeAll()) {
                            System.err.println(Localization.lang("Warning", new String[0]) + ": " + Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()) + " " + ((SaveSession)session).getWriter().getProblemCharacters());
                        }
                        ((SaveSession)session).commit(data[0]);
                    }
                    catch (SaveException ex) {
                        System.err.println(Localization.lang("Could not save file.", new String[0]) + "\n" + ex.getLocalizedMessage());
                    }
                }
            } else {
                System.err.println(Localization.lang("The output option depends on a valid import option.", new String[0]));
            }
        } else if (data.length == 2) {
            ParserResult pr = loaded.get(loaded.size() - 1);
            File theFile = pr.getFile().get();
            if (!theFile.isAbsolute()) {
                theFile = theFile.getAbsoluteFile();
            }
            BibDatabaseContext databaseContext = pr.getDatabaseContext();
            databaseContext.setDatabaseFile(theFile);
            Globals.prefs.fileDirForDatabase = databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            System.out.println(Localization.lang("Exporting", new String[0]) + ": " + data[0]);
            IExportFormat format = ExportFormats.getExportFormat(data[1]);
            if (format == null) {
                System.err.println(Localization.lang("Unknown export format", new String[0]) + ": " + data[1]);
            } else {
                try {
                    format.performExport(pr.getDatabaseContext(), data[0], pr.getDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), null);
                }
                catch (Exception ex) {
                    System.err.println(Localization.lang("Could not export file", new String[0]) + " '" + data[0] + "': " + ex.getMessage());
                }
            }
        }
    }

    private void importPreferences() {
        try {
            Globals.prefs.importPreferences(this.cli.getPreferencesImport());
            CustomEntryTypesManager.loadCustomEntryTypes(Globals.prefs);
            Map<String, ExportFormat> customFormats = Globals.prefs.customExports.getCustomExportFormats(Globals.prefs, Globals.journalAbbreviationLoader);
            LayoutFormatterPreferences layoutPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
            SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(Globals.prefs);
            ExportFormats.initAllExports(customFormats, layoutPreferences, savePreferences);
        }
        catch (JabRefException ex) {
            LOGGER.error("Cannot import preferences", ex);
        }
    }

    private void resetPreferences(String value) {
        if ("all".equals(value.trim())) {
            try {
                System.out.println(Localization.lang("Setting all preferences to default values.", new String[0]));
                Globals.prefs.clear();
                new SharedDatabasePreferences().clear();
            }
            catch (BackingStoreException e) {
                System.err.println(Localization.lang("Unable to clear preferences.", new String[0]));
                LOGGER.error("Unable to clear preferences", e);
            }
        } else {
            String[] keys;
            for (String key : keys = value.split(",")) {
                if (Globals.prefs.hasKey(key.trim())) {
                    System.out.println(Localization.lang("Resetting preference key '%0'", key.trim()));
                    Globals.prefs.clear(key.trim());
                    continue;
                }
                System.out.println(Localization.lang("Unknown preference key '%0'", key.trim()));
            }
        }
    }

    private void automaticallySetFileLinks(List<ParserResult> loaded) {
        for (ParserResult parserResult : loaded) {
            BibDatabase database = parserResult.getDatabase();
            LOGGER.info(Localization.lang("Automatically setting file links", new String[0]));
            AutoSetLinks.autoSetLinks(database.getEntries(), parserResult.getDatabaseContext());
        }
    }

    private void regenerateBibtexKeys(List<ParserResult> loaded) {
        for (ParserResult parserResult : loaded) {
            BibDatabase database = parserResult.getDatabase();
            MetaData metaData = parserResult.getMetaData();
            if (metaData != null) {
                LOGGER.info(Localization.lang("Regenerating BibTeX keys according to metadata", new String[0]));
                for (BibEntry entry : database.getEntries()) {
                    BibtexKeyPatternUtil.makeLabel(metaData.getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), database, entry, Globals.prefs.getBibtexKeyPatternPreferences());
                }
                continue;
            }
            LOGGER.info(Localization.lang("No meta data present in BIB_file. Cannot regenerate BibTeX keys", new String[0]));
        }
    }

    private Optional<ParserResult> fetch(String fetchCommand) {
        if (fetchCommand == null || !fetchCommand.contains(":") || fetchCommand.split(":").length != 2) {
            System.out.println(Localization.lang("Expected syntax for --fetch='<name of fetcher>:<query>'", new String[0]));
            System.out.println(Localization.lang("The following fetchers are available:", new String[0]));
            return Optional.empty();
        }
        String[] split = fetchCommand.split(":");
        String engine = split[0];
        EntryFetchers fetchers = new EntryFetchers(Globals.journalAbbreviationLoader);
        EntryFetcher fetcher = null;
        for (EntryFetcher e : fetchers.getEntryFetchers()) {
            if (!engine.equalsIgnoreCase(e.getClass().getSimpleName().replace("Fetcher", ""))) continue;
            fetcher = e;
        }
        if (fetcher == null) {
            System.out.println(Localization.lang("Could not find fetcher '%0'", engine));
            System.out.println(Localization.lang("The following fetchers are available:", new String[0]));
            for (EntryFetcher e : fetchers.getEntryFetchers()) {
                System.out.println("  " + e.getClass().getSimpleName().replace("Fetcher", "").toLowerCase(Locale.ENGLISH));
            }
            return Optional.empty();
        }
        String query = split[1];
        System.out.println(Localization.lang("Running query '%0' with fetcher '%1'.", query, engine) + " " + Localization.lang("Please wait...", new String[0]));
        Collection<BibEntry> result = new ImportInspectionCommandLine().query(query, fetcher);
        if (result.isEmpty()) {
            System.out.println(Localization.lang("Query '%0' with fetcher '%1' did not return any results.", query, engine));
            return Optional.empty();
        }
        return Optional.of(new ParserResult(result));
    }

    public boolean isBlank() {
        return this.cli.isBlank();
    }

    private static Optional<ParserResult> importToOpenBase(String argument) {
        Optional<ParserResult> result = ArgumentProcessor.importFile(argument);
        result.ifPresent(x -> x.setToOpenTab(true));
        return result;
    }

    private static Optional<ParserResult> importFile(String argument) {
        String[] data = argument.split(",");
        SystemOutputPrinter printer = new SystemOutputPrinter();
        try {
            if (data.length > 1 && !"*".equals(data[1])) {
                System.out.println(Localization.lang("Importing", new String[0]) + ": " + data[0]);
                try {
                    Path file = OS.WINDOWS ? Paths.get(data[0], new String[0]) : Paths.get(data[0].replace("~", System.getProperty("user.home")), new String[0]);
                    ParserResult result = Globals.IMPORT_FORMAT_READER.importFromFile(data[1], file);
                    if (result.hasWarnings()) {
                        printer.showMessage(result.getErrorMessage());
                    }
                    return Optional.of(result);
                }
                catch (IllegalArgumentException ex) {
                    System.err.println(Localization.lang("Unknown import format", new String[0]) + ": " + data[1]);
                    return Optional.empty();
                }
            }
            System.out.println(Localization.lang("Importing in unknown format", new String[0]) + ": " + data[0]);
            ImportFormatReader.UnknownFormatImport importResult = OS.WINDOWS ? Globals.IMPORT_FORMAT_READER.importUnknownFormat(data[0]) : Globals.IMPORT_FORMAT_READER.importUnknownFormat(data[0].replace("~", System.getProperty("user.home")));
            if (importResult != null) {
                System.out.println(Localization.lang("Format used", new String[0]) + ": " + importResult.format);
                return Optional.of(importResult.parserResult);
            }
            System.out.println(Localization.lang("Could not find a suitable import format.", new String[0]));
        }
        catch (IOException ex) {
            System.err.println(Localization.lang("Error opening file", new String[0]) + " '" + data[0] + "': " + ex.getLocalizedMessage());
        }
        return Optional.empty();
    }

    public boolean shouldShutDown() {
        return this.cli.isDisableGui() || this.cli.isShowVersion() || this.noGUINeeded;
    }

    public static enum Mode {
        INITIAL_START,
        REMOTE_START;

    }
}

