/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.net.Authenticator;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.cli.ArgumentProcessor;
import net.sf.jabref.gui.remote.JabRefMessageHandler;
import net.sf.jabref.logic.CustomEntryTypesManager;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.net.ProxyAuthenticator;
import net.sf.jabref.logic.net.ProxyPreferences;
import net.sf.jabref.logic.net.ProxyRegisterer;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import net.sf.jabref.logic.remote.RemotePreferences;
import net.sf.jabref.logic.remote.client.RemoteListenerClient;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.migrations.PreferencesMigrations;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefMain {
    private static final Log LOGGER = LogFactory.getLog(JabRefMain.class);

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> JabRefMain.start(args));
    }

    private static void start(String[] args) {
        JabRefPreferences preferences = JabRefPreferences.getInstance();
        ProxyPreferences proxyPreferences = preferences.getProxyPreferences();
        ProxyRegisterer.register(proxyPreferences);
        if (proxyPreferences.isUseProxy().booleanValue() && proxyPreferences.isUseAuthentication().booleanValue()) {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
        Globals.startBackgroundTasks();
        Globals.prefs = preferences;
        Localization.setLanguage(preferences.get("language"));
        Globals.prefs.setLanguageDependentDefaultValues();
        PreferencesMigrations.upgradeSortOrder();
        PreferencesMigrations.upgradeFaultyEncodingStrings();
        PreferencesMigrations.upgradeLabelPatternToBibtexKeyPattern();
        InternalBibtexFields.updateSpecialFields(Globals.prefs.getBoolean("serializeSpecialFields"));
        InternalBibtexFields.updateTimeStampField(Globals.prefs.get("timeStampField"));
        InternalBibtexFields.setNumericFields(Globals.prefs.getStringList("numericFields"));
        Globals.journalAbbreviationLoader = new JournalAbbreviationLoader();
        Globals.IMPORT_FORMAT_READER.resetImportFormats(Globals.prefs.getImportFormatPreferences(), Globals.prefs.getXMPPreferences());
        CustomEntryTypesManager.loadCustomEntryTypes(preferences);
        Map<String, ExportFormat> customFormats = Globals.prefs.customExports.getCustomExportFormats(Globals.prefs, Globals.journalAbbreviationLoader);
        LayoutFormatterPreferences layoutPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
        SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(Globals.prefs);
        ExportFormats.initAllExports(customFormats, layoutPreferences, savePreferences);
        Globals.protectedTermsLoader = new ProtectedTermsLoader(Globals.prefs.getProtectedTermsPreferences());
        ProtectTermsFormatter.setProtectedTermsLoader(Globals.protectedTermsLoader);
        RemotePreferences remotePreferences = Globals.prefs.getRemotePreferences();
        if (remotePreferences.useRemoteServer()) {
            Globals.REMOTE_LISTENER.open(new JabRefMessageHandler(), remotePreferences.getPort());
            if (!Globals.REMOTE_LISTENER.isOpen() && RemoteListenerClient.sendToActiveJabRefInstance(args, remotePreferences.getPort())) {
                LOGGER.info(Localization.lang("Arguments passed on to running JabRef instance. Shutting down.", new String[0]));
                JabRefExecutorService.INSTANCE.shutdownEverything();
                return;
            }
            Globals.REMOTE_LISTENER.start();
        }
        OS.NEWLINE = Globals.prefs.get("newline");
        ArgumentProcessor argumentProcessor = new ArgumentProcessor(args, ArgumentProcessor.Mode.INITIAL_START);
        if (argumentProcessor.shouldShutDown()) {
            JabRefExecutorService.INSTANCE.shutdownEverything();
            return;
        }
        SwingUtilities.invokeLater(() -> new JabRefGUI(argumentProcessor.getParserResults(), argumentProcessor.isBlank()));
    }
}

