/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefExecutorService
implements Executor {
    private static final Log LOGGER = LogFactory.getLog(UndoableInsertEntry.class);
    public static final JabRefExecutorService INSTANCE = new JabRefExecutorService();
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("JabRef CachedThreadPool");
        return thread;
    });
    private final ConcurrentLinkedQueue<Thread> startedThreads = new ConcurrentLinkedQueue();
    private final Timer timer = new Timer("timer", true);

    private JabRefExecutorService() {
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            return;
        }
        this.executorService.execute(command);
    }

    public void executeAndWait(Runnable command) {
        if (command == null) {
            return;
        }
        Future<?> future = this.executorService.submit(command);
        while (true) {
            try {
                future.get();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.error("Problem executing command", e);
                continue;
            }
            break;
        }
    }

    public void executeWithLowPriorityInOwnThread(Runnable runnable, String name) {
        Thread thread;
        AutoCleanupRunnable target = new AutoCleanupRunnable(runnable, this.startedThreads);
        target.thread = thread = new Thread(target);
        thread.setName("JabRef - " + name + " - low prio");
        this.startedThreads.add(thread);
        thread.setPriority(1);
        thread.start();
    }

    public void executeInOwnThread(Thread thread) {
        this.startedThreads.add(thread);
        thread.start();
    }

    public void executeWithLowPriorityInOwnThreadAndWait(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("JabRef low prio");
        this.startedThreads.add(thread);
        thread.setPriority(1);
        thread.start();
        this.waitForThreadToFinish(thread);
    }

    private void waitForThreadToFinish(Thread thread) {
        while (true) {
            try {
                thread.join();
                this.startedThreads.remove(thread);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void submit(TimerTask timerTask, long millisecondsDelay) {
        this.timer.schedule(timerTask, millisecondsDelay);
    }

    public void shutdownEverything() {
        this.executorService.shutdown();
        for (Thread thread : this.startedThreads) {
            thread.interrupt();
        }
        this.startedThreads.clear();
    }

    private static class AutoCleanupRunnable
    implements Runnable {
        private final Runnable runnable;
        private final ConcurrentLinkedQueue<Thread> startedThreads;
        public Thread thread;

        private AutoCleanupRunnable(Runnable runnable, ConcurrentLinkedQueue<Thread> startedThreads) {
            this.runnable = runnable;
            this.startedThreads = startedThreads;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                this.startedThreads.remove(this.thread);
            }
        }
    }
}

