/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.collab.FileUpdateMonitor;
import net.sf.jabref.gui.GlobalFocusListener;
import net.sf.jabref.gui.keyboard.KeyBindingPreferences;
import net.sf.jabref.logic.error.StreamEavesdropper;
import net.sf.jabref.logic.importer.ImportFormatReader;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import net.sf.jabref.logic.remote.server.RemoteListenerServerLifecycle;
import net.sf.jabref.logic.util.BuildInfo;
import net.sf.jabref.preferences.JabRefPreferences;

public class Globals {
    public static final BuildInfo BUILD_INFO = new BuildInfo();
    public static final RemoteListenerServerLifecycle REMOTE_LISTENER = new RemoteListenerServerLifecycle();
    public static final ImportFormatReader IMPORT_FORMAT_READER = new ImportFormatReader();
    public static JabRefPreferences prefs;
    public static JournalAbbreviationLoader journalAbbreviationLoader;
    public static ProtectedTermsLoader protectedTermsLoader;
    private static KeyBindingPreferences keyPrefs;
    private static GlobalFocusListener focusListener;
    private static FileUpdateMonitor fileUpdateMonitor;
    private static StreamEavesdropper streamEavesdropper;

    public static KeyBindingPreferences getKeyPrefs() {
        if (keyPrefs == null) {
            keyPrefs = new KeyBindingPreferences(prefs);
        }
        return keyPrefs;
    }

    public static void startBackgroundTasks() {
        focusListener = new GlobalFocusListener();
        streamEavesdropper = StreamEavesdropper.eavesdropOnSystem();
        fileUpdateMonitor = new FileUpdateMonitor();
        JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThread(fileUpdateMonitor, "FileUpdateMonitor");
    }

    public static GlobalFocusListener getFocusListener() {
        return focusListener;
    }

    public static FileUpdateMonitor getFileUpdateMonitor() {
        return fileUpdateMonitor;
    }

    public static StreamEavesdropper getStreamEavesdropper() {
        return streamEavesdropper;
    }
}

