/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLDateBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.CSLNameBuilder;
import de.undercouch.citeproc.csl.CSLType;

public class CSLItemDataBuilder {
    private String id;
    private CSLType type;
    private String[] categories;
    private String language;
    private String journalAbbreviation;
    private String shortTitle;
    private CSLName[] author;
    private CSLName[] collectionEditor;
    private CSLName[] composer;
    private CSLName[] containerAuthor;
    private CSLName[] director;
    private CSLName[] editor;
    private CSLName[] editorialDirector;
    private CSLName[] interviewer;
    private CSLName[] illustrator;
    private CSLName[] originalAuthor;
    private CSLName[] recipient;
    private CSLName[] reviewedAuthor;
    private CSLName[] translator;
    private CSLDate accessed;
    private CSLDate container;
    private CSLDate eventDate;
    private CSLDate issued;
    private CSLDate originalDate;
    private CSLDate submitted;
    private String abstrct;
    private String annote;
    private String archive;
    private String archiveLocation;
    private String archivePlace;
    private String authority;
    private String callNumber;
    private String chapterNumber;
    private String citationNumber;
    private String citationLabel;
    private String collectionNumber;
    private String collectionTitle;
    private String containerTitle;
    private String containerTitleShort;
    private String dimensions;
    private String DOI;
    private String edition;
    private String event;
    private String eventPlace;
    private String firstReferenceNoteNumber;
    private String genre;
    private String ISBN;
    private String ISSN;
    private String issue;
    private String jurisdiction;
    private String keyword;
    private String locator;
    private String medium;
    private String note;
    private String number;
    private String numberOfPages;
    private String numberOfVolumes;
    private String originalPublisher;
    private String originalPublisherPlace;
    private String originalTitle;
    private String page;
    private String pageFirst;
    private String PMCID;
    private String PMID;
    private String publisher;
    private String publisherPlace;
    private String references;
    private String reviewedTitle;
    private String scale;
    private String section;
    private String source;
    private String status;
    private String title;
    private String titleShort;
    private String URL;
    private String version;
    private String volume;
    private String yearSuffix;

    public CSLItemDataBuilder() {
        this.id = "-GEN-" + Long.toString((long)Math.floor(Math.random() * 1.0E14), 32);
        this.type = null;
        this.categories = null;
        this.language = null;
        this.journalAbbreviation = null;
        this.shortTitle = null;
        this.author = null;
        this.collectionEditor = null;
        this.composer = null;
        this.containerAuthor = null;
        this.director = null;
        this.editor = null;
        this.editorialDirector = null;
        this.interviewer = null;
        this.illustrator = null;
        this.originalAuthor = null;
        this.recipient = null;
        this.reviewedAuthor = null;
        this.translator = null;
        this.accessed = null;
        this.container = null;
        this.eventDate = null;
        this.issued = null;
        this.originalDate = null;
        this.submitted = null;
        this.abstrct = null;
        this.annote = null;
        this.archive = null;
        this.archiveLocation = null;
        this.archivePlace = null;
        this.authority = null;
        this.callNumber = null;
        this.chapterNumber = null;
        this.citationNumber = null;
        this.citationLabel = null;
        this.collectionNumber = null;
        this.collectionTitle = null;
        this.containerTitle = null;
        this.containerTitleShort = null;
        this.dimensions = null;
        this.DOI = null;
        this.edition = null;
        this.event = null;
        this.eventPlace = null;
        this.firstReferenceNoteNumber = null;
        this.genre = null;
        this.ISBN = null;
        this.ISSN = null;
        this.issue = null;
        this.jurisdiction = null;
        this.keyword = null;
        this.locator = null;
        this.medium = null;
        this.note = null;
        this.number = null;
        this.numberOfPages = null;
        this.numberOfVolumes = null;
        this.originalPublisher = null;
        this.originalPublisherPlace = null;
        this.originalTitle = null;
        this.page = null;
        this.pageFirst = null;
        this.PMCID = null;
        this.PMID = null;
        this.publisher = null;
        this.publisherPlace = null;
        this.references = null;
        this.reviewedTitle = null;
        this.scale = null;
        this.section = null;
        this.source = null;
        this.status = null;
        this.title = null;
        this.titleShort = null;
        this.URL = null;
        this.version = null;
        this.volume = null;
        this.yearSuffix = null;
    }

    public CSLItemDataBuilder id(String id) {
        this.id = id;
        return this;
    }

    public CSLItemDataBuilder type(CSLType type) {
        this.type = type;
        return this;
    }

    public CSLItemDataBuilder categories(String ... categories) {
        this.categories = categories;
        return this;
    }

    public CSLItemDataBuilder language(String language) {
        this.language = language;
        return this;
    }

    public CSLItemDataBuilder journalAbbreviation(String journalAbbreviation) {
        this.journalAbbreviation = journalAbbreviation;
        return this;
    }

    public CSLItemDataBuilder shortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
        return this;
    }

    public CSLItemDataBuilder author(CSLName ... author) {
        this.author = author;
        return this;
    }

    public CSLItemDataBuilder collectionEditor(CSLName ... collectionEditor) {
        this.collectionEditor = collectionEditor;
        return this;
    }

    public CSLItemDataBuilder composer(CSLName ... composer) {
        this.composer = composer;
        return this;
    }

    public CSLItemDataBuilder containerAuthor(CSLName ... containerAuthor) {
        this.containerAuthor = containerAuthor;
        return this;
    }

    public CSLItemDataBuilder director(CSLName ... director) {
        this.director = director;
        return this;
    }

    public CSLItemDataBuilder editor(CSLName ... editor) {
        this.editor = editor;
        return this;
    }

    public CSLItemDataBuilder editorialDirector(CSLName ... editorialDirector) {
        this.editorialDirector = editorialDirector;
        return this;
    }

    public CSLItemDataBuilder interviewer(CSLName ... interviewer) {
        this.interviewer = interviewer;
        return this;
    }

    public CSLItemDataBuilder illustrator(CSLName ... illustrator) {
        this.illustrator = illustrator;
        return this;
    }

    public CSLItemDataBuilder originalAuthor(CSLName ... originalAuthor) {
        this.originalAuthor = originalAuthor;
        return this;
    }

    public CSLItemDataBuilder recipient(CSLName ... recipient) {
        this.recipient = recipient;
        return this;
    }

    public CSLItemDataBuilder reviewedAuthor(CSLName ... reviewedAuthor) {
        this.reviewedAuthor = reviewedAuthor;
        return this;
    }

    public CSLItemDataBuilder translator(CSLName ... translator) {
        this.translator = translator;
        return this;
    }

    public CSLItemDataBuilder accessed(CSLDate accessed) {
        this.accessed = accessed;
        return this;
    }

    public CSLItemDataBuilder container(CSLDate container) {
        this.container = container;
        return this;
    }

    public CSLItemDataBuilder eventDate(CSLDate eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    public CSLItemDataBuilder issued(CSLDate issued) {
        this.issued = issued;
        return this;
    }

    public CSLItemDataBuilder originalDate(CSLDate originalDate) {
        this.originalDate = originalDate;
        return this;
    }

    public CSLItemDataBuilder submitted(CSLDate submitted) {
        this.submitted = submitted;
        return this;
    }

    public CSLItemDataBuilder abstrct(String abstrct) {
        this.abstrct = abstrct;
        return this;
    }

    public CSLItemDataBuilder annote(String annote) {
        this.annote = annote;
        return this;
    }

    public CSLItemDataBuilder archive(String archive) {
        this.archive = archive;
        return this;
    }

    public CSLItemDataBuilder archiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
        return this;
    }

    public CSLItemDataBuilder archivePlace(String archivePlace) {
        this.archivePlace = archivePlace;
        return this;
    }

    public CSLItemDataBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public CSLItemDataBuilder callNumber(String callNumber) {
        this.callNumber = callNumber;
        return this;
    }

    public CSLItemDataBuilder chapterNumber(String chapterNumber) {
        this.chapterNumber = chapterNumber;
        return this;
    }

    public CSLItemDataBuilder citationNumber(String citationNumber) {
        this.citationNumber = citationNumber;
        return this;
    }

    public CSLItemDataBuilder citationLabel(String citationLabel) {
        this.citationLabel = citationLabel;
        return this;
    }

    public CSLItemDataBuilder collectionNumber(String collectionNumber) {
        this.collectionNumber = collectionNumber;
        return this;
    }

    public CSLItemDataBuilder collectionTitle(String collectionTitle) {
        this.collectionTitle = collectionTitle;
        return this;
    }

    public CSLItemDataBuilder containerTitle(String containerTitle) {
        this.containerTitle = containerTitle;
        return this;
    }

    public CSLItemDataBuilder containerTitleShort(String containerTitleShort) {
        this.containerTitleShort = containerTitleShort;
        return this;
    }

    public CSLItemDataBuilder dimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public CSLItemDataBuilder DOI(String DOI2) {
        this.DOI = DOI2;
        return this;
    }

    public CSLItemDataBuilder edition(String edition) {
        this.edition = edition;
        return this;
    }

    public CSLItemDataBuilder event(String event) {
        this.event = event;
        return this;
    }

    public CSLItemDataBuilder eventPlace(String eventPlace) {
        this.eventPlace = eventPlace;
        return this;
    }

    public CSLItemDataBuilder firstReferenceNoteNumber(String firstReferenceNoteNumber) {
        this.firstReferenceNoteNumber = firstReferenceNoteNumber;
        return this;
    }

    public CSLItemDataBuilder genre(String genre) {
        this.genre = genre;
        return this;
    }

    public CSLItemDataBuilder ISBN(String ISBN2) {
        this.ISBN = ISBN2;
        return this;
    }

    public CSLItemDataBuilder ISSN(String ISSN2) {
        this.ISSN = ISSN2;
        return this;
    }

    public CSLItemDataBuilder issue(String issue) {
        this.issue = issue;
        return this;
    }

    public CSLItemDataBuilder jurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    public CSLItemDataBuilder keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public CSLItemDataBuilder locator(String locator) {
        this.locator = locator;
        return this;
    }

    public CSLItemDataBuilder medium(String medium) {
        this.medium = medium;
        return this;
    }

    public CSLItemDataBuilder note(String note) {
        this.note = note;
        return this;
    }

    public CSLItemDataBuilder number(String number) {
        this.number = number;
        return this;
    }

    public CSLItemDataBuilder numberOfPages(String numberOfPages) {
        this.numberOfPages = numberOfPages;
        return this;
    }

    public CSLItemDataBuilder numberOfVolumes(String numberOfVolumes) {
        this.numberOfVolumes = numberOfVolumes;
        return this;
    }

    public CSLItemDataBuilder originalPublisher(String originalPublisher) {
        this.originalPublisher = originalPublisher;
        return this;
    }

    public CSLItemDataBuilder originalPublisherPlace(String originalPublisherPlace) {
        this.originalPublisherPlace = originalPublisherPlace;
        return this;
    }

    public CSLItemDataBuilder originalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
        return this;
    }

    public CSLItemDataBuilder page(String page) {
        this.page = page;
        return this;
    }

    public CSLItemDataBuilder pageFirst(String pageFirst) {
        this.pageFirst = pageFirst;
        return this;
    }

    public CSLItemDataBuilder PMCID(String PMCID) {
        this.PMCID = PMCID;
        return this;
    }

    public CSLItemDataBuilder PMID(String PMID2) {
        this.PMID = PMID2;
        return this;
    }

    public CSLItemDataBuilder publisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public CSLItemDataBuilder publisherPlace(String publisherPlace) {
        this.publisherPlace = publisherPlace;
        return this;
    }

    public CSLItemDataBuilder references(String references) {
        this.references = references;
        return this;
    }

    public CSLItemDataBuilder reviewedTitle(String reviewedTitle) {
        this.reviewedTitle = reviewedTitle;
        return this;
    }

    public CSLItemDataBuilder scale(String scale) {
        this.scale = scale;
        return this;
    }

    public CSLItemDataBuilder section(String section) {
        this.section = section;
        return this;
    }

    public CSLItemDataBuilder source(String source) {
        this.source = source;
        return this;
    }

    public CSLItemDataBuilder status(String status) {
        this.status = status;
        return this;
    }

    public CSLItemDataBuilder title(String title) {
        this.title = title;
        return this;
    }

    public CSLItemDataBuilder titleShort(String titleShort) {
        this.titleShort = titleShort;
        return this;
    }

    public CSLItemDataBuilder URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    public CSLItemDataBuilder version(String version) {
        this.version = version;
        return this;
    }

    public CSLItemDataBuilder volume(String volume) {
        this.volume = volume;
        return this;
    }

    public CSLItemDataBuilder yearSuffix(String yearSuffix) {
        this.yearSuffix = yearSuffix;
        return this;
    }

    public CSLItemDataBuilder(CSLItemData original) {
        this.id = original.getId();
        this.type = original.getType();
        this.categories = original.getCategories();
        this.language = original.getLanguage();
        this.journalAbbreviation = original.getJournalAbbreviation();
        this.shortTitle = original.getShortTitle();
        this.author = original.getAuthor();
        this.collectionEditor = original.getCollectionEditor();
        this.composer = original.getComposer();
        this.containerAuthor = original.getContainerAuthor();
        this.director = original.getDirector();
        this.editor = original.getEditor();
        this.editorialDirector = original.getEditorialDirector();
        this.interviewer = original.getInterviewer();
        this.illustrator = original.getIllustrator();
        this.originalAuthor = original.getOriginalAuthor();
        this.recipient = original.getRecipient();
        this.reviewedAuthor = original.getReviewedAuthor();
        this.translator = original.getTranslator();
        this.accessed = original.getAccessed();
        this.container = original.getContainer();
        this.eventDate = original.getEventDate();
        this.issued = original.getIssued();
        this.originalDate = original.getOriginalDate();
        this.submitted = original.getSubmitted();
        this.abstrct = original.getAbstrct();
        this.annote = original.getAnnote();
        this.archive = original.getArchive();
        this.archiveLocation = original.getArchiveLocation();
        this.archivePlace = original.getArchivePlace();
        this.authority = original.getAuthority();
        this.callNumber = original.getCallNumber();
        this.chapterNumber = original.getChapterNumber();
        this.citationNumber = original.getCitationNumber();
        this.citationLabel = original.getCitationLabel();
        this.collectionNumber = original.getCollectionNumber();
        this.collectionTitle = original.getCollectionTitle();
        this.containerTitle = original.getContainerTitle();
        this.containerTitleShort = original.getContainerTitleShort();
        this.dimensions = original.getDimensions();
        this.DOI = original.getDOI();
        this.edition = original.getEdition();
        this.event = original.getEvent();
        this.eventPlace = original.getEventPlace();
        this.firstReferenceNoteNumber = original.getFirstReferenceNoteNumber();
        this.genre = original.getGenre();
        this.ISBN = original.getISBN();
        this.ISSN = original.getISSN();
        this.issue = original.getIssue();
        this.jurisdiction = original.getJurisdiction();
        this.keyword = original.getKeyword();
        this.locator = original.getLocator();
        this.medium = original.getMedium();
        this.note = original.getNote();
        this.number = original.getNumber();
        this.numberOfPages = original.getNumberOfPages();
        this.numberOfVolumes = original.getNumberOfVolumes();
        this.originalPublisher = original.getOriginalPublisher();
        this.originalPublisherPlace = original.getOriginalPublisherPlace();
        this.originalTitle = original.getOriginalTitle();
        this.page = original.getPage();
        this.pageFirst = original.getPageFirst();
        this.PMCID = original.getPMCID();
        this.PMID = original.getPMID();
        this.publisher = original.getPublisher();
        this.publisherPlace = original.getPublisherPlace();
        this.references = original.getReferences();
        this.reviewedTitle = original.getReviewedTitle();
        this.scale = original.getScale();
        this.section = original.getSection();
        this.source = original.getSource();
        this.status = original.getStatus();
        this.title = original.getTitle();
        this.titleShort = original.getTitleShort();
        this.URL = original.getURL();
        this.version = original.getVersion();
        this.volume = original.getVolume();
        this.yearSuffix = original.getYearSuffix();
    }

    public CSLItemData build() {
        return new CSLItemData(this.id, this.type, this.categories, this.language, this.journalAbbreviation, this.shortTitle, this.author, this.collectionEditor, this.composer, this.containerAuthor, this.director, this.editor, this.editorialDirector, this.interviewer, this.illustrator, this.originalAuthor, this.recipient, this.reviewedAuthor, this.translator, this.accessed, this.container, this.eventDate, this.issued, this.originalDate, this.submitted, this.abstrct, this.annote, this.archive, this.archiveLocation, this.archivePlace, this.authority, this.callNumber, this.chapterNumber, this.citationNumber, this.citationLabel, this.collectionNumber, this.collectionTitle, this.containerTitle, this.containerTitleShort, this.dimensions, this.DOI, this.edition, this.event, this.eventPlace, this.firstReferenceNoteNumber, this.genre, this.ISBN, this.ISSN, this.issue, this.jurisdiction, this.keyword, this.locator, this.medium, this.note, this.number, this.numberOfPages, this.numberOfVolumes, this.originalPublisher, this.originalPublisherPlace, this.originalTitle, this.page, this.pageFirst, this.PMCID, this.PMID, this.publisher, this.publisherPlace, this.references, this.reviewedTitle, this.scale, this.section, this.source, this.status, this.title, this.titleShort, this.URL, this.version, this.volume, this.yearSuffix);
    }

    public CSLItemDataBuilder edition(int edition) {
        this.edition(String.valueOf(edition));
        return this;
    }

    public CSLItemDataBuilder issue(int issue) {
        this.issue(String.valueOf(issue));
        return this;
    }

    public CSLItemDataBuilder number(int number) {
        this.number(String.valueOf(number));
        return this;
    }

    public CSLItemDataBuilder numberOfVolumes(int numberOfVolumes) {
        this.numberOfVolumes(String.valueOf(numberOfVolumes));
        return this;
    }

    public CSLItemDataBuilder volume(int volume) {
        this.volume(String.valueOf(volume));
        return this;
    }

    public CSLItemDataBuilder page(int page) {
        this.page(String.valueOf(page));
        return this;
    }

    public CSLItemDataBuilder pageFirst(int pageFirst) {
        this.pageFirst(String.valueOf(pageFirst));
        return this;
    }

    public CSLItemDataBuilder author(String given, String family) {
        this.author(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder author(String given, String family, boolean parseNames) {
        this.author(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder collectionEditor(String given, String family) {
        this.collectionEditor(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder collectionEditor(String given, String family, boolean parseNames) {
        this.collectionEditor(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder composer(String given, String family) {
        this.composer(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder composer(String given, String family, boolean parseNames) {
        this.composer(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder containerAuthor(String given, String family) {
        this.containerAuthor(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder containerAuthor(String given, String family, boolean parseNames) {
        this.containerAuthor(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder director(String given, String family) {
        this.director(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder director(String given, String family, boolean parseNames) {
        this.director(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder editor(String given, String family) {
        this.editor(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder editor(String given, String family, boolean parseNames) {
        this.editor(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder editorialDirector(String given, String family) {
        this.editorialDirector(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder editorialDirector(String given, String family, boolean parseNames) {
        this.editorialDirector(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder interviewer(String given, String family) {
        this.interviewer(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder interviewer(String given, String family, boolean parseNames) {
        this.interviewer(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder illustrator(String given, String family) {
        this.illustrator(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder illustrator(String given, String family, boolean parseNames) {
        this.illustrator(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder originalAuthor(String given, String family) {
        this.originalAuthor(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder originalAuthor(String given, String family, boolean parseNames) {
        this.originalAuthor(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder recipient(String given, String family) {
        this.recipient(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder recipient(String given, String family, boolean parseNames) {
        this.recipient(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder reviewedAuthor(String given, String family) {
        this.reviewedAuthor(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder reviewedAuthor(String given, String family, boolean parseNames) {
        this.reviewedAuthor(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder translator(String given, String family) {
        this.translator(new CSLNameBuilder().given(given).family(family).build());
        return this;
    }

    public CSLItemDataBuilder translator(String given, String family, boolean parseNames) {
        this.translator(new CSLNameBuilder().given(given).family(family).parseNames(parseNames).build());
        return this;
    }

    public CSLItemDataBuilder issued(int year) {
        this.issued(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder issued(int year, int month) {
        this.issued(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder issued(int year, int month, int day) {
        this.issued(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }

    public CSLItemDataBuilder accessed(int year) {
        this.accessed(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder accessed(int year, int month) {
        this.accessed(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder accessed(int year, int month, int day) {
        this.accessed(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }

    public CSLItemDataBuilder container(int year) {
        this.container(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder container(int year, int month) {
        this.container(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder container(int year, int month, int day) {
        this.container(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }

    public CSLItemDataBuilder eventDate(int year) {
        this.eventDate(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder eventDate(int year, int month) {
        this.eventDate(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder eventDate(int year, int month, int day) {
        this.eventDate(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }

    public CSLItemDataBuilder originalDate(int year) {
        this.originalDate(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder originalDate(int year, int month) {
        this.originalDate(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder originalDate(int year, int month, int day) {
        this.originalDate(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }

    public CSLItemDataBuilder submitted(int year) {
        this.submitted(new CSLDateBuilder().dateParts(year).build());
        return this;
    }

    public CSLItemDataBuilder submitted(int year, int month) {
        this.submitted(new CSLDateBuilder().dateParts(year, month).build());
        return this;
    }

    public CSLItemDataBuilder submitted(int year, int month, int day) {
        this.submitted(new CSLDateBuilder().dateParts(year, month, day).build());
        return this;
    }
}

