/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class StreamingByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator allocator;
    private final ByteOrder endianness;
    private ByteBuf buffer;
    private Channel streamChannel;
    private ChannelFuture lastStreamChannelWrite;
    private int totalWritten;

    public StreamingByteBuf(Channel streamChannel, int estimatedLength) {
        this(streamChannel, ByteOrder.BIG_ENDIAN, estimatedLength);
    }

    public StreamingByteBuf(Channel streamChannel, ByteOrder endianness, int estimatedLength) {
        this(streamChannel, endianness, estimatedLength, streamChannel.alloc());
    }

    public StreamingByteBuf(Channel streamChannel, ByteOrder endianness, int estimatedLength, ByteBufAllocator allocator) {
        super(Integer.MAX_VALUE);
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (allocator == null) {
            throw new NullPointerException("allocator");
        }
        this.allocator = allocator;
        this.endianness = endianness;
        this.streamChannel = streamChannel;
        this.buffer = allocator.buffer(estimatedLength).order(endianness);
    }

    public void flush() {
        this.ensureWritable(this.buffer.capacity());
    }

    @Override
    public ByteBuf resetReaderIndex() {
        throw new InvalidMarkException();
    }

    @Override
    public ByteBuf resetWriterIndex() {
        throw new InvalidMarkException();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    public int getTotalLength() {
        return this.totalWritten + this.readableBytes();
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        if (minWritableBytes > this.buffer.capacity()) {
            throw new IllegalArgumentException("illegal write size");
        }
        if (minWritableBytes <= this.writableBytes()) {
            return this;
        }
        if (this.lastStreamChannelWrite != null) {
            this.lastStreamChannelWrite.syncUninterruptibly();
        }
        this.totalWritten += this.readableBytes();
        ByteBuf replacement = this.alloc().buffer(this.buffer.capacity()).order(this.order());
        this.buffer.setIndex(this.readerIndex(), this.writerIndex());
        this.lastStreamChannelWrite = this.streamChannel.writeAndFlush(this.buffer);
        this.buffer = replacement;
        this.clear();
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return this.endianness;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index, out, length);
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index, out, length);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public ByteBuf writeByte(int value) {
        this.ensureWritable(1);
        super.writeByte(value);
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.ensureWritable(2);
        super.writeShort(value);
        return this;
    }

    @Override
    public ByteBuf writeMedium(int value) {
        this.ensureWritable(3);
        super.writeMedium(value);
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.ensureWritable(4);
        super.writeInt(value);
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.ensureWritable(8);
        super.writeLong(value);
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritable(length);
        super.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.ensureWritable(length);
        super.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        this.ensureWritable(src.remaining());
        super.writeBytes(src);
        return this;
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.ensureWritable(length);
        return super.writeBytes(in, length);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.ensureWritable(length);
        return super.writeBytes(in, length);
    }

    @Override
    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        super.writeZero(length);
        return this;
    }

    @Override
    public ByteBuf duplicate() {
        return new DuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return null;
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return null;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return null;
    }

    @Override
    protected byte _getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    protected short _getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    protected int _getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    protected long _getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    protected void _setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.buffer.setShort(index, value);
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    @Override
    protected void _setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nioBufferCount() {
        return 0;
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deallocate() {
        this.buffer.release();
    }
}

