/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.datetime.instants.PreciseInstant;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimesWithTZ
extends SettingSelectProcProvider {
    public TimesWithTZ() {
        super("field.datetime.format", Integer.class, new TxtEncoder(), new TxtDecoder(), new BinIntegerEncoder(), new BinIntegerDecoder(), null, null, new TxtEncoder(), new TxtDecoder(), "timetz_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        protected void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            String strVal = context.getTimeFormatter().getPrinter().format((Instant)val);
            buffer.append(strVal);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Time;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        protected Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            HashMap<String, Object> pieces = new HashMap<String, Object>();
            context.getTimeFormatter().getParser().parse(buffer.toString(), 0, pieces);
            return Instants.timeFromPieces(pieces, context.getTimeZone());
        }
    }

    static class BinIntegerEncoder
    extends BinaryEncoder {
        BinIntegerEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.TimeTZ;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                Instant inst = (Instant)val;
                long micros = inst.getMicrosLocal() % TimeUnit.DAYS.toMicros(1L);
                int tzOffsetSecs = (int)(-inst.getZoneOffsetSecs());
                buffer.writeInt(12);
                buffer.writeLong(micros);
                buffer.writeInt(tzOffsetSecs);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            return val == null ? 4 : 16;
        }
    }

    static class BinIntegerDecoder
    extends BinaryDecoder {
        BinIntegerDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.TimeTZ;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        public Instant decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 12) {
                throw new IOException("invalid length");
            }
            long micros = buffer.readLong();
            int tzOffsetSecs = buffer.readInt();
            int tzOffsetMillis = (int)TimeUnit.SECONDS.toMillis(-tzOffsetSecs);
            TimeZone zone = TimeZones.getOffsetZone(tzOffsetMillis);
            return new PreciseInstant(Instant.Type.Time, micros, zone);
        }
    }
}

