/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Names
extends SimpleProcProvider {
    public Names() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "name");
    }

    public static class TxtEncoder
    extends TextEncoder {
        @Override
        public Class<?> getInputType() {
            return String.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            buffer.append((String)val);
        }
    }

    public static class TxtDecoder
    extends TextDecoder {
        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public Class<?> getOutputType() {
            return String.class;
        }

        @Override
        public String decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return buffer.toString();
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return String.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.String;
        }

        byte[] toBytes(Object val, Context context) {
            return val.toString().getBytes(context.getCharset());
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                byte[] bytes = this.toBytes(val, context);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            return val == null ? 4 : 4 + this.toBytes(val, context).length;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public Class<?> getOutputType() {
            return String.class;
        }

        @Override
        public String decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            return new String(bytes, context.getCharset());
        }
    }
}

