/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class LSegs
extends SimpleProcProvider {
    public LSegs() {
        this("lseg_", new LSegFormatter(), PrimitiveType.LineSegment);
    }

    public LSegs(String pgtype, Formatter formatter, PrimitiveType pt) {
        super((Type.Codec.Encoder)new TxtEncoder(formatter, pt), (Type.Codec.Decoder)new TxtDecoder(formatter, pt), (Type.Codec.Encoder)new BinEncoder(pt), (Type.Codec.Decoder)new BinDecoder(pt), pgtype);
    }

    static class TxtEncoder
    extends TextEncoder {
        private Formatter formatter;
        private PrimitiveType pt;

        TxtEncoder(Formatter f, PrimitiveType pt) {
            this.formatter = f;
            this.pt = pt;
        }

        @Override
        public Class<?> getInputType() {
            return double[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return this.pt;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                return;
            }
            double[] lseg = (double[])val;
            if (lseg.length != 4) {
                throw new IOException("invalid length");
            }
            buffer.append(this.formatter.getLeftDelim()).append('(').append(Double.toString(lseg[0])).append(',').append(Double.toString(lseg[1])).append("),(").append(Double.toString(lseg[2])).append(',').append(Double.toString(lseg[3])).append(')').append(this.formatter.getRightDelim());
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        private Formatter formatter;
        private PrimitiveType pt;

        TxtDecoder(Formatter f, PrimitiveType pt) {
            this.formatter = f;
            this.pt = pt;
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return this.pt;
        }

        @Override
        public Class<?> getOutputType() {
            return double[].class;
        }

        public double[] decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return this.formatter.parse(buffer);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        private PrimitiveType pt;

        public BinEncoder(PrimitiveType pt) {
            this.pt = pt;
        }

        @Override
        public Class<?> getInputType() {
            return double[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return this.pt;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                double[] box = (double[])val;
                if (box.length != 4) {
                    throw new IOException("invalid length");
                }
                buffer.writeInt(32);
                buffer.writeDouble(box[0]);
                buffer.writeDouble(box[1]);
                buffer.writeDouble(box[2]);
                buffer.writeDouble(box[3]);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        private PrimitiveType pt;

        public BinDecoder(PrimitiveType pt) {
            this.pt = pt;
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return this.pt;
        }

        @Override
        public Class<?> getOutputType() {
            return double[].class;
        }

        public double[] decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 32) {
                throw new IOException("invalid length " + length);
            }
            return new double[]{buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble()};
        }
    }

    static class LSegFormatter
    implements Formatter {
        LSegFormatter() {
        }

        @Override
        public String getLeftDelim() {
            return "[";
        }

        @Override
        public String getRightDelim() {
            return "]";
        }

        @Override
        public double[] parse(CharSequence buffer) {
            return GeometryParsers.INSTANCE.parseLSeg(buffer);
        }
    }

    static interface Formatter {
        public String getLeftDelim();

        public String getRightDelim();

        public double[] parse(CharSequence var1);
    }
}

