/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.Strings;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HStores
extends SimpleProcProvider {
    public HStores() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "hstore_");
    }

    private static Map<String, String> newMap(int size) {
        return new HashMap<String, String>(Math.max(2, size));
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Map.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            Map map = (Map)val;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry e : map.entrySet()) {
                TxtEncoder.appendEscaped(buffer, e.getKey());
                buffer.append("=>");
                TxtEncoder.appendEscaped(buffer, e.getValue());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
        }

        private static void appendEscaped(StringBuilder sb, Object val) {
            if (val != null) {
                sb.append('\"');
                String s = val.toString();
                for (int pos = 0; pos < s.length(); ++pos) {
                    char ch = s.charAt(pos);
                    if (ch == '\"' || ch == '\\') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                }
                sb.append('\"');
            } else {
                sb.append("NULL");
            }
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return Map.class;
        }

        @Override
        public Map<String, String> decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            Map m = HStores.newMap(10);
            String s = buffer.toString();
            StringBuilder sb = new StringBuilder();
            for (int pos = 0; pos < buffer.length(); ++pos) {
                String val;
                sb.setLength(0);
                int start = s.indexOf(34, pos);
                int end = TxtDecoder.appendUntilQuote(sb, s, start);
                String key = sb.toString();
                pos = end + 3;
                if (s.charAt(pos) == 'N') {
                    val = null;
                    pos += 4;
                } else {
                    sb.setLength(0);
                    end = TxtDecoder.appendUntilQuote(sb, s, pos);
                    val = sb.toString();
                    pos = end;
                }
                m.put(key, val);
            }
            return m;
        }

        private static int appendUntilQuote(StringBuilder sb, String s, int pos) {
            char ch;
            ++pos;
            while (pos < s.length() && (ch = s.charAt(pos)) != '\"') {
                if (ch == '\\') {
                    ch = s.charAt(++pos);
                }
                sb.append(ch);
                ++pos;
            }
            return pos;
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Map.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int start = buffer.writerIndex();
                Map map = (Map)val;
                buffer.writeInt(map.size());
                for (Map.Entry e : map.entrySet()) {
                    Strings.BINARY_ENCODER.encode(type, buffer, e.getKey(), context);
                    Strings.BINARY_ENCODER.encode(type, buffer, e.getValue(), context);
                }
                buffer.setInt(start - 4, buffer.writerIndex() - start);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return Map.class;
        }

        @Override
        public Map<String, String> decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            int numElements = buffer.readInt();
            Map m = HStores.newMap(numElements);
            for (int i = 0; i < numElements; ++i) {
                String key = Strings.BINARY_DECODER.decode(type, null, null, buffer, context);
                String val = Strings.BINARY_DECODER.decode(type, null, null, buffer, context);
                m.put(key, val);
            }
            return m;
        }
    }
}

