/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.BitSet;

public class Bits
extends SimpleProcProvider {
    public Bits() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "bit_", "varbit_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BitSet.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Bits;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            BitSet bits = (BitSet)val;
            int sz = bits.length();
            for (int c = 0; c < sz; ++c) {
                buffer.append(bits.get(c) ? (char)'1' : '0');
            }
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Bits;
        }

        @Override
        public Class<?> getOutputType() {
            return BitSet.class;
        }

        @Override
        public BitSet decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            BitSet bits = new BitSet();
            int sz = buffer.length();
            block4: for (int c = 0; c < sz; ++c) {
                switch (buffer.charAt(c)) {
                    case '0': {
                        bits.clear(c);
                        continue block4;
                    }
                    case '1': {
                        bits.set(c);
                        continue block4;
                    }
                    default: {
                        throw new IOException("Invalid bits format");
                    }
                }
            }
            return bits;
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BitSet.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Bits;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                BitSet bs = (BitSet)val;
                int bitCount = bs.length();
                int byteCount = (bitCount + 7) / 8;
                byte[] bytes = new byte[byteCount];
                for (int c = 0; c < bitCount; ++c) {
                    int n = c / 8;
                    bytes[n] = (byte)(bytes[n] | 128 >> c % 8 & (bs.get(c) ? 255 : 0));
                }
                buffer.writeInt(4 + byteCount);
                buffer.writeInt(bitCount);
                buffer.writeBytes(bytes);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            if (val == null) {
                return 4;
            }
            BitSet bs = (BitSet)val;
            int bitCount = bs.length();
            int byteCount = (bitCount + 7) / 8;
            return 8 + byteCount;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Bits;
        }

        @Override
        public Class<?> getOutputType() {
            return BitSet.class;
        }

        @Override
        public BitSet decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            Integer lenMod;
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            int bitCount = buffer.readInt();
            if (typeModifier != null && (lenMod = (Integer)type.getModifierParser().parse(typeModifier.intValue()).get("length")) > 0) {
                bitCount = lenMod;
            }
            int byteCount = (bitCount + 7) / 8;
            byte[] bytes = new byte[byteCount];
            buffer.readBytes(bytes);
            BitSet bs = new BitSet(bitCount);
            for (int c = 0; c < bitCount; ++c) {
                bs.set(c, (bytes[c / 8] & 128 >> c % 8) != 0);
            }
            return bs;
        }
    }
}

