/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.mapper.Mapper;
import com.impossibl.postgres.mapper.PropertySetter;
import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.SettingsContext;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Factory;
import com.impossibl.postgres.utils.StreamingByteBuf;
import com.impossibl.postgres.utils.guava.ByteStreams;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BindExecCommandImpl
extends CommandImpl
implements BindExecCommand {
    private static final int DEFAULT_MESSAGE_SIZE = 8192;
    private static final int STREAM_MESSAGE_SIZE = 32768;
    private String statementName;
    private String portalName;
    private List<Type> parameterTypes;
    private List<Object> parameterValues;
    private List<ResultField> resultFields;
    private Class<?> rowType;
    private List<PropertySetter> resultSetters;
    private int maxRows;
    private int maxFieldLength;
    private QueryCommand.Status status;
    private SettingsContext parsingContext;
    private QueryCommand.ResultBatch resultBatch;
    private List<ResultField.Format> resultFieldFormats;
    private long queryTimeout;

    public BindExecCommandImpl(String portalName, String statementName, List<Type> parameterTypes, List<Object> parameterValues, List<ResultField> resultFields, Class<?> rowType) {
        this.statementName = statementName;
        this.portalName = portalName;
        this.parameterTypes = parameterTypes;
        this.parameterValues = parameterValues;
        this.resultFields = resultFields;
        this.rowType = rowType;
        this.maxRows = 0;
        this.maxFieldLength = Integer.MAX_VALUE;
        if (resultFields != null) {
            this.resultSetters = Mapper.buildMapping(rowType, resultFields);
            this.resultFieldFormats = BindExecCommandImpl.getResultFieldFormats(resultFields);
        } else {
            this.resultSetters = Collections.emptyList();
            this.resultFieldFormats = Collections.emptyList();
        }
    }

    public void reset() {
        this.status = null;
        this.resultBatch = new QueryCommand.ResultBatch();
        this.resultBatch.fields = this.resultFields;
        this.resultBatch.results = this.resultFields != null && !this.resultFields.isEmpty() ? new ArrayList() : null;
    }

    @Override
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public String getPortalName() {
        return this.portalName;
    }

    @Override
    public QueryCommand.Status getStatus() {
        return this.status;
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public void setParameterTypes(List<Type> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public void setParameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    @Override
    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    @Override
    public List<QueryCommand.ResultBatch> getResultBatches() {
        return Arrays.asList(this.resultBatch);
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        this.parsingContext = new SettingsContext(protocol.getContext());
        this.parsingContext.setSetting("field.varying.length.max", this.maxFieldLength);
        BindExecCommandListener listener = new BindExecCommandListener(this.parsingContext);
        protocol.setListener(listener);
        ByteBuf msg = protocol.channel.alloc().buffer(8192);
        if (this.status != QueryCommand.Status.Suspended) {
            if (BindExecCommandImpl.shouldStreamBind(this.parsingContext, this.parameterValues)) {
                StreamingByteBuf bindMsg = new StreamingByteBuf(protocol.channel, 32768);
                protocol.writeBind((ByteBuf)bindMsg, this.portalName, this.statementName, this.parameterTypes, this.parameterValues, this.resultFieldFormats, true);
                bindMsg.flush();
            } else {
                protocol.writeBind(msg, this.portalName, this.statementName, this.parameterTypes, this.parameterValues, this.resultFieldFormats, true);
            }
        }
        this.reset();
        if (this.resultFields == null) {
            protocol.writeDescribe(msg, ServerObjectType.Portal, this.portalName);
        }
        protocol.writeExecute(msg, this.portalName, this.maxRows);
        if (this.maxRows > 0 && protocol.getTransactionStatus() == TransactionStatus.Idle) {
            protocol.writeFlush(msg);
        } else {
            protocol.writeSync(msg);
        }
        protocol.send(msg);
        this.enableCancelTimer(protocol, this.queryTimeout);
        this.waitFor(listener);
    }

    static boolean shouldStreamBind(Context context, List<Object> parameterValues) {
        int streamThreshold = context.getSetting("parameter.stream.threshold", 512000);
        int streamTotal = 0;
        for (Object parameterValue : parameterValues) {
            if (parameterValue instanceof ByteStreams.LimitedInputStream) {
                streamTotal = (int)((long)streamTotal + ((ByteStreams.LimitedInputStream)parameterValue).limit());
                continue;
            }
            if (!(parameterValue instanceof InputStream)) continue;
            return false;
        }
        return streamTotal > streamThreshold;
    }

    static List<ResultField.Format> getResultFieldFormats(List<ResultField> resultFields) {
        ArrayList<ResultField.Format> resultFieldFormats = new ArrayList<ResultField.Format>();
        for (ResultField resultField : resultFields) {
            resultField.format = resultField.typeRef.get().getResultFormat();
            resultFieldFormats.add(resultField.format);
        }
        return resultFieldFormats;
    }

    class BindExecCommandListener
    extends BaseProtocolListener {
        Context context;

        public BindExecCommandListener(Context context) {
            this.context = context;
        }

        @Override
        public boolean isComplete() {
            return BindExecCommandImpl.this.status != null || BindExecCommandImpl.this.error != null || BindExecCommandImpl.this.exception != null;
        }

        @Override
        public void bindComplete() {
        }

        @Override
        public void rowDescription(List<ResultField> newResultFields) {
            BindExecCommandImpl.this.resultFields = newResultFields;
            BindExecCommandImpl.this.resultFieldFormats = BindExecCommandImpl.getResultFieldFormats(newResultFields);
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.fields = newResultFields;
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.results = !BindExecCommandImpl.this.resultFields.isEmpty() ? new ArrayList() : null;
            BindExecCommandImpl.this.resultSetters = Mapper.buildMapping(BindExecCommandImpl.this.rowType, newResultFields);
        }

        @Override
        public void noData() {
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.fields = Collections.emptyList();
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.results = null;
            BindExecCommandImpl.this.status = QueryCommand.Status.Completed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rowData(ByteBuf buffer) throws IOException {
            try {
                int itemCount = buffer.readShort();
                Object rowInstance = Factory.createInstance(BindExecCommandImpl.this.rowType, itemCount);
                for (int c = 0; c < itemCount; ++c) {
                    ResultField field = ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.fields.get(c);
                    Type fieldType = field.typeRef.get();
                    Type.Codec.Decoder decoder = fieldType.getCodec((ResultField.Format)field.format).decoder;
                    Object fieldVal = decoder.decode(fieldType, field.typeLength, field.typeModifier, buffer, this.context);
                    ((PropertySetter)BindExecCommandImpl.this.resultSetters.get(c)).set(rowInstance, fieldVal);
                }
                List<?> res = ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.results;
                res.add(rowInstance);
            }
            finally {
                buffer.release();
            }
        }

        @Override
        public void emptyQuery() {
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.fields = Collections.emptyList();
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.results = null;
            BindExecCommandImpl.this.status = QueryCommand.Status.Completed;
        }

        @Override
        public synchronized void portalSuspended() {
            BindExecCommandImpl.this.status = QueryCommand.Status.Suspended;
            this.notifyAll();
        }

        @Override
        public synchronized void commandComplete(String command, Long rowsAffected, Long oid) {
            BindExecCommandImpl.this.status = QueryCommand.Status.Completed;
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.command = command;
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.rowsAffected = rowsAffected;
            ((BindExecCommandImpl)BindExecCommandImpl.this).resultBatch.insertedOid = oid;
            if (BindExecCommandImpl.this.maxRows > 0) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized void error(Notice error) {
            BindExecCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            BindExecCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            BindExecCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    }
}

