/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.types.Type;

public class ResultField {
    public String name;
    public int relationId;
    public short relationAttributeNumber;
    public TypeRef typeRef;
    public short typeLength;
    public int typeModifier;
    public Format format;

    public ResultField(String name, int relationId, short relationAttributeIndex, Type type, short typeLength, int typeModifier, Format format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeIndex;
        this.typeRef = TypeRef.from(type);
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public ResultField(String name, int relationId, short relationAttributeIndex, TypeRef typeRef, short typeLength, int typeModifier, Format format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeIndex;
        this.typeRef = typeRef;
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public ResultField() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.relationId != 0) {
            sb.append(String.format(" (%s:%d)", this.relationId, this.relationAttributeNumber));
        }
        sb.append(" : ");
        sb.append(this.typeRef != null ? this.typeRef.toString() : "<unknown>");
        return sb.toString();
    }

    public static enum Format {
        Text,
        Binary;

    }
}

