/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.CompositeType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

class PGResultSetMetaData
implements ResultSetMetaData {
    PGConnectionImpl connection;
    List<ResultField> resultFields;
    Map<String, Class<?>> typeMap;

    PGResultSetMetaData(PGConnectionImpl connection, List<ResultField> resultFields, Map<String, Class<?>> typeMap) {
        this.connection = connection;
        this.resultFields = resultFields;
        this.typeMap = typeMap;
    }

    ResultField get(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.resultFields.size()) {
            throw Exceptions.COLUMN_INDEX_OUT_OF_BOUNDS;
        }
        return this.resultFields.get(columnIndex - 1);
    }

    CompositeType getRelType(int columnIndex) throws SQLException {
        ResultField field = this.get(columnIndex);
        if (field.relationId == 0) {
            return null;
        }
        return this.connection.getRegistry().loadRelationType(field.relationId);
    }

    CompositeType.Attribute getRelAttr(int columnIndex) throws SQLException {
        ResultField field = this.get(columnIndex);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field.relationId);
        if (relType == null) {
            return null;
        }
        return relType.getAttribute(field.relationAttributeNumber);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultFields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        ResultField field = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field.relationId);
        return SQLTypeMetaData.isAutoIncrement(field.typeRef.get(), relType, field.relationAttributeNumber);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return SQLTypeMetaData.isCaseSensitive(this.get((int)column).typeRef.get());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return SQLTypeMetaData.isCurrency(this.get((int)column).typeRef.get());
    }

    @Override
    public int isNullable(int column) throws SQLException {
        ResultField field = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field.relationId);
        return SQLTypeMetaData.isNullable(field.typeRef.get(), relType, field.relationAttributeNumber);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return SQLTypeMetaData.isSigned(this.get((int)column).typeRef.get());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String val = this.get((int)column).name;
        if (val == null) {
            val = this.getColumnName(column);
        }
        return val;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.connection.getSetting("database").toString();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getNamespace();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String val;
        if (this.connection.isStrictMode() && (val = this.get((int)column).name) != null) {
            return val;
        }
        CompositeType.Attribute attr = this.getRelAttr(column);
        if (attr == null) {
            return this.get((int)column).name;
        }
        return attr.name;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ResultField field = this.get(column);
        return SQLTypeMetaData.getSQLType(field.typeRef.get());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ResultField field = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field.relationId);
        return SQLTypeMetaData.getTypeName(field.typeRef.get(), relType, field.relationAttributeNumber);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ResultField field = this.get(column);
        return SQLTypeUtils.mapGetType(field.typeRef.get(), this.typeMap, this.connection).getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ResultField field = this.get(column);
        return SQLTypeMetaData.getPrecision(field.typeRef.get(), field.typeLength, field.typeModifier);
    }

    @Override
    public int getScale(int column) throws SQLException {
        ResultField field = this.get(column);
        return SQLTypeMetaData.getScale(field.typeRef.get(), field.typeLength, field.typeModifier);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ResultField field = this.get(column);
        return SQLTypeMetaData.getDisplaySize(field.typeRef.get(), field.typeLength, field.typeModifier);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.get((int)column).relationAttributeNumber == 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }
}

