/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.CommandScroller;
import com.impossibl.postgres.jdbc.CursorScroller;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Housekeeper;
import com.impossibl.postgres.jdbc.ListScroller;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGResultSetMetaData;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.jdbc.Scroller;
import com.impossibl.postgres.jdbc.Unwrapping;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

class PGResultSet
implements ResultSet {
    PGStatement statement;
    Scroller scroller;
    int fetchDirection;
    Integer fetchSize;
    SQLWarning warningChain;
    Object[] updatedRowValues;
    Boolean nullFlag;
    Map<String, Class<?>> typeMap;
    final Housekeeper.Ref housekeeper;
    final Object cleanupKey;

    PGResultSet(PGStatement statement, QueryCommand command, List<ResultField> resultFields, List<?> results) throws SQLException {
        this(statement, command);
        this.scroller = new CommandScroller(this, command, resultFields, results);
        if (statement.fetchDirection != 1000 && this.scroller.getType() == 1003) {
            throw Exceptions.CURSOR_NOT_SCROLLABLE;
        }
    }

    PGResultSet(PGStatement statement, List<ResultField> resultFields, List<?> results) throws SQLException {
        this(statement, null);
        this.scroller = new ListScroller(resultFields, results);
        if (statement.fetchDirection != 1000 && this.scroller.getType() == 1003) {
            throw Exceptions.CURSOR_NOT_SCROLLABLE;
        }
    }

    PGResultSet(PGStatement statement, String cursorName, int type, int holdability, List<ResultField> resultFields) throws SQLException {
        this(statement, null);
        this.scroller = new CursorScroller(this, cursorName, type, holdability, resultFields);
        if (statement.fetchDirection != 1000 && this.scroller.getType() == 1003) {
            throw Exceptions.CURSOR_NOT_SCROLLABLE;
        }
    }

    private PGResultSet(PGStatement statement, QueryCommand command) throws SQLException {
        this.statement = statement;
        this.fetchDirection = statement.fetchDirection;
        this.fetchSize = statement.fetchSize;
        this.typeMap = statement.getConnection().getTypeMap();
        this.housekeeper = statement.housekeeper;
        this.cleanupKey = this.housekeeper != null ? this.housekeeper.add(this, new Cleanup(statement, command)) : null;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Exceptions.CLOSED_RESULT_SET;
        }
    }

    void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.scroller.getResultFields().size()) {
            throw Exceptions.COLUMN_INDEX_OUT_OF_BOUNDS;
        }
    }

    void checkRow() throws SQLException {
        if (!this.scroller.isValidRow()) {
            throw Exceptions.ROW_INDEX_OUT_OF_BOUNDS;
        }
    }

    void checkUpdatable() throws SQLException {
        if (this.scroller.getConcurrency() == 1007) {
            throw Exceptions.RS_NOT_UPDATABLE;
        }
    }

    void checkUpdate() throws SQLException {
        this.checkUpdatable();
    }

    Object get(int columnIndex) {
        Object val = this.scroller.getRowData()[columnIndex - 1];
        this.nullFlag = val == null;
        return val;
    }

    void set(int columnIdx, Object val) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIdx);
        if (this.updatedRowValues == null) {
            Object[] rowData = this.scroller.getRowData();
            if (rowData == null) {
                throw Exceptions.RS_NOT_UPDATABLE;
            }
            this.updatedRowValues = (Object[])rowData.clone();
        }
        Type colType = this.getType(columnIdx);
        Class<?> targetType = SQLTypeUtils.mapSetType(colType);
        this.updatedRowValues[columnIdx - 1] = val = SQLTypeUtils.coerce(val, colType, targetType, this.typeMap, this.statement.connection);
    }

    List<ResultField> getResultFields() {
        return this.scroller.getResultFields();
    }

    Type getType(int columnIndex) {
        return this.scroller.getResultFields().get((int)(columnIndex - 1)).typeRef.get();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.scroller.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.scroller.getConcurrency();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.scroller.getHoldability();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && this.scroller.getType() == 1003) {
            throw Exceptions.CURSOR_NOT_SCROLLABLE;
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize != null ? this.fetchSize : 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.fetchSize = rows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.scroller.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.scroller.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.scroller.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.scroller.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.scroller.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.scroller.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        return this.scroller.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        return this.scroller.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.scroller.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        return this.scroller.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        return this.scroller.relative(rows);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        return this.scroller.next();
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        return this.scroller.previous();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkClosed();
        this.scroller.insert(this.updatedRowValues);
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkClosed();
        this.scroller.update(this.updatedRowValues);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkClosed();
        this.scroller.delete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkClosed();
        this.scroller.refresh();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.updatedRowValues = null;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.updatedRowValues = new Object[this.scroller.getResultFields().size()];
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
        this.updatedRowValues = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement == null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.statement.handleResultSetClosure(this);
        this.internalClose();
    }

    void internalClose() throws SQLException {
        if (this.scroller != null) {
            this.scroller.close();
        }
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
        }
        this.statement = null;
        this.scroller = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return this.scroller.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new PGResultSetMetaData(this.statement.connection, this.scroller.getResultFields(), this.typeMap);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.nullFlag == null) {
            throw new SQLException("no column fetched");
        }
        return this.nullFlag;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToString(this.get(columnIndex), this.getType(columnIndex), this.statement.connection);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToBoolean(this.get(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToByte(this.get(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToShort(this.get(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToInt(this.get(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToLong(this.get(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToFloat(this.get(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToDouble(this.get(columnIndex));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal val = SQLTypeUtils.coerceToBigDecimal(columnIndex);
        if (val == null) {
            return null;
        }
        return val.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToBigDecimal(this.get(columnIndex));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        InputStream data = SQLTypeUtils.coerceToByteStream(this.get(columnIndex), this.getType(columnIndex), this.statement.connection);
        if (data == null) {
            return null;
        }
        try {
            return ByteStreams.toByteArray(data);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToDate(this.get(columnIndex), zone, this.statement.connection);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToTime(this.get(columnIndex), zone, this.statement.connection);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToTimestamp(this.get(columnIndex), zone, this.statement.connection);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        Type type = this.getType(columnIndex);
        if (!(type instanceof ArrayType)) {
            throw SQLTypeUtils.createCoercionException(value.getClass(), Array.class);
        }
        return new PGArray(this.statement.connection, (ArrayType)type, (Object[])value);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToURL(this.get(columnIndex));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToByteStream(this.get(columnIndex), this.getType(columnIndex), this.statement.connection);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToBlob(this.get(columnIndex), this.statement.connection);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToClob(this.get(columnIndex), this.statement.connection);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToXML(this.get(columnIndex), this.statement.connection);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, this.typeMap);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        Type type = this.getType(columnIndex);
        Class<Object> targetType = SQLTypeUtils.mapGetType(type, map, this.statement.connection);
        if (this.statement.connection.isStrictMode() && InputStream.class.equals(targetType)) {
            targetType = byte[].class;
        }
        return SQLTypeUtils.coerce(this.get(columnIndex), type, targetType, map, this.statement.connection);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return type.cast(SQLTypeUtils.coerce(this.get(columnIndex), this.getType(columnIndex), type, this.typeMap, this.statement.connection));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkRow();
        this.checkColumnIndex(columnIndex);
        return SQLTypeUtils.coerceToRowId(this.get(columnIndex), this.getType(columnIndex));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        List<ResultField> resultFields = this.scroller.getResultFields();
        for (int c = 0; c < resultFields.size(); ++c) {
            if (!resultFields.get((int)c).name.equalsIgnoreCase(columnLabel)) continue;
            return c + 1;
        }
        throw Exceptions.INVALID_COLUMN_NAME;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, Float.valueOf(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        if (x != null) {
            x = ByteStreams.limit(x, length);
        } else if (length != 0) {
            throw new SQLException("Invalid length");
        }
        this.set(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        if (x != null) {
            x = ByteStreams.limit(x, length);
        } else if (length != 0L) {
            throw new SQLException("Invalid length");
        }
        this.set(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateAsciiStream(columnIndex, x, -1L);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        try {
            this.set(columnIndex, x != null ? new String(ByteStreams.toByteArray(x), StandardCharsets.US_ASCII) : null);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateCharacterStream(columnIndex, x, -1L);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateCharacterStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        try {
            this.set(columnIndex, x != null ? CharStreams.toString(x) : null);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, Unwrapping.unwrapBlob(this.statement.connection, x));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        Blob blob = this.statement.connection.createBlob();
        try {
            ByteStreams.copy(x, blob.setBinaryStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(columnIndex, blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateBlob(columnIndex, ByteStreams.limit(x, length));
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, Unwrapping.unwrapClob(this.statement.connection, x));
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        Clob clob = this.statement.connection.createClob();
        try {
            CharStreams.copy(x, clob.setCharacterStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(columnIndex, clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateClob(columnIndex, CharStreams.limit(x, length));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.updateObject(columnIndex, x, 0);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, Unwrapping.unwrapObject(this.statement.connection, x));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        this.set(columnIndex, Unwrapping.unwrapRowId(this.statement.connection, x));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.checkUpdate();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain = null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    static class Cleanup
    implements Housekeeper.CleanupRunnable {
        PGStatement statement;
        QueryCommand command;
        StackTraceElement[] allocationStackTrace;

        public Cleanup(PGStatement statement, QueryCommand command) {
            this.statement = statement;
            this.command = command;
            this.allocationStackTrace = new Exception().getStackTrace();
        }

        @Override
        public String getKind() {
            return "result-set";
        }

        @Override
        public StackTraceElement[] getAllocationStackTrace() {
            return this.allocationStackTrace;
        }

        @Override
        public void run() {
            try {
                this.statement.dispose(this.command);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.statement.handleResultSetClosure(null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
    }
}

