/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGPooledConnectionDelegator;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class PGPooledConnection
implements PooledConnection {
    private List<ConnectionEventListener> connectionListeners = new ArrayList<ConnectionEventListener>();
    private List<StatementEventListener> statementListeners = new ArrayList<StatementEventListener>();
    private PGConnectionImpl con;
    private PGPooledConnectionDelegator last;
    private final boolean autoCommit;
    private final boolean isXA;
    private static String[] fatalClasses = new String[]{"08", "53", "57P01", "57P02", "57P03", "58", "60", "99", "F0", "XX"};

    public PGPooledConnection(PGConnectionImpl con, boolean autoCommit, boolean isXA) {
        this.con = con;
        this.last = null;
        this.autoCommit = autoCommit;
        this.isXA = isXA;
    }

    void setLast(PGPooledConnectionDelegator v) {
        this.last = v;
    }

    boolean isXA() {
        return this.isXA;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionListeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionListeners.remove(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        this.statementListeners.add(statementEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementListeners.remove(statementEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.reset();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
        }
        finally {
            this.con = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        PGPooledConnectionDelegator handler;
        if (this.con == null) {
            PGSQLSimpleException sqlException = new PGSQLSimpleException("This PooledConnection has already been closed.", "08003");
            this.fireConnectionFatalError(sqlException);
            throw sqlException;
        }
        try {
            if (this.last != null) {
                this.last.reset();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.con.clearWarnings();
            }
            if (!this.isXA) {
                this.con.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sqlException) {
            this.fireConnectionFatalError(sqlException);
            throw (SQLException)sqlException.fillInStackTrace();
        }
        this.last = handler = new PGPooledConnectionDelegator(this, this.con);
        return handler;
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.connectionListeners.toArray(new ConnectionEventListener[this.connectionListeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = this.createConnectionEvent(null);
            }
            listener.connectionClosed(evt);
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.connectionListeners.toArray(new ConnectionEventListener[this.connectionListeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = this.createConnectionEvent(e);
            }
            listener.connectionErrorOccurred(evt);
        }
    }

    protected ConnectionEvent createConnectionEvent(SQLException sqle) {
        return new ConnectionEvent(this, sqle);
    }

    private static boolean isFatalState(String state) {
        if (state == null) {
            return true;
        }
        if (state.length() < 2) {
            return true;
        }
        for (int i = 0; i < fatalClasses.length; ++i) {
            if (!state.startsWith(fatalClasses[i])) continue;
            return true;
        }
        return false;
    }

    public void fireConnectionError(SQLException e) {
        if (!PGPooledConnection.isFatalState(e.getSQLState())) {
            return;
        }
        this.fireConnectionFatalError(e);
    }

    protected StatementEvent createStatementEvent(PreparedStatement ps, SQLException sqle) {
        if (sqle == null) {
            return new StatementEvent(this, ps);
        }
        return new StatementEvent(this, ps, sqle);
    }

    void fireStatementClosed(PreparedStatement ps) {
        StatementEvent evt = null;
        StatementEventListener[] local = this.statementListeners.toArray(new StatementEventListener[this.statementListeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            StatementEventListener listener = local[i];
            if (evt == null) {
                evt = this.createStatementEvent(ps, null);
            }
            listener.statementClosed(evt);
        }
    }

    void fireStatementError(PreparedStatement ps, SQLException se) {
        StatementEvent evt = null;
        StatementEventListener[] local = this.statementListeners.toArray(new StatementEventListener[this.statementListeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            StatementEventListener listener = local[i];
            if (evt == null) {
                evt = this.createStatementEvent(ps, se);
            }
            listener.statementErrorOccurred(evt);
        }
    }
}

