/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.LargeObject64;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.utils.guava.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class LargeObject {
    protected static final int INV_READ = 262144;
    protected static final int INV_WRITE = 131072;
    protected static final int SEEK_SET = 0;
    protected static final int SEEK_CUR = 1;
    protected static final int SEEK_END = 2;
    int oid;
    int fd;
    PGConnectionImpl connection;

    static LargeObject open(PGConnectionImpl connection, int oid) throws SQLException {
        int fd = LargeObject.open(connection, oid, 393216);
        if (fd == -1) {
            throw new SQLException("Unable to open large object");
        }
        if (connection.isServerMinimumVersion(9, 3)) {
            return new LargeObject64(connection, oid, fd);
        }
        return new LargeObject(connection, oid, fd);
    }

    LargeObject(PGConnectionImpl connection, int oid, int fd) throws SQLException {
        this.oid = oid;
        this.fd = fd;
        this.connection = connection;
        LargeObject.ensurePrepared(connection, "lo.close", "select lo_close($1)", "int4");
        LargeObject.ensurePrepared(connection, "lo.lseek", "select lo_lseek($1,$2,$3)", "int4", "int4", "int4");
        LargeObject.ensurePrepared(connection, "lo.tell", "select lo_tell($1)", "int4");
        LargeObject.ensurePrepared(connection, "lo.read", "select loread($1,$2)", "int4", "int4");
        LargeObject.ensurePrepared(connection, "lo.write", "select lowrite($1,$2)", "int4", "bytea");
        LargeObject.ensurePrepared(connection, "lo.truncate", "select lo_truncate($1,$2)", "int4", "int4");
    }

    LargeObject dup() throws SQLException {
        return LargeObject.open(this.connection, this.oid);
    }

    static void ensurePrepared(PGConnectionImpl conn, String name, String sql, String ... typeNames) throws SQLException {
        if (!conn.isUtilQueryPrepared(name)) {
            try {
                conn.prepareUtilQuery(name, sql, typeNames);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    static int creat(PGConnectionImpl conn, int mode) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.creat", "select lo_creat($1)", "int4");
        return conn.executeForFirstResultValue("@lo.creat", true, Integer.class, mode);
    }

    static int open(PGConnectionImpl conn, int oid, int access) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.open", "select lo_open($1,$2)", "oid", "int4");
        return conn.executeForFirstResultValue("@lo.open", true, Integer.class, oid, access);
    }

    static int unlink(PGConnectionImpl conn, int oid) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.unlink", "select lo_unlink($1)", "oid");
        return conn.executeForFirstResultValue("@lo.unlink", true, Integer.class, oid);
    }

    int close() throws SQLException {
        return this.connection.executeForFirstResultValue("@lo.close", true, Integer.class, this.fd);
    }

    long lseek(long offset, int whence) throws SQLException {
        return this.connection.executeForFirstResultValue("@lo.lseek", true, Integer.class, this.fd, (int)offset, whence).intValue();
    }

    long tell() throws SQLException {
        return this.connection.executeForFirstResultValue("@lo.tell", true, Integer.class, this.fd).intValue();
    }

    byte[] read(long len) throws SQLException {
        InputStream data = this.connection.executeForFirstResultValue("@lo.read", true, InputStream.class, this.fd, (int)len);
        try {
            return ByteStreams.toByteArray(data);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    int write(byte[] data, int off, int len) throws SQLException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream(data, off, len);
        return this.connection.executeForFirstResultValue("@lo.write", true, Integer.class, this.fd, dataIn);
    }

    int truncate(long len) throws SQLException {
        return this.connection.executeForFirstResultValue("@lo.truncate", true, Integer.class, this.fd, (int)len);
    }
}

