/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.LargeObject;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class ClobReader
extends Reader {
    private static final int MAX_BUF_SIZE = 8192;
    LargeObject lo;
    byte[] buf = new byte[0];
    int pos = 0;

    public ClobReader(LargeObject lo) {
        this.lo = lo;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.buf.length) {
            this.readNextRegion();
        }
        return this.pos < this.buf.length ? (this.buf[this.pos++] & 0xFF) << 24 | (this.buf[this.pos++] & 0xFF) << 16 | (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0 : -1;
    }

    @Override
    public int read(char[] chars, int off, int len) throws IOException {
        int ch;
        int left;
        if (chars == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > chars.length - off) {
            throw new IndexOutOfBoundsException();
        }
        for (left = len; left > 0 && (ch = this.read()) != -1; --left) {
            chars[off++] = (char)ch;
        }
        return len != left ? len - left : -1;
    }

    public void readNextRegion() throws IOException {
        try {
            this.buf = this.lo.read(8192L);
            if (this.buf.length % 4 != 0) {
                throw new IOException("invalid clob buffer read");
            }
            this.pos = 0;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

