/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.LargeObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BlobInputStream
extends InputStream {
    private static final int MAX_BUF_SIZE = 8192;
    LargeObject lo;
    byte[] buf = new byte[0];
    int pos = 0;

    public BlobInputStream(LargeObject lo) {
        this.lo = lo;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.buf.length) {
            this.readNextRegion();
        }
        return this.pos < this.buf.length ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int left;
        int amt;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        for (left = len; left > 0; left -= amt) {
            int avail;
            if (this.pos >= this.buf.length) {
                this.readNextRegion();
                if (len == left && this.buf.length == 0) {
                    return -1;
                }
            }
            if ((amt = Math.min(avail = this.buf.length - this.pos, left)) <= 0) break;
            System.arraycopy(this.buf, this.pos, b, off + (len - left), amt);
            this.pos += amt;
        }
        return len - left;
    }

    public void readNextRegion() throws IOException {
        try {
            this.buf = this.lo.read(8192L);
            this.pos = 0;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

