/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ConnectionUtil;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.system.Context;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class AbstractDataSource
implements CommonDataSource {
    private int loginTimeout = 0;
    private String host = "localhost";
    private int port = 5432;
    private String database = null;
    private String user = null;
    private String password = null;
    private boolean housekeeper = Boolean.parseBoolean("true");
    private int parsedSqlCacheSize = 250;
    private int preparedStatementCacheSize = 50;
    private String applicationName = null;
    private String clientEncoding = null;
    private int networkTimeout = 0;
    private boolean strictMode = false;

    protected AbstractDataSource() {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(Context.class.getPackage().getName());
    }

    protected abstract Reference createReference();

    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        if (this.host != null) {
            ref.add(new StringRefAddr("host", this.host));
        }
        if (this.port != 5432) {
            ref.add(new StringRefAddr("port", Integer.toString(this.port)));
        }
        if (this.database != null) {
            ref.add(new StringRefAddr("database", this.database));
        }
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        if (this.housekeeper != Boolean.parseBoolean("true")) {
            ref.add(new StringRefAddr("housekeeper", Boolean.toString(this.housekeeper)));
        }
        if (this.parsedSqlCacheSize != 250) {
            ref.add(new StringRefAddr("parsedSqlCacheSize", Integer.toString(this.parsedSqlCacheSize)));
        }
        if (this.preparedStatementCacheSize != 50) {
            ref.add(new StringRefAddr("preparedStatementCacheSize", Integer.toString(this.preparedStatementCacheSize)));
        }
        if (this.applicationName != null) {
            ref.add(new StringRefAddr("applicationName", this.applicationName));
        }
        if (this.clientEncoding != null) {
            ref.add(new StringRefAddr("clientEncoding", this.clientEncoding));
        }
        if (this.networkTimeout != 0) {
            ref.add(new StringRefAddr("networkTimeout", Integer.toString(this.networkTimeout)));
        }
        if (this.strictMode) {
            ref.add(new StringRefAddr("strictMode", Boolean.toString(this.strictMode)));
        }
        return ref;
    }

    public void init(Reference reference) {
        String value = null;
        value = this.getReferenceValue(reference, "host");
        if (value != null) {
            this.host = value;
        }
        if ((value = this.getReferenceValue(reference, "port")) != null) {
            this.port = Integer.valueOf(value);
        }
        if ((value = this.getReferenceValue(reference, "database")) != null) {
            this.database = value;
        }
        if ((value = this.getReferenceValue(reference, "user")) != null) {
            this.user = value;
        }
        if ((value = this.getReferenceValue(reference, "password")) != null) {
            this.password = value;
        }
        if ((value = this.getReferenceValue(reference, "housekeeper")) != null) {
            this.housekeeper = Boolean.valueOf(value);
        }
        if ((value = this.getReferenceValue(reference, "parsedSqlCacheSize")) != null) {
            this.parsedSqlCacheSize = Integer.valueOf(value);
        }
        if ((value = this.getReferenceValue(reference, "preparedStatementCacheSize")) != null) {
            this.preparedStatementCacheSize = Integer.valueOf(value);
        }
        if ((value = this.getReferenceValue(reference, "applicationName")) != null) {
            this.applicationName = value;
        }
        if ((value = this.getReferenceValue(reference, "clientEncoding")) != null) {
            this.clientEncoding = value;
        }
        if ((value = this.getReferenceValue(reference, "networkTimeout")) != null) {
            this.networkTimeout = Integer.valueOf(value);
        }
        if ((value = this.getReferenceValue(reference, "strictMode")) != null) {
            this.strictMode = Boolean.valueOf(value);
        }
    }

    private String getReferenceValue(Reference reference, String key) {
        RefAddr refAddr = reference.get(key);
        if (refAddr == null) {
            return null;
        }
        return (String)refAddr.getContent();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String v) {
        this.host = v;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int v) {
        this.port = v;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String v) {
        this.database = v;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String v) {
        this.user = v;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String v) {
        this.password = v;
    }

    public boolean getHousekeeper() {
        return this.housekeeper;
    }

    public void setHousekeeper(boolean v) {
        this.housekeeper = v;
    }

    public int getParsedSqlCacheSize() {
        return this.parsedSqlCacheSize;
    }

    public void setParsedSqlCacheSize(int cacheSize) {
        this.parsedSqlCacheSize = cacheSize;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String v) {
        this.applicationName = v;
    }

    public String getClientEncoding() {
        return this.clientEncoding;
    }

    public void setClientEncoding(String v) {
        this.clientEncoding = v;
    }

    public void setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public boolean getStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean v) {
        this.strictMode = v;
    }

    protected PGConnectionImpl createConnection(String u, String p) throws SQLException {
        String url = this.buildUrl();
        Properties props = new Properties();
        if (u != null) {
            props.put("user", u);
        } else if (this.user != null) {
            props.put("user", this.user);
        } else {
            props.put("user", "");
        }
        if (p != null) {
            props.put("password", p);
        } else if (this.password != null) {
            props.put("password", this.password);
        } else {
            props.put("password", "");
        }
        props.put("parsedSqlCacheSize", (Object)this.parsedSqlCacheSize);
        props.put("preparedStatementCacheSize", (Object)this.preparedStatementCacheSize);
        if (this.applicationName != null) {
            props.put("application_name", this.applicationName);
        }
        if (this.clientEncoding != null) {
            props.put("client_encoding", this.clientEncoding);
        }
        props.put("networkTimeout", Integer.toString(this.networkTimeout));
        props.put("strictMode", Boolean.toString(this.strictMode));
        return ConnectionUtil.createConnection(url, props, this.housekeeper);
    }

    private String buildUrl() throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (this.getDatabase() == null) {
            throw new SQLException("Database parameter mandatory for " + this.getHost() + ":" + this.getPort());
        }
        sb = sb.append("jdbc:pgsql://");
        sb = sb.append(this.getHost());
        sb = sb.append(":");
        sb = sb.append(this.getPort());
        sb = sb.append("/");
        sb = sb.append(this.getDatabase());
        return sb.toString();
    }
}

