/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.datetime.DateTimeFormat;
import com.impossibl.postgres.datetime.FormatUtils;
import com.impossibl.postgres.datetime.ISODateFormat;
import com.impossibl.postgres.datetime.ISOTimeFormat;
import com.impossibl.postgres.datetime.instants.FutureInfiniteInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.PastInfiniteInstant;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ISOTimestampFormat
implements DateTimeFormat {
    Parser parser = new Parser();
    Printer printer = new Printer();

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    static class Printer
    implements DateTimeFormat.Printer {
        Printer() {
        }

        @Override
        public String format(Instant instant) {
            String microsString;
            String yearString;
            TimeZone zone = instant.getZone();
            if (zone == null) {
                zone = TimeZone.getTimeZone("UTC");
            }
            Calendar cal = Calendar.getInstance(zone);
            cal.setTimeInMillis(TimeUnit.MICROSECONDS.toMillis(instant.getMicrosUTC()));
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int hour = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int micros = (int)(instant.getMicrosLocal() - TimeUnit.MILLISECONDS.toMicros(TimeUnit.MICROSECONDS.toMillis(instant.getMicrosLocal())));
            String zeros = "000000000";
            String yearZeros = "0000";
            if (year < 1000) {
                yearString = "" + year;
                yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
            } else {
                yearString = "" + year;
            }
            String monthString = month < 10 ? "0" + month : Integer.toString(month);
            String dayString = day < 10 ? "0" + day : Integer.toString(day);
            String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
            String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
            String secondString = second < 10 ? "0" + second : Integer.toString(second);
            if (micros == 0) {
                microsString = "0";
            } else {
                microsString = Integer.toString(micros);
                microsString = zeros.substring(0, 6 - microsString.length()) + microsString;
                char[] microsChar = new char[microsString.length()];
                microsString.getChars(0, microsString.length(), microsChar, 0);
                int truncIndex = 5;
                while (microsChar[truncIndex] == '0') {
                    --truncIndex;
                }
                microsString = new String(microsChar, 0, truncIndex + 1);
            }
            StringBuilder timestampBuf = new StringBuilder(20 + microsString.length());
            timestampBuf.append(yearString);
            timestampBuf.append("-");
            timestampBuf.append(monthString);
            timestampBuf.append("-");
            timestampBuf.append(dayString);
            timestampBuf.append(" ");
            timestampBuf.append(hourString);
            timestampBuf.append(":");
            timestampBuf.append(minuteString);
            timestampBuf.append(":");
            timestampBuf.append(secondString);
            timestampBuf.append(".");
            timestampBuf.append(microsString);
            if (instant.getZone() != null) {
                long zoneOff = TimeUnit.MILLISECONDS.toHours(instant.getZoneOffsetMillis());
                if (zoneOff > 0L) {
                    timestampBuf.append("+");
                }
                timestampBuf.append(zoneOff);
            }
            return timestampBuf.toString();
        }
    }

    static class Parser
    implements DateTimeFormat.Parser {
        ISODateFormat.Parser dateParser = new ISODateFormat.Parser();
        ISOTimeFormat.Parser timeParser = new ISOTimeFormat.Parser();

        Parser() {
        }

        @Override
        public int parse(String date, int offset, Map<String, Object> pieces) {
            try {
                if (date.equals("infinity")) {
                    pieces.put("INFINITY", FutureInfiniteInstant.INSTANCE);
                    offset = date.length();
                } else if (date.equals("-infinity")) {
                    pieces.put("INFINITY", PastInfiniteInstant.INSTANCE);
                    offset = date.length();
                } else {
                    offset = this.dateParser.parse(date, offset, pieces);
                    FormatUtils.checkOffset(date, offset, '\u0000');
                    if (offset < date.length()) {
                        char sep = date.charAt(offset);
                        if (sep != ' ' && sep != 'T') {
                            return ~offset;
                        }
                        if ((offset = this.timeParser.parse(date, offset + 1, pieces)) < 0) {
                            return offset;
                        }
                    }
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                // empty catch block
            }
            return offset;
        }
    }
}

