/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import java.util.Arrays;

public class Range<T> {
    Flags flags;
    Object[] values;

    public static <U> Range<U> create(U lower, boolean lowerInc, U upper, boolean upperInc) {
        int flags = 0;
        flags |= lower == null ? 32 : 0;
        flags |= lowerInc ? 2 : 0;
        flags |= lowerInc && lower == null ? 8 : 0;
        flags |= upper == null ? 64 : 0;
        flags |= upperInc ? 4 : 0;
        flags |= upperInc && lower == null ? 16 : 0;
        return new Range(new Flags((byte)(flags |= lower == null && upper == null && !lowerInc && !upperInc ? 1 : 0)), new Object[]{lower, upper});
    }

    public static Range<?> createEmpty() {
        return new Range(new Flags(97), new Object[0]);
    }

    public Range(Flags flags, Object[] values) {
        this.flags = flags;
        this.values = (Object[])values.clone();
    }

    public Flags getFlags() {
        return this.flags;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    public boolean hasLowerBound() {
        return this.flags.hasLowerBound();
    }

    public T getLowerBound() {
        return (T)this.values[0];
    }

    public void setLowerBound(T val) {
        this.values[0] = val;
        if (val == null) {
            this.flags.value = (byte)(this.flags.value | 0x20);
            if (!this.hasUpperBound()) {
                this.flags.value = (byte)(this.flags.value | 1);
            }
        }
    }

    public boolean isLowerBoundInfinity() {
        return this.flags.isLowerBoundInfinity();
    }

    public boolean isLowerBoundInclusive() {
        return this.flags.isLowerBoundInclusive();
    }

    public boolean hasUpperBound() {
        return this.flags.hasUpperBound();
    }

    public T getUpperBound() {
        if (this.flags.hasLowerBound()) {
            return (T)this.values[1];
        }
        return (T)this.values[0];
    }

    public void setUpperBound(T val) {
        this.values[1] = val;
        if (val == null) {
            this.flags.value = (byte)(this.flags.value | 0x40);
            if (!this.hasLowerBound()) {
                this.flags.value = (byte)(this.flags.value | 1);
            }
        }
    }

    public boolean isUpperBoundInfinity() {
        return this.flags.isUpperBoundInfinity();
    }

    public boolean isUpperBoundInclusive() {
        return this.flags.isUpperBoundInclusive();
    }

    public String toString() {
        return "Range (" + this.flags.value + ") " + Arrays.toString(this.values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public static class Flags {
        byte value;
        private static final byte RANGE_EMPTY = 1;
        private static final byte RANGE_LB_INC = 2;
        private static final byte RANGE_UB_INC = 4;
        private static final byte RANGE_LB_INF = 8;
        private static final byte RANGE_UB_INF = 16;
        private static final byte RANGE_LB_NULL = 32;
        private static final byte RANGE_UB_NULL = 64;

        public Flags(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean isEmpty() {
            return (this.value & 1) != 0;
        }

        public boolean hasLowerBound() {
            return (this.value & 0x29) == 0;
        }

        public boolean isLowerBoundInclusive() {
            return (this.value & 2) != 0;
        }

        public boolean isLowerBoundInfinity() {
            return (this.value & 8) != 0;
        }

        public boolean hasUpperBound() {
            return (this.value & 0x51) == 0;
        }

        public boolean isUpperBoundInclusive() {
            return (this.value & 4) != 0;
        }

        public boolean isUpperBoundInfinity() {
            return (this.value & 0x10) != 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Flags other = (Flags)obj;
            return this.value == other.value;
        }
    }
}

