/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import com.impossibl.postgres.utils.guava.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.BitSet;

public class InetAddr {
    protected byte[] address;
    protected short maskBits;

    protected InetAddr(Object[] parts) {
        this((byte[])parts[0], (Short)parts[1]);
    }

    public InetAddr(byte[] address, short maskBits) {
        Preconditions.checkArgument(address.length == 4 || address.length == 16, "invalid address size");
        Preconditions.checkArgument(maskBits <= address.length * 8, "invalid mask bits");
        this.address = address;
        this.maskBits = maskBits;
    }

    public InetAddr(String cidrAddress) throws IllegalArgumentException {
        this(InetAddr.parseN(cidrAddress, true));
    }

    public Family getFamily() {
        return this.address.length == 4 ? Family.IPv4 : Family.IPv6;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public byte[] getMaskAddress() {
        BitSet mask = new BitSet(this.address.length * 8);
        mask.set(0, this.maskBits);
        return mask.toByteArray();
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public void setMaskBits(short maskBits) {
        this.maskBits = maskBits;
    }

    public static InetAddr parseInetAddr(String inetAddr) {
        return InetAddr.parseInetAddr(inetAddr, false);
    }

    public static InetAddr parseInetAddr(String inetAddr, boolean allowShorthandNotation) {
        return InetAddr.parseInetAddr(inetAddr, allowShorthandNotation, inetAddr.indexOf(58) != -1 ? Family.IPv6 : Family.IPv4);
    }

    public static InetAddr parseInetAddr(String inetAddr, boolean allowShortNotation, Family family) {
        return new InetAddr(InetAddr.parseN(inetAddr, allowShortNotation, family));
    }

    protected static Object[] parseN(String inetAddr, boolean allowShortNotation) {
        return InetAddr.parseN(inetAddr, allowShortNotation, inetAddr.indexOf(58) != -1 ? Family.IPv6 : Family.IPv4);
    }

    protected static Object[] parseN(String inetAddr, boolean allowShortNotation, Family family) {
        switch (family) {
            case IPv6: {
                return InetAddr.parse6(inetAddr);
            }
            case IPv4: {
                return InetAddr.parse4(inetAddr, allowShortNotation);
            }
        }
        throw new IllegalArgumentException("unknown family");
    }

    private static Object[] parse4(String ipv4Addr, boolean allowShortNotation) throws IllegalArgumentException {
        if (ipv4Addr == null || ipv4Addr.isEmpty()) {
            throw new IllegalArgumentException("invalid address");
        }
        byte[] dst = new byte[Family.IPv4.getByteSize()];
        short maskBits = 32;
        char[] srcb = ipv4Addr.toCharArray();
        boolean sawDigit = false;
        int octets = 0;
        int i = 0;
        int cur = 0;
        while (i < srcb.length) {
            int sum;
            char ch;
            if (Character.isDigit(ch = srcb[i++])) {
                sum = (dst[cur] & 0xFF) * 10 + (Character.digit(ch, 10) & 0xFF);
                if (sum > 255) {
                    throw new IllegalArgumentException("octet is larger than 255");
                }
                dst[cur] = (byte)(sum & 0xFF);
                if (sawDigit) continue;
                if (++octets > Family.IPv4.getByteSize()) {
                    throw new IllegalArgumentException("too many octets");
                }
                sawDigit = true;
                continue;
            }
            if (ch == '.' && sawDigit) {
                if (octets == Family.IPv4.getByteSize()) {
                    throw new IllegalArgumentException("too many octets");
                }
                dst[++cur] = 0;
                sawDigit = false;
                continue;
            }
            if (ch == '/') {
                maskBits = 0;
                while (i < srcb.length) {
                    if ((sum = (maskBits & 0xFF) * 10 + (Character.digit(ch = srcb[i++], 10) & 0xFF)) > 32) {
                        throw new IllegalArgumentException("mask is larger than 32");
                    }
                    maskBits = (short)sum;
                }
                continue;
            }
            throw new IllegalArgumentException("invalid address");
        }
        if (octets < Family.IPv4.getByteSize() && !allowShortNotation) {
            throw new IllegalArgumentException("invalid # of octets");
        }
        return new Object[]{dst, maskBits};
    }

    private static void format4(byte[] src, int offset, StringBuilder out) {
        out.append(src[offset] & 0xFF);
        out.append('.');
        out.append(src[offset + 1] & 0xFF);
        out.append('.');
        out.append(src[offset + 2] & 0xFF);
        out.append('.');
        out.append(src[offset + 3] & 0xFF);
    }

    private static Object[] parse6(String ipv6Addr) throws IllegalArgumentException {
        if (ipv6Addr == null || ipv6Addr.length() < 2) {
            throw new IllegalArgumentException("invalid length");
        }
        char[] srcb = ipv6Addr.toCharArray();
        int srcbLength = srcb.length;
        byte[] dst = new byte[Family.IPv6.getByteSize()];
        short maskBits = 128;
        int pc = ipv6Addr.indexOf(37);
        if (pc == srcbLength - 1) {
            throw new IllegalArgumentException("invalid address");
        }
        if (pc != -1) {
            srcbLength = pc;
        }
        int i = 0;
        int j = 0;
        if (srcb[i] == ':' && srcb[++i] != ':') {
            throw new IllegalArgumentException("invalid prefix");
        }
        int colonp = -1;
        int curtok = i;
        boolean sawXDigit = false;
        int val = 0;
        while (i < srcbLength) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = srcb[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    throw new IllegalArgumentException("word value too large");
                }
                sawXDigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!sawXDigit) {
                    if (colonp != -1) {
                        throw new IllegalArgumentException("invalid address");
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcbLength) {
                    throw new IllegalArgumentException("invalid address");
                }
                if (j + 2 > Family.IPv6.getByteSize()) {
                    throw new IllegalArgumentException("too many words");
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                sawXDigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + Family.IPv4.getByteSize() <= Family.IPv6.getByteSize()) {
                Object[] ipv4parts;
                String ipv4AddrEmb = ipv6Addr.substring(curtok, srcbLength);
                try {
                    ipv4parts = InetAddr.parse4(ipv4AddrEmb, false);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("invalid embedded IPv4 address");
                }
                if (ipv4parts[1] != null) {
                    throw new IllegalArgumentException("invalid embedded IPv4 address");
                }
                byte[] ipv4Addr = (byte[])ipv4parts[0];
                for (int k = 0; k < Family.IPv4.getByteSize(); ++k) {
                    dst[j++] = ipv4Addr[k];
                }
                sawXDigit = false;
                break;
            }
            if (ch == '/') {
                maskBits = 0;
                while (i < srcb.length) {
                    int sum;
                    if ((sum = (maskBits & 0xFF) * 10 + (Character.digit(ch = srcb[i++], 10) & 0xFF)) > 128) {
                        throw new IllegalArgumentException("mask is larger than 128");
                    }
                    maskBits = (short)sum;
                }
                break;
            }
            throw new IllegalArgumentException("invalid address");
        }
        if (sawXDigit) {
            if (j + 2 > Family.IPv6.getByteSize()) {
                throw new IllegalArgumentException("too many words");
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == Family.IPv6.getByteSize()) {
                throw new IllegalArgumentException("too many words");
            }
            for (i = 1; i <= n; ++i) {
                dst[Family.IPv6.getByteSize() - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = Family.IPv6.getByteSize();
        }
        if (j != Family.IPv6.getByteSize()) {
            throw new IllegalArgumentException("invalid format");
        }
        return new Object[]{dst, maskBits};
    }

    private static void format6(byte[] src, StringBuilder out) {
        boolean embeddedInet4 = src[0] == 0 && src[1] == 0 && src[2] == 0 && src[3] == 0 && src[4] == 0;
        int size = embeddedInet4 ? (Family.IPv6.getByteSize() - Family.IPv4.getByteSize()) / 2 : Family.IPv6.getByteSize() / 2;
        for (int i = 0; i < size; ++i) {
            out.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= size - 1) continue;
            out.append(':');
        }
        if (embeddedInet4) {
            out.append(':');
            InetAddr.format4(src, 12, out);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.address);
        result = 31 * result + this.maskBits;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddr other = (InetAddr)obj;
        if (!Arrays.equals(this.address, other.address)) {
            return false;
        }
        return this.maskBits == other.maskBits;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.address.length == 4) {
            InetAddr.format4(this.address, 0, out);
        } else {
            InetAddr.format6(this.address, out);
        }
        if (this.maskBits != this.address.length * 8) {
            out.append('/').append(this.maskBits);
        }
        return out.toString();
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByAddress(this.address);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Family {
        IPv4(4, 4),
        IPv6(6, 16);

        private int byteSize;
        private int version;

        private Family(int version, int byteSize) {
            this.version = version;
            this.byteSize = byteSize;
        }

        public int getByteSize() {
            return this.byteSize;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

